/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.wire.helper;

import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.configuration.ComponentConfiguration;
import org.eclipse.kura.configuration.metatype.OCDService;
import org.eclipse.kura.internal.wire.helper.WireHelperServiceImpl;
import org.eclipse.kura.wire.graph.WireComponentDefinition;
import org.eclipse.kura.wire.graph.WireComponentDefinitionService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.component.runtime.dto.ComponentDescriptionDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WireComponentDefinitionServiceImpl
implements WireComponentDefinitionService {
    private static final Logger logger = LoggerFactory.getLogger(WireComponentDefinitionServiceImpl.class);
    private static final Pattern DEFAULT_PORT_NAME_PATTERN = Pattern.compile("(in|out)(\\d+)");
    private static final String WIRE_COMPONENT = "org.eclipse.kura.wire.WireComponent";
    private static final String WIRE_EMITTER = "org.eclipse.kura.wire.WireEmitter";
    private static final String WIRE_RECEIVER = "org.eclipse.kura.wire.WireReceiver";

    private static boolean implementsAnyService(ComponentDescriptionDTO component, String[] classes) {
        String[] services = component.serviceInterfaces;
        if (services == null) {
            return false;
        }
        String[] stringArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            String className = stringArray[n2];
            String[] stringArray2 = services;
            int n3 = services.length;
            int n4 = 0;
            while (n4 < n3) {
                String s = stringArray2[n4];
                if (s.equals(className)) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    private Map<Integer, String> parsePortNames(Object rawEncoded, int maxPortCount) {
        block6: {
            if (rawEncoded != null && maxPortCount > 0) break block6;
            return null;
        }
        try {
            String encoded = rawEncoded instanceof String[] ? String.join((CharSequence)"\n", (String[])rawEncoded) : rawEncoded.toString();
            Properties properties = new Properties();
            properties.load(new StringReader(encoded));
            HashMap<Integer, String> result = new HashMap<Integer, String>();
            for (Map.Entry<Object, Object> e : properties.entrySet()) {
                int index = Integer.parseInt(e.getKey().toString());
                String name = e.getValue().toString();
                if (index < 0 || index >= maxPortCount) {
                    logger.warn("Port index out of range: {}", (Object)index);
                    continue;
                }
                if (name == null || name.isEmpty() || DEFAULT_PORT_NAME_PATTERN.matcher(name).matches()) {
                    logger.warn("Invalid port name: {}", (Object)name);
                    continue;
                }
                result.put(index, name);
            }
            return result;
        }
        catch (Exception e) {
            logger.warn("failed to parse port names from: {}", rawEncoded, (Object)e);
            return null;
        }
    }

    private WireComponentDefinition getDefinition(ComponentDescriptionDTO componentDescriptionDTO, ComponentConfiguration ocd) {
        if (componentDescriptionDTO.properties.get("input.cardinality.minimum") != null) {
            return this.getDefinitionFromComponentProperties(componentDescriptionDTO, ocd);
        }
        return this.getDefinitionLegacy(componentDescriptionDTO, ocd);
    }

    private WireComponentDefinition getDefinitionLegacy(ComponentDescriptionDTO componentDescriptionDTO, ComponentConfiguration ocd) {
        WireComponentDefinition wireComponentDefinition = new WireComponentDefinition();
        wireComponentDefinition.setFactoryPid(componentDescriptionDTO.name);
        String[] stringArray = componentDescriptionDTO.serviceInterfaces;
        int n = componentDescriptionDTO.serviceInterfaces.length;
        int n2 = 0;
        while (n2 < n) {
            String service = stringArray[n2];
            if (WIRE_EMITTER.equals(service)) {
                wireComponentDefinition.setMinOutputPorts(1);
                wireComponentDefinition.setMaxOutputPorts(1);
                wireComponentDefinition.setDefaultOutputPorts(1);
            } else if (WIRE_RECEIVER.equals(service)) {
                wireComponentDefinition.setMinInputPorts(1);
                wireComponentDefinition.setMaxInputPorts(1);
                wireComponentDefinition.setDefaultInputPorts(1);
            }
            ++n2;
        }
        wireComponentDefinition.setComponentOCD(ocd);
        return wireComponentDefinition;
    }

    private WireComponentDefinition getDefinitionFromComponentProperties(ComponentDescriptionDTO componentDescriptionDTO, ComponentConfiguration ocd) {
        Map componentProperties = componentDescriptionDTO.properties;
        WireComponentDefinition wireComponentDefinition = new WireComponentDefinition();
        wireComponentDefinition.setFactoryPid(componentDescriptionDTO.name);
        wireComponentDefinition.setMinInputPorts(((Integer)componentProperties.get("input.cardinality.minimum")).intValue());
        wireComponentDefinition.setMaxInputPorts(((Integer)componentProperties.get("input.cardinality.maximum")).intValue());
        wireComponentDefinition.setDefaultInputPorts(((Integer)componentProperties.get("input.cardinality.default")).intValue());
        wireComponentDefinition.setMinOutputPorts(((Integer)componentProperties.get("output.cardinality.minimum")).intValue());
        wireComponentDefinition.setMaxOutputPorts(((Integer)componentProperties.get("output.cardinality.maximum")).intValue());
        wireComponentDefinition.setDefaultOutputPorts(((Integer)componentProperties.get("output.cardinality.default")).intValue());
        wireComponentDefinition.setInputPortNames(this.parsePortNames(componentProperties.get("input.port.names"), wireComponentDefinition.getMaxInputPorts()));
        wireComponentDefinition.setOutputPortNames(this.parsePortNames(componentProperties.get("output.port.names"), wireComponentDefinition.getMaxOutputPorts()));
        wireComponentDefinition.setComponentOCD(ocd);
        return wireComponentDefinition;
    }

    public List<WireComponentDefinition> getComponentDefinitions() throws KuraException {
        BundleContext context = FrameworkUtil.getBundle(WireHelperServiceImpl.class).getBundleContext();
        ServiceReference scrServiceRef = context.getServiceReference(ServiceComponentRuntime.class);
        ServiceReference ocdServiceRef = context.getServiceReference(OCDService.class);
        try {
            OCDService ocdService = (OCDService)context.getService(ocdServiceRef);
            ServiceComponentRuntime scrService = (ServiceComponentRuntime)context.getService(scrServiceRef);
            String[] services = new String[]{WIRE_COMPONENT, WIRE_RECEIVER, WIRE_EMITTER};
            Map componentDefinitions = scrService.getComponentDescriptionDTOs(new Bundle[0]).stream().filter(component -> WireComponentDefinitionServiceImpl.implementsAnyService(component, services)).collect(Collectors.toMap(c -> c.name, Function.identity(), (first, second) -> second));
            Map ocds = ocdService.getServiceProviderOCDs(services).stream().collect(Collectors.toMap(ComponentConfiguration::getPid, Function.identity(), (first, second) -> second));
            List<WireComponentDefinition> list = componentDefinitions.entrySet().stream().map(entry -> this.getDefinition((ComponentDescriptionDTO)entry.getValue(), (ComponentConfiguration)ocds.get(entry.getKey()))).collect(Collectors.toList());
            return list;
        }
        finally {
            context.ungetService(scrServiceRef);
            context.ungetService(ocdServiceRef);
        }
    }
}

