/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.wire.ai.component.provider;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.ai.inference.InferenceEngineService;
import org.eclipse.kura.ai.inference.ModelInfo;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.wire.WireComponent;
import org.eclipse.kura.wire.WireEmitter;
import org.eclipse.kura.wire.WireEnvelope;
import org.eclipse.kura.wire.WireHelperService;
import org.eclipse.kura.wire.WireReceiver;
import org.eclipse.kura.wire.WireRecord;
import org.eclipse.kura.wire.WireSupport;
import org.eclipse.kura.wire.ai.component.provider.AIComponentOptions;
import org.eclipse.kura.wire.ai.component.provider.TensorListAdapter;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.ComponentException;
import org.osgi.service.wireadmin.Wire;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AIComponent
implements WireEmitter,
WireReceiver,
ConfigurableComponent {
    private static final Logger logger = LoggerFactory.getLogger(AIComponent.class);
    private WireHelperService wireHelperService;
    private WireSupport wireSupport;
    private AIComponentOptions options;
    private InferenceEngineService inferenceEngineService;
    private Optional<ModelInfo> infoPre;
    private Optional<ModelInfo> infoInfer;
    private Optional<ModelInfo> infoPost;

    public void bindWireHelperService(WireHelperService wireHelperService) {
        if (this.wireHelperService == null) {
            this.wireHelperService = wireHelperService;
        }
    }

    public void unbindWireHelperService(WireHelperService wireHelperService) {
        if (this.wireHelperService == wireHelperService) {
            this.wireHelperService = null;
        }
    }

    public void bindInferenceEngineService(InferenceEngineService inferenceEngineService) {
        this.inferenceEngineService = inferenceEngineService;
    }

    public void unbindInferenceEngineService(InferenceEngineService inferenceEngineService) {
        if (this.inferenceEngineService == inferenceEngineService) {
            this.inferenceEngineService = inferenceEngineService;
        }
    }

    public void activate(ComponentContext componentContext, Map<String, Object> properties) throws ComponentException {
        logger.info("Activating AIComponent...");
        this.wireSupport = this.wireHelperService.newWireSupport((WireComponent)this, componentContext.getServiceReference());
        this.updated(properties);
        logger.info("Activating AIComponent... Done");
    }

    public void deactivate() {
        logger.info("Deactivating AIComponent...");
        logger.info("Deactivating AIComponent... Done.");
    }

    public synchronized void updated(Map<String, Object> properties) {
        logger.info("Updating AIComponent...");
        this.options = new AIComponentOptions(properties);
        this.infoPre = Optional.empty();
        this.infoInfer = Optional.empty();
        this.infoPost = Optional.empty();
        try {
            this.loadModelInfos();
            logger.info("Updating AIComponent... Done");
        }
        catch (KuraException e) {
            logger.error("Inference Engine error.", (Throwable)e);
        }
    }

    public synchronized void onWireReceive(WireEnvelope wireEnvelope) {
        Objects.requireNonNull(wireEnvelope, "Wire Envelope cannot be null");
        for (WireRecord wireRecord : wireEnvelope.getRecords()) {
            try {
                Optional<List<WireRecord>> inferenceResult = this.inferenceProcess(wireRecord);
                if (!inferenceResult.isPresent()) continue;
                this.wireSupport.emit(inferenceResult.get());
            }
            catch (KuraException e) {
                logger.error("Error processing WireRecord.", (Throwable)e);
            }
        }
    }

    public Object polled(Wire wire) {
        return this.wireSupport.polled(wire);
    }

    public void consumersConnected(Wire[] wires) {
        this.wireSupport.consumersConnected(wires);
    }

    public void updated(Wire wire, Object value) {
        this.wireSupport.updated(wire, value);
    }

    public void producersConnected(Wire[] wires) {
        this.wireSupport.producersConnected(wires);
    }

    private void loadModelInfos() throws KuraException {
        if (this.inferenceEngineService != null && this.inferenceEngineService.isEngineReady()) {
            Optional<String> namePost;
            Optional<String> namePre = this.options.getPreprocessorModelName();
            if (namePre.isPresent() && !this.infoPre.isPresent()) {
                this.infoPre = this.retrieveModelInfo(namePre.get());
            }
            if (!this.infoInfer.isPresent()) {
                this.infoInfer = this.retrieveModelInfo(this.options.getInferenceModelName());
            }
            if ((namePost = this.options.getPostprocessorModelName()).isPresent() && !this.infoPost.isPresent()) {
                this.infoPost = this.retrieveModelInfo(namePost.get());
            }
        } else {
            logger.info("Selected InferenceEngineService not ready yet.");
        }
    }

    private Optional<ModelInfo> retrieveModelInfo(String modelName) throws KuraException {
        Optional info;
        if (this.inferenceEngineService.isModelLoaded(modelName)) {
            this.inferenceEngineService.loadModel(modelName, Optional.empty());
        }
        if (!(info = this.inferenceEngineService.getModelInfo(modelName)).isPresent()) {
            throw new KuraException(KuraErrorCode.INVALID_PARAMETER);
        }
        return info;
    }

    private Optional<List<WireRecord>> inferenceProcess(WireRecord wireRecord) throws KuraException {
        if (this.inferenceEngineService != null && this.inferenceEngineService.isEngineReady()) {
            List tensors;
            this.loadModelInfos();
            LinkedList<WireRecord> result = new LinkedList<WireRecord>();
            if (this.infoPre.isPresent()) {
                tensors = TensorListAdapter.givenDescriptors(this.infoPre.get().getInputs()).fromWireRecord(wireRecord);
                tensors = this.inferenceEngineService.infer(this.infoPre.get(), tensors);
            } else {
                tensors = TensorListAdapter.givenDescriptors(this.infoInfer.get().getInputs()).fromWireRecord(wireRecord);
            }
            tensors = this.inferenceEngineService.infer(this.infoInfer.get(), tensors);
            if (this.infoPost.isPresent()) {
                tensors = this.inferenceEngineService.infer(this.infoPost.get(), tensors);
                result.addAll(TensorListAdapter.givenDescriptors(this.infoPost.get().getOutputs()).fromTensorList(tensors));
            } else {
                result.addAll(TensorListAdapter.givenDescriptors(this.infoInfer.get().getOutputs()).fromTensorList(tensors));
            }
            return Optional.of(result);
        }
        logger.info("Selected InferenceEngineService not ready yet.");
        return Optional.empty();
    }
}

