/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.net;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.configuration.Password;
import org.eclipse.kura.core.net.AbstractNetInterface;
import org.eclipse.kura.core.net.EthernetInterfaceConfigImpl;
import org.eclipse.kura.core.net.IpConfigurationInterpreter;
import org.eclipse.kura.core.net.LoopbackInterfaceConfigImpl;
import org.eclipse.kura.core.net.ModemConfigurationInterpreter;
import org.eclipse.kura.core.net.NetInterfaceAddressConfigImpl;
import org.eclipse.kura.core.net.NetworkConfigurationVisitor;
import org.eclipse.kura.core.net.WifiConfigurationInterpreter;
import org.eclipse.kura.core.net.WifiInterfaceAddressConfigImpl;
import org.eclipse.kura.core.net.WifiInterfaceConfigImpl;
import org.eclipse.kura.core.net.modem.ModemInterfaceAddressConfigImpl;
import org.eclipse.kura.core.net.modem.ModemInterfaceConfigImpl;
import org.eclipse.kura.core.net.util.NetworkUtil;
import org.eclipse.kura.net.IP4Address;
import org.eclipse.kura.net.IP6Address;
import org.eclipse.kura.net.NetConfig;
import org.eclipse.kura.net.NetConfigIP4;
import org.eclipse.kura.net.NetConfigIP6;
import org.eclipse.kura.net.NetInterfaceAddress;
import org.eclipse.kura.net.NetInterfaceAddressConfig;
import org.eclipse.kura.net.NetInterfaceConfig;
import org.eclipse.kura.net.NetInterfaceType;
import org.eclipse.kura.net.dhcp.DhcpServerConfig;
import org.eclipse.kura.net.dhcp.DhcpServerConfig4;
import org.eclipse.kura.net.firewall.FirewallAutoNatConfig;
import org.eclipse.kura.net.modem.ModemConfig;
import org.eclipse.kura.net.modem.ModemInterfaceAddress;
import org.eclipse.kura.net.wifi.WifiConfig;
import org.eclipse.kura.net.wifi.WifiInterfaceAddress;
import org.eclipse.kura.net.wifi.WifiMode;
import org.eclipse.kura.net.wifi.WifiSecurity;
import org.eclipse.kura.usb.UsbDevice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkConfiguration {
    private static final String WIFI_CHANNELS_KEY = ".channel";
    private static final String WIFI_IGNORE_SSID_KEY = ".ignoreSSID";
    private static final String WIFI_PING_ACCESS_POINT_KEY = ".pingAccessPoint";
    private static final String WIFI_RADIO_MODE_KEY = ".radioMode";
    private static final String WIFI_GROUP_CIPHERS_KEY = ".groupCiphers";
    private static final String WIFI_PAIRWISE_CIPHERS_KEY = ".pairwiseCiphers";
    private static final String WIFI_MODE_KEY = ".mode";
    private static final String DRIVER_KEY = ".driver";
    private static final String WIFI_SSID_KEY = ".ssid";
    private static final Logger logger = LoggerFactory.getLogger(NetworkConfiguration.class);
    private static final String ADDRESS = " :: Address: ";
    private static final String BGSCAN = ".bgscan";
    private static final String WIFI_PASSPHRASE_KEY = ".passphrase";
    private static final String SECURITY_TYPE = ".securityType";
    private static final String NET_INTERFACE = "net.interface.";
    private static final String NET_INTERFACES = "net.interfaces";
    private final Map<String, NetInterfaceConfig<? extends NetInterfaceAddressConfig>> netInterfaceConfigs;
    private Map<String, Object> properties;
    private boolean recomputeProperties;
    private List<String> modifiedInterfaceNames;

    public NetworkConfiguration() {
        logger.debug("Created empty NetworkConfiguration");
        this.netInterfaceConfigs = new HashMap<String, NetInterfaceConfig<? extends NetInterfaceAddressConfig>>();
    }

    /*
     * Unable to fully structure code
     */
    public NetworkConfiguration(Map<String, Object> properties) throws UnknownHostException, KuraException {
        block8: {
            super();
            NetworkConfiguration.logger.debug("Creating NetworkConfiguration from properties");
            this.netInterfaceConfigs = new HashMap<String, NetInterfaceConfig<? extends NetInterfaceAddressConfig>>();
            availableInterfaces = null;
            try {
                availableInterfaces = (String[])properties.get("net.interfaces");
                break block8;
            }
            catch (ClassCastException v0) {
                interfaces = (String)properties.get("net.interfaces");
                st = new StringTokenizer(interfaces, ",");
                interfacesArray = new ArrayList<String>();
                ** while (st.hasMoreTokens())
            }
lbl-1000:
            // 1 sources

            {
                interfacesArray.add(st.nextToken());
                continue;
            }
lbl16:
            // 1 sources

            availableInterfaces = interfacesArray.toArray(new String[interfacesArray.size()]);
        }
        if (availableInterfaces != null) {
            NetworkConfiguration.logger.debug("There are {} interfaces to add to the new configuration", (Object)availableInterfaces.length);
            var6_9 = availableInterfaces;
            var5_7 = availableInterfaces.length;
            st = 0;
            while (st < var5_7) {
                currentNetInterface = var6_9[st];
                keyBuffer = new StringBuilder();
                keyBuffer.append("net.interface.").append(currentNetInterface).append(".type");
                type = NetInterfaceType.UNKNOWN;
                if (properties.get(keyBuffer.toString()) != null) {
                    type = NetInterfaceType.valueOf((String)((String)properties.get(keyBuffer.toString())));
                }
                NetworkConfiguration.logger.trace("Adding interface: {} of type {}", (Object)currentNetInterface, (Object)type);
                this.addInterfaceConfiguration(currentNetInterface, type, properties);
                ++st;
            }
        }
        this.modifiedInterfaceNames = new ArrayList<String>();
        modifiedInterfaces = (String)properties.get("modified.interface.names");
        if (modifiedInterfaces != null) {
            var7_11 = modifiedInterfaces.split(",");
            var6_10 = var7_11.length;
            var5_8 = 0;
            while (var5_8 < var6_10) {
                interfaceName = var7_11[var5_8];
                this.modifiedInterfaceNames.add(interfaceName);
                ++var5_8;
            }
        }
        this.recomputeProperties = true;
    }

    public void setModifiedInterfaceNames(List<String> modifiedInterfaceNames) {
        if (modifiedInterfaceNames != null && !modifiedInterfaceNames.isEmpty()) {
            this.modifiedInterfaceNames = modifiedInterfaceNames;
            this.recomputeProperties = true;
        }
    }

    public List<String> getModifiedInterfaceNames() {
        return this.modifiedInterfaceNames;
    }

    public void accept(NetworkConfigurationVisitor visitor) throws KuraException {
        visitor.visit(this);
    }

    public void addNetInterfaceConfig(NetInterfaceConfig<? extends NetInterfaceAddressConfig> netInterfaceConfig) {
        this.netInterfaceConfigs.put(netInterfaceConfig.getName(), netInterfaceConfig);
        this.recomputeProperties = true;
    }

    public void addNetConfig(String interfaceName, NetInterfaceType netInterfaceType, NetConfig netConfig) throws KuraException {
        AbstractNetInterface netInterfaceConfig = this.netInterfaceConfigs.get(interfaceName);
        if (netInterfaceConfig == null) {
            switch (netInterfaceType) {
                case LOOPBACK: {
                    netInterfaceConfig = new LoopbackInterfaceConfigImpl(interfaceName);
                    break;
                }
                case ETHERNET: {
                    netInterfaceConfig = new EthernetInterfaceConfigImpl(interfaceName);
                    break;
                }
                case WIFI: {
                    netInterfaceConfig = new WifiInterfaceConfigImpl(interfaceName);
                    break;
                }
                case MODEM: {
                    netInterfaceConfig = new ModemInterfaceConfigImpl(interfaceName);
                    break;
                }
                default: {
                    throw new KuraException(KuraErrorCode.INVALID_PARAMETER);
                }
            }
        }
        List netInterfaceAddressConfigs = netInterfaceConfig.getNetInterfaceAddresses();
        logger.trace("Adding a netConfig: {}", (Object)netConfig);
        for (NetInterfaceAddressConfig netInterfaceAddressConfig : netInterfaceAddressConfigs) {
            List netConfigs = netInterfaceAddressConfig.getConfigs();
            netConfigs.add(netConfig);
        }
        this.recomputeProperties = true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator<String> it = this.netInterfaceConfigs.keySet().iterator();
        while (it.hasNext()) {
            NetInterfaceConfig<? extends NetInterfaceAddressConfig> netInterfaceConfig = this.netInterfaceConfigs.get(it.next());
            sb.append("\nname: " + netInterfaceConfig.getName());
            sb.append(" :: Loopback? " + netInterfaceConfig.isLoopback());
            sb.append(" :: Point to Point? " + netInterfaceConfig.isPointToPoint());
            sb.append(" :: Up? " + netInterfaceConfig.isUp());
            sb.append(" :: Virtual? " + netInterfaceConfig.isVirtual());
            sb.append(" :: Driver: " + netInterfaceConfig.getDriver());
            sb.append(" :: Driver Version: " + netInterfaceConfig.getDriverVersion());
            sb.append(" :: Firmware Version: " + netInterfaceConfig.getFirmwareVersion());
            sb.append(" :: MTU: " + netInterfaceConfig.getMTU());
            if (netInterfaceConfig.getHardwareAddress() != null) {
                sb.append(" :: Hardware Address: " + NetworkUtil.macToString(netInterfaceConfig.getHardwareAddress()));
            }
            sb.append(" :: State: " + netInterfaceConfig.getState());
            sb.append(" :: Type: " + netInterfaceConfig.getType());
            sb.append(" :: Usb Device: " + netInterfaceConfig.getUsbDevice());
            this.appendAddresses(sb, netInterfaceConfig);
            List netInterfaceAddressConfigs = netInterfaceConfig.getNetInterfaceAddresses();
            if (netInterfaceAddressConfigs == null) continue;
            netInterfaceAddressConfigs.forEach(netInterfaceAddressConfig -> {
                List netConfigs = netInterfaceAddressConfig.getConfigs();
                if (netConfigs != null) {
                    netConfigs.forEach(netConfig -> this.appendNetworkConfig(sb, (NetConfig)netConfig));
                }
            });
        }
        return sb.toString();
    }

    protected void appendNetworkConfig(StringBuilder sb, NetConfig netConfig) {
        if (netConfig instanceof NetConfigIP4) {
            this.appendNetConfigIP4(sb, netConfig);
        } else if (netConfig instanceof NetConfigIP6) {
            this.appendNetConfigIP6(sb, netConfig);
        } else if (netConfig instanceof WifiConfig) {
            this.appendWifiConfig(sb, netConfig);
        } else if (netConfig instanceof ModemConfig) {
            this.appendModemConfig(sb, netConfig);
        } else if (netConfig instanceof DhcpServerConfig) {
            this.appendDhcpServerConfig(sb, netConfig);
        } else if (netConfig instanceof FirewallAutoNatConfig) {
            sb.append("\n\tFirewallAutoNatConfig ");
        } else if (netConfig != null && netConfig.getClass() != null) {
            sb.append("\n\tUNKNOWN CONFIG TYPE???: " + netConfig.getClass().getName());
        } else {
            sb.append("\n\tNULL NETCONFIG PRESENT?!?");
        }
    }

    protected void appendAddresses(StringBuilder sb, NetInterfaceConfig<? extends NetInterfaceAddressConfig> netInterfaceConfig) {
        List netInterfaceAddresses = netInterfaceConfig.getNetInterfaceAddresses();
        for (NetInterfaceAddress netInterfaceAddress : netInterfaceAddresses) {
            if (netInterfaceAddress.getAddress() != null) {
                sb.append(ADDRESS + netInterfaceAddress.getAddress().getHostAddress());
            }
            sb.append(" :: Prefix: " + netInterfaceAddress.getNetworkPrefixLength());
            if (netInterfaceAddress.getNetmask() != null) {
                sb.append(" :: Netmask: " + netInterfaceAddress.getNetmask().getHostAddress());
            }
            if (netInterfaceAddress.getBroadcast() == null) continue;
            sb.append(" :: Broadcast: " + netInterfaceAddress.getBroadcast().getHostAddress());
        }
    }

    protected void appendModemConfig(StringBuilder sb, NetConfig netConfig) {
        sb.append("\n\tModemConfig ");
        sb.append(" :: APN: " + ((ModemConfig)netConfig).getApn());
        sb.append(" :: Data Compression: " + ((ModemConfig)netConfig).getDataCompression());
        sb.append(" :: Dial String: " + ((ModemConfig)netConfig).getDialString());
        sb.append(" :: Header Compression: " + ((ModemConfig)netConfig).getHeaderCompression());
        sb.append(" :: PPP number: " + ((ModemConfig)netConfig).getPppNumber());
        sb.append(" :: Profile ID: " + ((ModemConfig)netConfig).getProfileID());
        sb.append(" :: Username: " + ((ModemConfig)netConfig).getUsername());
        sb.append(" :: Auth Type: " + ((ModemConfig)netConfig).getAuthType());
        sb.append(" :: IP Address: " + ((ModemConfig)netConfig).getIpAddress());
        sb.append(" :: PDP Type: " + ((ModemConfig)netConfig).getPdpType());
        sb.append(" :: Gps enabled: " + ((ModemConfig)netConfig).isGpsEnabled());
        sb.append(" :: Antenna diversity enabled: " + ((ModemConfig)netConfig).isDiversityEnabled());
    }

    protected void appendWifiConfig(StringBuilder sb, NetConfig netConfig) {
        sb.append("\n\tWifiConfig ");
        sb.append(" :: SSID: " + ((WifiConfig)netConfig).getSSID());
        sb.append(" :: BgScan: " + ((WifiConfig)netConfig).getBgscan());
        int[] channels = ((WifiConfig)netConfig).getChannels();
        if (channels != null && channels.length > 0) {
            sb.append(" :: Channels: ");
            int i = 0;
            while (i < channels.length) {
                sb.append(channels[i]);
                if (i + 1 < channels.length) {
                    sb.append(",");
                }
                ++i;
            }
        }
        sb.append(" :: Group Ciphers: " + ((WifiConfig)netConfig).getGroupCiphers());
        sb.append(" :: Hardware Mode: " + ((WifiConfig)netConfig).getHardwareMode());
        sb.append(" :: Mode: " + ((WifiConfig)netConfig).getMode());
        sb.append(" :: Pairwise Ciphers: " + ((WifiConfig)netConfig).getPairwiseCiphers());
        sb.append(" :: Security: " + ((WifiConfig)netConfig).getSecurity());
    }

    protected void appendNetConfigIP6(StringBuilder sb, NetConfig netConfig) {
        sb.append("\n\tIPv6 ");
        if (((NetConfigIP6)netConfig).isDhcp()) {
            sb.append(" :: is DHCP client");
            Map dhcp6Map = ((NetConfigIP6)netConfig).getProperties();
            for (String dhcpKey : dhcp6Map.keySet()) {
                sb.append(" :: " + dhcpKey + ": " + dhcp6Map.get(dhcpKey));
            }
        } else {
            sb.append(" :: is STATIC client");
            if (((NetConfigIP6)netConfig).getAddress() != null) {
                sb.append(ADDRESS + ((IP6Address)((NetConfigIP6)netConfig).getAddress()).getHostAddress());
            }
            List dnsServers = ((NetConfigIP6)netConfig).getDnsServers();
            List domains = ((NetConfigIP6)netConfig).getDomains();
            for (IP6Address dnsServer : dnsServers) {
                sb.append(" :: DNS : " + dnsServer.getHostAddress());
            }
            for (String domain : domains) {
                sb.append(" :: Domains : " + domain);
            }
        }
    }

    protected void appendNetConfigIP4(StringBuilder sb, NetConfig netConfig) {
        sb.append("\n\tIPv4 ");
        if (((NetConfigIP4)netConfig).isDhcp()) {
            this.appendDhcpConfig(sb, netConfig);
        } else if (((NetConfigIP4)netConfig).getAddress() == null) {
            sb.append(" :: is not configured for STATIC or DHCP");
        } else {
            this.appendStaticConfig(sb, netConfig);
        }
    }

    protected void appendStaticConfig(StringBuilder sb, NetConfig netConfig) {
        sb.append(" :: is STATIC client");
        if (((NetConfigIP4)netConfig).getAddress() != null) {
            sb.append(ADDRESS + ((IP4Address)((NetConfigIP4)netConfig).getAddress()).getHostAddress());
        }
        sb.append(" :: Prefix: " + ((NetConfigIP4)netConfig).getNetworkPrefixLength());
        if (((NetConfigIP4)netConfig).getGateway() != null) {
            sb.append(" :: Gateway: " + ((IP4Address)((NetConfigIP4)netConfig).getGateway()).getHostAddress());
        }
        List dnsServers = ((NetConfigIP4)netConfig).getDnsServers();
        List winsServers = ((NetConfigIP4)netConfig).getWinsServers();
        List domains = ((NetConfigIP4)netConfig).getDomains();
        if (dnsServers != null) {
            for (IP4Address dnsServer : dnsServers) {
                sb.append(" :: DNS : " + dnsServer.getHostAddress());
            }
        }
        if (winsServers != null) {
            for (IP4Address winsServer : winsServers) {
                sb.append(" :: WINS Server : " + winsServer.getHostAddress());
            }
        }
        if (domains != null) {
            for (String domain : domains) {
                sb.append(" :: Domains : " + domain);
            }
        }
    }

    protected void appendDhcpConfig(StringBuilder sb, NetConfig netConfig) {
        sb.append(" :: is DHCP client");
        Map dhcp4Map = ((NetConfigIP4)netConfig).getProperties();
        for (Map.Entry entry : dhcp4Map.entrySet()) {
            String dhcpKey = (String)entry.getKey();
            sb.append(" :: " + dhcpKey + ": " + entry.getValue());
        }
    }

    protected void appendDhcpServerConfig(StringBuilder sb, NetConfig netConfig) {
        sb.append("\n\tDhcpServerConfig :: \n");
        sb.append(((DhcpServerConfig)netConfig).toString());
    }

    public List<NetInterfaceConfig<? extends NetInterfaceAddressConfig>> getModifiedNetInterfaceConfigs() {
        List<NetInterfaceConfig<? extends NetInterfaceAddressConfig>> newNetInterfaceConfigs = null;
        if (this.modifiedInterfaceNames != null && !this.modifiedInterfaceNames.isEmpty()) {
            newNetInterfaceConfigs = new ArrayList<NetInterfaceConfig<? extends NetInterfaceAddressConfig>>();
            for (String interfaceName : this.modifiedInterfaceNames) {
                NetInterfaceConfig<? extends NetInterfaceAddressConfig> netInterfaceConfig = this.netInterfaceConfigs.get(interfaceName);
                if (netInterfaceConfig == null) continue;
                newNetInterfaceConfigs.add(this.netInterfaceConfigs.get(interfaceName));
            }
        } else {
            newNetInterfaceConfigs = this.getNetInterfaceConfigs();
        }
        return newNetInterfaceConfigs;
    }

    public List<NetInterfaceConfig<? extends NetInterfaceAddressConfig>> getNetInterfaceConfigs() {
        ArrayList<NetInterfaceConfig<? extends NetInterfaceAddressConfig>> newNetInterfaceConfigs = new ArrayList<NetInterfaceConfig<? extends NetInterfaceAddressConfig>>();
        Iterator<String> it = this.netInterfaceConfigs.keySet().iterator();
        while (it.hasNext()) {
            newNetInterfaceConfigs.add(this.netInterfaceConfigs.get(it.next()));
        }
        return newNetInterfaceConfigs;
    }

    public NetInterfaceConfig<? extends NetInterfaceAddressConfig> getNetInterfaceConfig(String interfaceName) {
        return this.netInterfaceConfigs.get(interfaceName);
    }

    public Map<String, Object> getConfigurationProperties() {
        if (this.recomputeProperties) {
            this.recomputeNetworkProperties();
            this.recomputeProperties = false;
        }
        return this.properties;
    }

    public boolean isValid() {
        Iterator<String> it = this.netInterfaceConfigs.keySet().iterator();
        if (it.hasNext()) {
            NetInterfaceConfig<? extends NetInterfaceAddressConfig> netInterfaceConfig = this.netInterfaceConfigs.get(it.next());
            if (netInterfaceConfig.getMTU() < 0) {
                logger.error("MTU must be greater than 0");
                return false;
            }
            NetInterfaceType type = netInterfaceConfig.getType();
            if (type != NetInterfaceType.ETHERNET && type != NetInterfaceType.WIFI && type != NetInterfaceType.MODEM && type != NetInterfaceType.LOOPBACK) {
                logger.error("Type must be ETHERNET, WIFI, MODEM, or LOOPBACK - type is {}", (Object)type);
                return false;
            }
            List netInterfaceAddressConfigs = netInterfaceConfig.getNetInterfaceAddresses();
            return this.isNetInterfaceAddressConfigValid(netInterfaceAddressConfigs);
        }
        return true;
    }

    private boolean isNetInterfaceAddressConfigValid(List<? extends NetInterfaceAddressConfig> netInterfaceAddressConfigs) {
        boolean isValid = true;
        block0: for (NetInterfaceAddressConfig netInterfaceAddressConfig : netInterfaceAddressConfigs) {
            List netConfigs = netInterfaceAddressConfig.getConfigs();
            if (netConfigs == null) continue;
            for (NetConfig netConfig : netConfigs) {
                if (netConfig.isValid()) continue;
                logger.error("Invalid config {}", (Object)netConfig);
                isValid = false;
                continue block0;
            }
        }
        return isValid;
    }

    private void recomputeNetworkProperties() {
        HashMap<String, Object> newNetworkProperties = new HashMap<String, Object>();
        StringBuilder sbInterfaces = new StringBuilder();
        this.addModifiedInterfaceNames(newNetworkProperties);
        Iterator<String> it = this.netInterfaceConfigs.keySet().iterator();
        while (it.hasNext()) {
            NetInterfaceConfig<? extends NetInterfaceAddressConfig> netInterfaceConfig = this.netInterfaceConfigs.get(it.next());
            if (sbInterfaces.length() != 0) {
                sbInterfaces.append(",");
            }
            sbInterfaces.append(netInterfaceConfig.getName());
            StringBuilder sbPrefix = new StringBuilder(NET_INTERFACE).append(netInterfaceConfig.getName()).append(".");
            String netIfReadOnlyPrefix = sbPrefix.toString();
            String netIfPrefix = sbPrefix.append("config.").toString();
            String netIfConfigPrefix = sbPrefix.toString();
            newNetworkProperties.put(String.valueOf(netIfReadOnlyPrefix) + "type", netInterfaceConfig.getType().toString());
            netInterfaceConfig.getNetInterfaceAddresses().forEach(nia -> {
                if (nia != null) {
                    this.addWifiModeProperty((Map<String, Object>)newNetworkProperties, netIfPrefix, (NetInterfaceAddressConfig)nia);
                    this.addModemConnectionProperty((Map<String, Object>)newNetworkProperties, netIfConfigPrefix, (NetInterfaceAddressConfig)nia);
                }
            });
            this.addNetConfigProperties(newNetworkProperties, netInterfaceConfig, netIfConfigPrefix);
        }
        newNetworkProperties.put(NET_INTERFACES, sbInterfaces.toString());
        this.properties = newNetworkProperties;
    }

    private void addNetConfigProperties(Map<String, Object> newNetworkProperties, NetInterfaceConfig<? extends NetInterfaceAddressConfig> netInterfaceConfig, String netIfConfigPrefix) {
        List netInterfaceAddressConfigs = netInterfaceConfig.getNetInterfaceAddresses();
        logger.trace("netInterfaceAddressConfigs.size() for {}: {}", (Object)netInterfaceConfig.getName(), (Object)netInterfaceAddressConfigs.size());
        for (NetInterfaceAddressConfig netInterfaceAddressConfig : netInterfaceAddressConfigs) {
            List netConfigs = netInterfaceAddressConfig.getConfigs();
            if (netConfigs == null) continue;
            logger.trace("netConfigs.size(): {}", (Object)netConfigs.size());
            for (NetConfig netConfig : netConfigs) {
                if (netConfig instanceof WifiConfig) {
                    logger.trace("adding netconfig WifiConfigIP4 for {}", (Object)netInterfaceConfig.getName());
                    NetworkConfiguration.addWifiConfigIP4Properties((WifiConfig)netConfig, netIfConfigPrefix, newNetworkProperties);
                    continue;
                }
                if (netConfig instanceof ModemConfig) {
                    logger.trace("adding netconfig ModemConfig for {}", (Object)netInterfaceConfig.getName());
                    this.addModemConfigProperties((ModemConfig)netConfig, netIfConfigPrefix, newNetworkProperties);
                    continue;
                }
                if (netConfig instanceof NetConfigIP4) {
                    logger.trace("adding netconfig NetConfigIP4 for {}", (Object)netInterfaceConfig.getName());
                    NetworkConfiguration.addNetConfigIP4Properties((NetConfigIP4)netConfig, netIfConfigPrefix, newNetworkProperties);
                    continue;
                }
                if (netConfig instanceof NetConfigIP6) {
                    logger.trace("adding netconfig NetConfigIP6 for {}", (Object)netInterfaceConfig.getName());
                    NetworkConfiguration.addNetConfigIP6Properties((NetConfigIP6)netConfig, netIfConfigPrefix, newNetworkProperties);
                    continue;
                }
                if (netConfig instanceof DhcpServerConfig4) {
                    logger.trace("adding netconfig DhcpServerConfig4 for {}", (Object)netInterfaceConfig.getName());
                    this.addDhcpServerConfig4((DhcpServerConfig4)netConfig, netIfConfigPrefix, newNetworkProperties);
                    continue;
                }
                if (!(netConfig instanceof FirewallAutoNatConfig)) continue;
                logger.trace("adding netconfig FirewallNatConfig for {}", (Object)netInterfaceConfig.getName());
                NetworkConfiguration.addFirewallNatConfig(netIfConfigPrefix, newNetworkProperties);
            }
        }
    }

    private void addModemConnectionProperty(Map<String, Object> newNetworkProperties, String netIfConfigPrefix, NetInterfaceAddressConfig nia) {
        if (nia instanceof ModemInterfaceAddress && ((ModemInterfaceAddress)nia).getConnectionStatus() != null) {
            newNetworkProperties.put(String.valueOf(netIfConfigPrefix) + "connection.status", ((ModemInterfaceAddress)nia).getConnectionStatus().toString());
        }
    }

    private void addWifiModeProperty(Map<String, Object> newNetworkProperties, String netIfPrefix, NetInterfaceAddressConfig nia) {
        if (nia instanceof WifiInterfaceAddress) {
            WifiMode wifiMode = ((WifiInterfaceAddress)nia).getMode() != null ? ((WifiInterfaceAddress)nia).getMode() : WifiMode.UNKNOWN;
            newNetworkProperties.put(String.valueOf(netIfPrefix) + "wifi.mode", wifiMode.toString());
        }
    }

    private void addModifiedInterfaceNames(Map<String, Object> newNetworkProperties) {
        if (this.modifiedInterfaceNames != null && !this.modifiedInterfaceNames.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            String prefix = "";
            for (String interfaceName : this.modifiedInterfaceNames) {
                sb.append(prefix);
                prefix = ",";
                sb.append(interfaceName);
            }
            String result = sb.toString();
            logger.debug("Set modified interface names: {}", (Object)result);
            newNetworkProperties.put("modified.interface.names", result);
        }
    }

    private static void addWifiConfigIP4Properties(WifiConfig wifiConfig, String netIfConfigPrefix, Map<String, Object> properties) {
        WifiMode mode = wifiConfig.getMode();
        if (mode == null) {
            logger.trace("WifiMode is null - could not add wifiConfig: {}", (Object)wifiConfig);
            return;
        }
        String prefix = netIfConfigPrefix + "wifi." + mode.toString().toLowerCase();
        properties.put(String.valueOf(prefix) + WIFI_SSID_KEY, wifiConfig.getSSID());
        properties.put(String.valueOf(prefix) + DRIVER_KEY, wifiConfig.getDriver());
        properties.put(String.valueOf(prefix) + WIFI_MODE_KEY, wifiConfig.getMode().toString());
        if (wifiConfig.getSecurity() != null) {
            properties.put(String.valueOf(prefix) + SECURITY_TYPE, wifiConfig.getSecurity().toString());
        } else {
            properties.put(String.valueOf(prefix) + SECURITY_TYPE, WifiSecurity.NONE.toString());
        }
        properties.put(String.valueOf(prefix) + WIFI_CHANNELS_KEY, NetworkConfiguration.serializeWifiChannels(wifiConfig));
        Password psswd = wifiConfig.getPasskey();
        if (psswd != null) {
            properties.put(String.valueOf(prefix) + WIFI_PASSPHRASE_KEY, psswd);
        } else {
            properties.put(String.valueOf(prefix) + WIFI_PASSPHRASE_KEY, new Password(""));
        }
        if (wifiConfig.getRadioMode() != null) {
            properties.put(String.valueOf(prefix) + WIFI_RADIO_MODE_KEY, wifiConfig.getRadioMode().toString());
        }
        if (wifiConfig.getBgscan() != null) {
            properties.put(String.valueOf(prefix) + BGSCAN, wifiConfig.getBgscan().toString());
        } else {
            properties.put(String.valueOf(prefix) + BGSCAN, "");
        }
        if (wifiConfig.getPairwiseCiphers() != null) {
            properties.put(String.valueOf(prefix) + WIFI_PAIRWISE_CIPHERS_KEY, wifiConfig.getPairwiseCiphers().name());
        }
        if (wifiConfig.getGroupCiphers() != null) {
            properties.put(String.valueOf(prefix) + WIFI_GROUP_CIPHERS_KEY, wifiConfig.getGroupCiphers().name());
        }
        properties.put(String.valueOf(prefix) + WIFI_PING_ACCESS_POINT_KEY, wifiConfig.pingAccessPoint());
        properties.put(String.valueOf(prefix) + WIFI_IGNORE_SSID_KEY, wifiConfig.ignoreSSID());
    }

    private static String serializeWifiChannels(WifiConfig wifiConfig) {
        int[] channels = wifiConfig.getChannels();
        StringBuilder sbChannel = new StringBuilder();
        if (channels != null) {
            int i = 0;
            while (i < channels.length) {
                sbChannel.append(channels[i]);
                if (i < channels.length - 1) {
                    sbChannel.append(' ');
                }
                ++i;
            }
        }
        return sbChannel.toString();
    }

    private void addModemConfigProperties(ModemConfig modemConfig, String prefix, Map<String, Object> properties) {
        properties.put(String.valueOf(prefix) + "apn", modemConfig.getApn());
        properties.put(String.valueOf(prefix) + "authType", modemConfig.getAuthType() != null ? modemConfig.getAuthType().toString() : "");
        properties.put(String.valueOf(prefix) + "dialString", modemConfig.getDialString());
        properties.put(String.valueOf(prefix) + "ipAddress", modemConfig.getIpAddress() != null ? modemConfig.getIpAddress().toString() : "");
        properties.put(String.valueOf(prefix) + "password", modemConfig.getPasswordAsPassword());
        properties.put(String.valueOf(prefix) + "pdpType", modemConfig.getPdpType() != null ? modemConfig.getPdpType().toString() : "");
        properties.put(String.valueOf(prefix) + "persist", modemConfig.isPersist());
        properties.put(String.valueOf(prefix) + "maxFail", modemConfig.getMaxFail());
        properties.put(String.valueOf(prefix) + "idle", modemConfig.getIdle());
        properties.put(String.valueOf(prefix) + "activeFilter", modemConfig.getActiveFilter());
        properties.put(String.valueOf(prefix) + "resetTimeout", modemConfig.getResetTimeout());
        properties.put(String.valueOf(prefix) + "lcpEchoInterval", modemConfig.getLcpEchoInterval());
        properties.put(String.valueOf(prefix) + "lcpEchoFailure", modemConfig.getLcpEchoFailure());
        properties.put(String.valueOf(prefix) + "username", modemConfig.getUsername());
        properties.put(String.valueOf(prefix) + "enabled", modemConfig.isEnabled());
        properties.put(String.valueOf(prefix) + "gpsEnabled", modemConfig.isGpsEnabled());
        properties.put(String.valueOf(prefix) + "diversityEnabled", modemConfig.isDiversityEnabled());
    }

    private static void addNetConfigIP4Properties(NetConfigIP4 nc, String netIfConfigPrefix, Map<String, Object> properties) {
        properties.put(String.valueOf(netIfConfigPrefix) + "ip4.status", nc.getStatus().toString());
        StringBuilder sbDnsAddresses = new StringBuilder();
        if (nc.getDnsServers() != null) {
            for (IP4Address ip : nc.getDnsServers()) {
                if (sbDnsAddresses.length() != 0) {
                    sbDnsAddresses.append(",");
                }
                sbDnsAddresses.append(ip.getHostAddress());
            }
        }
        properties.put(String.valueOf(netIfConfigPrefix) + "ip4.dnsServers", sbDnsAddresses.toString());
        if (nc.isDhcp()) {
            properties.put(String.valueOf(netIfConfigPrefix) + "dhcpClient4.enabled", true);
        } else {
            properties.put(String.valueOf(netIfConfigPrefix) + "dhcpClient4.enabled", false);
            if (nc.getAddress() != null) {
                properties.put(String.valueOf(netIfConfigPrefix) + "ip4.address", ((IP4Address)nc.getAddress()).getHostAddress());
            } else {
                properties.put(String.valueOf(netIfConfigPrefix) + "ip4.address", "");
            }
            properties.put(String.valueOf(netIfConfigPrefix) + "ip4.prefix", nc.getNetworkPrefixLength());
            if (nc.getGateway() != null) {
                properties.put(String.valueOf(netIfConfigPrefix) + "ip4.gateway", ((IP4Address)nc.getGateway()).getHostAddress());
            } else {
                properties.put(String.valueOf(netIfConfigPrefix) + "ip4.gateway", "");
            }
        }
    }

    private static void addNetConfigIP6Properties(NetConfigIP6 nc, String netIfConfigPrefix, Map<String, Object> properties) {
        properties.put(String.valueOf(netIfConfigPrefix) + "ip6.status", nc.getStatus().toString());
        if (nc.isDhcp()) {
            properties.put(String.valueOf(netIfConfigPrefix) + "dhcpClient6.enabled", true);
        } else {
            properties.put(String.valueOf(netIfConfigPrefix) + "dhcpClient6.enabled", false);
            if (nc.getAddress() != null) {
                properties.put(String.valueOf(netIfConfigPrefix) + "address", ((IP6Address)nc.getAddress()).getHostAddress());
            }
            StringBuilder sbDnsAddresses = new StringBuilder();
            for (IP6Address ip : nc.getDnsServers()) {
                if (sbDnsAddresses.length() != 0) {
                    sbDnsAddresses.append(",");
                }
                sbDnsAddresses.append(ip.getHostAddress());
            }
            properties.put(String.valueOf(netIfConfigPrefix) + "ip6.dnsServers", sbDnsAddresses.toString());
        }
    }

    private void addDhcpServerConfig4(DhcpServerConfig4 nc, String netIfConfigPrefix, Map<String, Object> properties) {
        properties.put(String.valueOf(netIfConfigPrefix) + "dhcpServer4.enabled", nc.isEnabled());
        properties.put(String.valueOf(netIfConfigPrefix) + "dhcpServer4.defaultLeaseTime", nc.getDefaultLeaseTime());
        properties.put(String.valueOf(netIfConfigPrefix) + "dhcpServer4.maxLeaseTime", nc.getMaximumLeaseTime());
        properties.put(String.valueOf(netIfConfigPrefix) + "dhcpServer4.prefix", nc.getPrefix());
        properties.put(String.valueOf(netIfConfigPrefix) + "dhcpServer4.rangeStart", nc.getRangeStart().toString());
        properties.put(String.valueOf(netIfConfigPrefix) + "dhcpServer4.rangeEnd", nc.getRangeEnd().toString());
        properties.put(String.valueOf(netIfConfigPrefix) + "dhcpServer4.passDns", nc.isPassDns());
    }

    private static void addFirewallNatConfig(String netIfConfigPrefix, Map<String, Object> properties) {
        properties.put(String.valueOf(netIfConfigPrefix) + "nat.enabled", true);
    }

    private void addInterfaceConfiguration(String interfaceName, NetInterfaceType type, Map<String, Object> props) throws UnknownHostException, KuraException {
        if (type == null) {
            logger.error("Null type for {}", (Object)interfaceName);
            return;
        }
        UsbDevice usbDevice = IpConfigurationInterpreter.getUsbDeviceInfo(props, interfaceName);
        AbstractNetInterface interfaceConfig = null;
        switch (type) {
            case LOOPBACK: {
                interfaceConfig = new LoopbackInterfaceConfigImpl(interfaceName);
                ArrayList<NetInterfaceAddressConfigImpl> loopbackInterfaceAddressConfigs = new ArrayList<NetInterfaceAddressConfigImpl>();
                NetInterfaceAddressConfigImpl netInterfaceAddressConfigImpl = new NetInterfaceAddressConfigImpl();
                netInterfaceAddressConfigImpl.setNetConfigs(IpConfigurationInterpreter.populateConfiguration(props, interfaceName, netInterfaceAddressConfigImpl.getAddress(), interfaceConfig.isVirtual()));
                loopbackInterfaceAddressConfigs.add(netInterfaceAddressConfigImpl);
                interfaceConfig.setNetInterfaceAddresses(loopbackInterfaceAddressConfigs);
                ((LoopbackInterfaceConfigImpl)interfaceConfig).setUsbDevice(usbDevice);
                break;
            }
            case ETHERNET: {
                interfaceConfig = new EthernetInterfaceConfigImpl(interfaceName);
                ArrayList<NetInterfaceAddressConfigImpl> ethernetInterfaceAddressConfigs = new ArrayList<NetInterfaceAddressConfigImpl>();
                NetInterfaceAddressConfigImpl netInterfaceAddressConfigImpl = new NetInterfaceAddressConfigImpl();
                netInterfaceAddressConfigImpl.setNetConfigs(IpConfigurationInterpreter.populateConfiguration(props, interfaceName, netInterfaceAddressConfigImpl.getAddress(), interfaceConfig.isVirtual()));
                ethernetInterfaceAddressConfigs.add(netInterfaceAddressConfigImpl);
                ((EthernetInterfaceConfigImpl)interfaceConfig).setNetInterfaceAddresses(ethernetInterfaceAddressConfigs);
                ((EthernetInterfaceConfigImpl)interfaceConfig).setUsbDevice(usbDevice);
                break;
            }
            case WIFI: {
                interfaceConfig = new WifiInterfaceConfigImpl(interfaceName);
                ArrayList<WifiInterfaceAddressConfigImpl> wifiInterfaceAddressConfigs = new ArrayList<WifiInterfaceAddressConfigImpl>();
                WifiInterfaceAddressConfigImpl wifiInterfaceAddressConfig = new WifiInterfaceAddressConfigImpl();
                List<NetConfig> wifiNetConfigs = IpConfigurationInterpreter.populateConfiguration(props, interfaceName, wifiInterfaceAddressConfig.getAddress(), interfaceConfig.isVirtual());
                wifiNetConfigs.addAll(WifiConfigurationInterpreter.populateConfiguration(props, interfaceName));
                wifiInterfaceAddressConfig.setNetConfigs(wifiNetConfigs);
                wifiInterfaceAddressConfig.setMode(WifiConfigurationInterpreter.getWifiMode(props, interfaceName));
                wifiInterfaceAddressConfigs.add(wifiInterfaceAddressConfig);
                ((WifiInterfaceConfigImpl)interfaceConfig).setNetInterfaceAddresses(wifiInterfaceAddressConfigs);
                ((WifiInterfaceConfigImpl)interfaceConfig).setUsbDevice(usbDevice);
                break;
            }
            case MODEM: {
                interfaceConfig = new ModemInterfaceConfigImpl(interfaceName);
                ModemInterfaceAddressConfigImpl modemInterfaceAddressConfig = new ModemInterfaceAddressConfigImpl();
                List<NetConfig> modemNetConfigs = IpConfigurationInterpreter.populateConfiguration(props, interfaceName, modemInterfaceAddressConfig.getAddress(), interfaceConfig.isVirtual());
                modemNetConfigs.addAll(ModemConfigurationInterpreter.populateConfiguration((NetInterfaceAddressConfig)modemInterfaceAddressConfig, props, interfaceName, ((ModemInterfaceConfigImpl)interfaceConfig).getPppNum()));
                modemInterfaceAddressConfig.setNetConfigs(modemNetConfigs);
                ArrayList<ModemInterfaceAddressConfigImpl> modemInterfaceAddressConfigs = new ArrayList<ModemInterfaceAddressConfigImpl>();
                modemInterfaceAddressConfigs.add(modemInterfaceAddressConfig);
                ((ModemInterfaceConfigImpl)interfaceConfig).setNetInterfaceAddresses(modemInterfaceAddressConfigs);
                ((ModemInterfaceConfigImpl)interfaceConfig).setUsbDevice(usbDevice);
                break;
            }
            case UNKNOWN: {
                logger.trace("Found interface of unknown type in current configuration: {}", (Object)interfaceName);
                return;
            }
            default: {
                logger.error("Unsupported type {} for interface {}", (Object)type, (Object)interfaceName);
                return;
            }
        }
        this.netInterfaceConfigs.put(interfaceName, (NetInterfaceConfig<? extends NetInterfaceAddressConfig>)interfaceConfig);
    }
}

