/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.web.Console;
import org.eclipse.kura.web.UserManager;
import org.eclipse.kura.web.server.OsgiRemoteServiceServlet;
import org.eclipse.kura.web.shared.GwtKuraErrorCode;
import org.eclipse.kura.web.shared.GwtKuraException;
import org.eclipse.kura.web.shared.model.GwtUserConfig;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.eclipse.kura.web.shared.service.GwtUserService;
import org.eclipse.kura.web.shared.validator.PasswordStrengthValidators;
import org.eclipse.kura.web.shared.validator.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GwtUserServiceImpl
extends OsgiRemoteServiceServlet
implements GwtUserService {
    private static final Logger logger = LoggerFactory.getLogger(GwtUserServiceImpl.class);
    private static final long serialVersionUID = 6065248347373180366L;
    private final UserManager userManager;

    public GwtUserServiceImpl(UserManager userManager) {
        this.userManager = userManager;
    }

    @Override
    public void createUser(GwtXSRFToken token, String userName) throws GwtKuraException {
        this.checkXSRFToken(token);
        this.userManager.createUser(userName);
    }

    @Override
    public void deleteUser(GwtXSRFToken token, String userName) throws GwtKuraException {
        this.checkXSRFToken(token);
        this.userManager.deleteUser(userName);
    }

    @Override
    public Set<String> getDefinedPermissions(GwtXSRFToken token) throws GwtKuraException {
        this.checkXSRFToken(token);
        return this.userManager.getDefinedPermissions();
    }

    @Override
    public Set<GwtUserConfig> getUserConfig(GwtXSRFToken token) throws GwtKuraException {
        this.checkXSRFToken(token);
        return this.userManager.getUserConfig();
    }

    @Override
    public void setUserConfig(GwtXSRFToken token, Set<GwtUserConfig> userConfig) throws GwtKuraException {
        this.checkXSRFToken(token);
        for (GwtUserConfig config : userConfig) {
            Optional<String> newPassword = config.getNewPassword();
            if (!newPassword.isPresent()) continue;
            this.validateUserPassword(newPassword.get());
        }
        try {
            this.userManager.setUserConfig(userConfig);
        }
        catch (KuraException e) {
            throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR, (Throwable)e);
        }
    }

    private void validateUserPassword(String password) throws GwtKuraException {
        List<Validator<String>> validators = PasswordStrengthValidators.fromConfig(Console.getConsoleOptions().getUserOptions());
        ArrayList errors = new ArrayList();
        for (Validator<String> validator : validators) {
            validator.validate(password, errors::add);
        }
        if (!errors.isEmpty()) {
            logger.warn("password strenght requirements not satisfied: {}", errors);
            throw new GwtKuraException(GwtKuraErrorCode.ILLEGAL_ARGUMENT);
        }
    }
}

