/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.crypto;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Properties;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.crypto.CryptoService;
import org.eclipse.kura.system.SystemService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptoServiceImpl
implements CryptoService {
    private static final Logger logger = LoggerFactory.getLogger(CryptoServiceImpl.class);
    private static final String PARAMETER_EXCEPTION_CAUSE = "parameter";
    private static final String DECRYPT_EXCEPTION_CAUSE = "decrypt";
    private static final String VALUE_EXCEPTION_CAUSE = "value";
    private static final String ALGORITHM = "AES";
    private static final String CIPHER = "AES/GCM/NoPadding";
    private static final int AUTH_TAG_LENGTH_BIT = 128;
    private static final int IV_SIZE = 12;
    private static final byte[] SECRET_KEY = System.getProperty("org.eclipse.kura.core.crypto.secretKey", "rv;ipse329183!@#").getBytes();
    private static final String ENCRYPTED_STRING_SEPARATOR = "-";
    private String keystorePasswordPath;
    private final SecureRandom random = new SecureRandom();
    private SystemService systemService;

    public void setSystemService(SystemService systemService) {
        this.systemService = systemService;
    }

    public void unsetSystemService(SystemService systemService) {
        this.systemService = null;
    }

    protected void activate() {
        if (this.systemService == null) {
            throw new IllegalStateException("Unable to get instance of: " + SystemService.class.getName());
        }
        this.keystorePasswordPath = String.valueOf(this.systemService.getKuraDataDirectory()) + File.separator + "store.save";
    }

    public char[] encryptAes(char[] value) throws KuraException {
        try {
            Key key = CryptoServiceImpl.generateKey();
            Cipher c = Cipher.getInstance(CIPHER);
            byte[] iv = new byte[12];
            this.random.nextBytes(iv);
            c.init(1, key, new GCMParameterSpec(128, iv));
            byte[] encryptedBytes = c.doFinal(new String(value).getBytes());
            String ivString = this.base64Encode(iv);
            String encryptedMessage = this.base64Encode(encryptedBytes);
            return (String.valueOf(ivString) + ENCRYPTED_STRING_SEPARATOR + encryptedMessage).toCharArray();
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException generalSecurityException) {
            throw new KuraException(KuraErrorCode.OPERATION_NOT_SUPPORTED, new Object[]{"encrypt"});
        }
        catch (InvalidKeyException | BadPaddingException | IllegalBlockSizeException generalSecurityException) {
            throw new KuraException(KuraErrorCode.ENCODE_ERROR, new Object[]{VALUE_EXCEPTION_CAUSE});
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new KuraException(KuraErrorCode.ENCODE_ERROR, new Object[]{PARAMETER_EXCEPTION_CAUSE});
        }
    }

    private byte[] base64Decode(String internalStringValue) {
        return Base64.getDecoder().decode(internalStringValue);
    }

    private String base64Encode(byte[] encryptedBytes) {
        return Base64.getEncoder().encodeToString(encryptedBytes);
    }

    public char[] decryptAes(char[] encryptedValue) throws KuraException {
        if (encryptedValue.length == 0) {
            return new char[0];
        }
        try {
            String internalStringValue = new String(encryptedValue);
            String[] internalStringValueArray = internalStringValue.split(ENCRYPTED_STRING_SEPARATOR);
            if (internalStringValueArray.length != 2) {
                throw new KuraException(KuraErrorCode.DECODER_ERROR, new Object[]{VALUE_EXCEPTION_CAUSE});
            }
            String encodedIv = internalStringValueArray[0];
            String encodedValue = internalStringValueArray[1];
            byte[] iv = this.base64Decode(encodedIv);
            byte[] decodedValue = this.base64Decode(encodedValue);
            if (encryptedValue.length > 0 && decodedValue.length == 0) {
                throw new KuraException(KuraErrorCode.DECODER_ERROR, new Object[]{VALUE_EXCEPTION_CAUSE});
            }
            Cipher c = Cipher.getInstance(CIPHER);
            c.init(2, CryptoServiceImpl.generateKey(), new GCMParameterSpec(128, iv));
            byte[] decryptedBytes = c.doFinal(decodedValue);
            String decryptedValue = new String(decryptedBytes);
            return decryptedValue.toCharArray();
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException generalSecurityException) {
            throw new KuraException(KuraErrorCode.OPERATION_NOT_SUPPORTED, new Object[]{DECRYPT_EXCEPTION_CAUSE});
        }
        catch (InvalidKeyException | BadPaddingException | IllegalBlockSizeException generalSecurityException) {
            throw new KuraException(KuraErrorCode.DECODER_ERROR, new Object[]{VALUE_EXCEPTION_CAUSE});
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new KuraException(KuraErrorCode.ENCODE_ERROR, new Object[]{PARAMETER_EXCEPTION_CAUSE});
        }
    }

    @Deprecated
    public String encryptAes(String value) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        char[] encryptedValue;
        block6: {
            encryptedValue = null;
            try {
                encryptedValue = this.encryptAes(value.toCharArray());
            }
            catch (KuraException e) {
                Throwable t = e.getCause();
                if (t instanceof NoSuchAlgorithmException) {
                    throw (NoSuchAlgorithmException)t;
                }
                if (t instanceof NoSuchPaddingException) {
                    throw (NoSuchPaddingException)t;
                }
                if (t instanceof InvalidKeyException) {
                    throw (InvalidKeyException)t;
                }
                if (t instanceof IllegalBlockSizeException) {
                    throw (IllegalBlockSizeException)t;
                }
                if (!(t instanceof BadPaddingException)) break block6;
                throw (BadPaddingException)t;
            }
        }
        return new String(encryptedValue);
    }

    @Deprecated
    public String decryptAes(String encryptedValue) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IOException, IllegalBlockSizeException, BadPaddingException {
        try {
            return new String(this.decryptAes(encryptedValue.toCharArray()));
        }
        catch (KuraException kuraException) {
            throw new IOException();
        }
    }

    public String encodeBase64(String stringValue) throws UnsupportedEncodingException {
        if (stringValue == null) {
            return null;
        }
        return this.base64Encode(stringValue.getBytes(StandardCharsets.UTF_8));
    }

    public String decodeBase64(String encodedValue) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        if (encodedValue == null) {
            return null;
        }
        return new String(this.base64Decode(encodedValue), StandardCharsets.UTF_8);
    }

    public char[] getKeyStorePassword(String keyStorePath) {
        Properties props = new Properties();
        char[] password = null;
        File f = new File(this.keystorePasswordPath);
        if (!f.exists()) {
            return "changeit".toCharArray();
        }
        try {
            Throwable throwable = null;
            Object var6_10 = null;
            try (FileInputStream fis = new FileInputStream(this.keystorePasswordPath);){
                props.load(fis);
                Object value = props.get(keyStorePath);
                if (value != null) {
                    String encryptedPassword = (String)value;
                    password = this.decryptAes(encryptedPassword.toCharArray());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            logger.warn("File not found exception while getting keystore password - ", (Throwable)e);
        }
        catch (IOException e) {
            logger.warn("IOException while getting keystore password - ", (Throwable)e);
        }
        catch (KuraException e) {
            logger.warn("KuraException while getting keystore password - ", (Throwable)e);
        }
        return password;
    }

    public void setKeyStorePassword(String keyStorePath, char[] password) throws KuraException {
        Throwable throwable;
        Properties props = new Properties();
        try {
            Throwable throwable2 = null;
            throwable = null;
            try (FileInputStream fis = new FileInputStream(this.keystorePasswordPath);){
                props.load(fis);
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (IOException iOException) {}
        char[] encryptedPassword = this.encryptAes(password);
        props.put(keyStorePath, new String(encryptedPassword));
        try {
            throwable = null;
            Object var6_10 = null;
            try (FileOutputStream fos = new FileOutputStream(this.keystorePasswordPath);){
                props.store(fos, "Do not edit this file. It's automatically generated by Kura");
                fos.flush();
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new KuraException(KuraErrorCode.INTERNAL_ERROR, (Throwable)e, new Object[0]);
        }
    }

    @Deprecated
    public void setKeyStorePassword(String keyStorePath, String password) throws IOException {
        try {
            this.setKeyStorePassword(keyStorePath, password.toCharArray());
        }
        catch (KuraException e) {
            throw new IOException(e);
        }
    }

    public boolean isFrameworkSecure() {
        return false;
    }

    private static Key generateKey() {
        return new SecretKeySpec(SECRET_KEY, ALGORITHM);
    }

    public String hash(String s, String algorithm) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
        messageDigest.reset();
        messageDigest.update(s.getBytes(StandardCharsets.UTF_8));
        byte[] encodedBytes = messageDigest.digest();
        return this.base64Encode(encodedBytes);
    }
}

