/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.emulator.position;

import java.io.InputStream;
import java.net.URL;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.emulator.position.GpsPoint;
import org.eclipse.kura.emulator.position.GpsXmlHandler;
import org.eclipse.kura.position.NmeaPosition;
import org.eclipse.kura.position.PositionListener;
import org.eclipse.kura.position.PositionLockedEvent;
import org.eclipse.kura.position.PositionService;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.util.measurement.Measurement;
import org.osgi.util.measurement.Unit;
import org.osgi.util.position.Position;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.helpers.DefaultHandler;

public class PositionServiceImpl
implements PositionService,
ConfigurableComponent {
    private static final String USE_GPSD_PROPERTY_NAME = "useGpsd";
    private static final Logger logger = LoggerFactory.getLogger(PositionServiceImpl.class);
    private static final String SOURCE_KEY = "source";
    private static final String BOSTON = "boston";
    private ComponentContext ctx;
    private EventAdmin eventAdmin;
    private ScheduledExecutorService worker;
    private ScheduledFuture<?> handle;
    private GpsPoint[] gpsPoints;
    private Position currentPosition;
    private NmeaPosition currentNmeaPosition;
    private Date currentTime;
    private int index = 0;
    private boolean useGpsd;
    private String source;

    public void setEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    public void unsetEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = null;
    }

    protected void activate(ComponentContext componentContext, Map<String, Object> properties) {
        this.ctx = componentContext;
        this.useGpsd = false;
        this.doUpdate(properties);
        this.start();
    }

    public void updated(Map<String, Object> properties) {
        logger.info("Updating position service");
        this.stop();
        this.doUpdate(properties);
        this.start();
        logger.info("Updating position service. Done.");
    }

    protected void deactivate(ComponentContext componentContext) {
        logger.info("Stopping position service");
        this.stop();
    }

    private void doUpdate(Map<String, Object> properties) {
        if (properties == null) {
            return;
        }
        if (properties.get(USE_GPSD_PROPERTY_NAME) != null) {
            this.useGpsd = (Boolean)properties.get(USE_GPSD_PROPERTY_NAME);
        }
        if (this.useGpsd) {
            logger.info("USE GPSD");
        }
        this.source = (String)properties.getOrDefault(SOURCE_KEY, BOSTON);
    }

    public Position getPosition() {
        return this.currentPosition;
    }

    public NmeaPosition getNmeaPosition() {
        return this.currentNmeaPosition;
    }

    public String getNmeaTime() {
        return this.currentTime.toString();
    }

    public String getNmeaDate() {
        return this.currentTime.toString();
    }

    public boolean isLocked() {
        return true;
    }

    public String getLastSentence() {
        return null;
    }

    public void start() {
        this.index = 0;
        String fileName = null;
        if (BOSTON.equals(this.source)) {
            fileName = "boston.gpx";
        } else if ("denver".equals(this.source)) {
            fileName = "denver.gpx";
        } else if ("paris".equals(this.source)) {
            fileName = "paris.gpx";
        } else if ("test".equals(this.source)) {
            fileName = "test.gpx";
        }
        GpsXmlHandler handler = new GpsXmlHandler();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            factory.setValidating(false);
            SAXParser parser = factory.newSAXParser();
            logger.debug("Parsing: {}", (Object)fileName);
            BundleContext bundleContext = this.ctx.getBundleContext();
            URL url = bundleContext.getBundle().getResource(fileName);
            InputStream is = url.openStream();
            parser.parse(is, (DefaultHandler)handler);
            this.gpsPoints = handler.getGpsPoints();
        }
        catch (Exception e) {
            logger.warn("Exception while parsing the position file", (Throwable)e);
        }
        this.worker = Executors.newSingleThreadScheduledExecutor();
        this.handle = this.worker.scheduleAtFixedRate(this::updateGps, 0L, 5L, TimeUnit.SECONDS);
        logger.debug("posting event");
        this.eventAdmin.postEvent((Event)new PositionLockedEvent(new HashMap()));
    }

    public void stop() {
        if (this.handle != null) {
            this.handle.cancel(true);
            this.handle = null;
        }
        this.worker = null;
    }

    private void updateGps() {
        logger.debug("GPS Emulator index: {}", (Object)this.index);
        if (this.index + 1 == this.gpsPoints.length) {
            logger.debug("GPS Emulator - wrapping index");
            this.index = 0;
        }
        Measurement latitude = new Measurement(Math.toRadians(this.gpsPoints[this.index].getLatitude()), Unit.rad);
        Measurement longitude = new Measurement(Math.toRadians(this.gpsPoints[this.index].getLongitude()), Unit.rad);
        Measurement altitude = new Measurement(this.gpsPoints[this.index].getAltitude(), Unit.m);
        logger.debug("Updating latitude: {}", (Object)latitude);
        logger.debug("Updating longitude: {}", (Object)longitude);
        logger.debug("Updating altitude: {}", (Object)altitude);
        this.currentTime = new Date();
        this.currentPosition = new Position(latitude, longitude, altitude, null, null);
        this.currentNmeaPosition = new NmeaPosition(this.gpsPoints[this.index].getLatitude(), this.gpsPoints[this.index].getLongitude(), this.gpsPoints[this.index].getAltitude(), 0.0, 0.0);
        ++this.index;
    }

    public void registerListener(String listenerId, PositionListener positionListener) {
    }

    public void unregisterListener(String listenerId) {
    }

    public LocalDateTime getDateTime() {
        return LocalDateTime.ofInstant(this.currentTime.toInstant(), ZoneId.systemDefault());
    }
}

