/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.cloudconnection.raw.mqtt.publisher;

import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.cloudconnection.listener.CloudDeliveryListener;
import org.eclipse.kura.cloudconnection.message.KuraMessage;
import org.eclipse.kura.cloudconnection.publisher.CloudPublisher;
import org.eclipse.kura.cloudconnection.raw.mqtt.cloud.RawMqttCloudEndpoint;
import org.eclipse.kura.cloudconnection.raw.mqtt.publisher.PublishOptions;
import org.eclipse.kura.cloudconnecton.raw.mqtt.util.AbstractStackComponent;
import org.eclipse.kura.cloudconnecton.raw.mqtt.util.StackComponentOptions;
import org.eclipse.kura.cloudconnecton.raw.mqtt.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawMqttPublisher
extends AbstractStackComponent<PublishOptions>
implements CloudPublisher,
CloudDeliveryListener {
    private static final Logger logger = LoggerFactory.getLogger(RawMqttPublisher.class);
    private final Set<CloudDeliveryListener> cloudDeliveryListeners = new CopyOnWriteArraySet<CloudDeliveryListener>();

    @Override
    protected void setCloudEndpoint(RawMqttCloudEndpoint endpoint) {
        super.setCloudEndpoint(endpoint);
        endpoint.registerCloudDeliveryListener(this);
    }

    @Override
    protected void unsetCloudEndpoint(RawMqttCloudEndpoint endpoint) {
        endpoint.unregisterCloudConnectionListener(this);
        super.unsetCloudEndpoint(endpoint);
    }

    public String publish(KuraMessage message) throws KuraException {
        StackComponentOptions currentOptions = this.getOptions();
        Optional publishOptions = currentOptions.getComponentOptions();
        if (!publishOptions.isPresent()) {
            throw new KuraException(KuraErrorCode.CONFIGURATION_ERROR, null, new Object[]{null, "invalid publish configuration"});
        }
        Optional<RawMqttCloudEndpoint> currentEndpoint = this.getEndpoint();
        if (!currentEndpoint.isPresent()) {
            throw new KuraException(KuraErrorCode.NOT_FOUND, null, new Object[]{null, "cloud endpoint not bound"});
        }
        return currentEndpoint.get().publish((PublishOptions)publishOptions.get(), message.getPayload());
    }

    public void registerCloudDeliveryListener(CloudDeliveryListener cloudDeliveryListener) {
        this.cloudDeliveryListeners.add(cloudDeliveryListener);
    }

    public void unregisterCloudDeliveryListener(CloudDeliveryListener cloudDeliveryListener) {
        this.cloudDeliveryListeners.remove(cloudDeliveryListener);
    }

    public void onMessageConfirmed(String messageId) {
        this.cloudDeliveryListeners.forEach(Utils.catchAll(l -> l.onMessageConfirmed(messageId)));
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected StackComponentOptions.OptionsFactory<PublishOptions> getOptionsFactory() {
        return PublishOptions::new;
    }
}

