/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.wire.asset;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.kura.channel.ChannelFlag;
import org.eclipse.kura.channel.ChannelRecord;
import org.eclipse.kura.channel.ChannelStatus;
import org.eclipse.kura.internal.wire.asset.RecordFiller;
import org.eclipse.kura.internal.wire.asset.TimestampMode;
import org.eclipse.kura.internal.wire.asset.WireAssetConstants;
import org.eclipse.kura.internal.wire.asset.WireAssetOptions;
import org.eclipse.kura.type.StringValue;
import org.eclipse.kura.type.TypedValue;
import org.eclipse.kura.type.TypedValues;

public final class RecordFillers {
    private RecordFillers() {
    }

    public static RecordFiller create(ChannelRecord record, WireAssetOptions options) {
        FillerChain result = new FillerChain();
        RecordFillers.createInternal(record, options, result::add);
        return result;
    }

    public static List<RecordFiller> create(List<ChannelRecord> records, WireAssetOptions options) {
        ArrayList<RecordFiller> result = new ArrayList<RecordFiller>(records.size());
        for (ChannelRecord record : records) {
            result.add(RecordFillers.create(record, options));
        }
        return result;
    }

    public static void fill(ChannelRecord record, WireAssetOptions options, Map<String, TypedValue<?>> envelopeProperties) {
        RecordFillers.createInternal(record, options, f -> f.fill(envelopeProperties, record));
    }

    private static void createInternal(ChannelRecord record, WireAssetOptions options, Consumer<RecordFiller> consumer) {
        ValueFiller valueFiller = new ValueFiller(record);
        consumer.accept(valueFiller);
        boolean isPerChannel = options.getTimestampMode() == TimestampMode.PER_CHANNEL;
        boolean emitErrors = options.emitErrors();
        if (!isPerChannel && !emitErrors) {
            return;
        }
        if (isPerChannel) {
            consumer.accept(new TimestampFiller(record));
        }
        if (emitErrors) {
            consumer.accept(new ErrorFiller(record));
        }
    }

    private static class ErrorFiller
    implements RecordFiller {
        private final String errorKey;

        public ErrorFiller(ChannelRecord record) {
            this.errorKey = String.valueOf(record.getChannelName()) + WireAssetConstants.PROP_SUFFIX_ERROR.value();
        }

        @Override
        public void fill(Map<String, TypedValue<?>> envelopeProperties, ChannelRecord record) {
            envelopeProperties.put(this.errorKey, (TypedValue<?>)TypedValues.newStringValue((String)this.getErrorMessage(record.getChannelStatus())));
        }

        private String getErrorMessage(ChannelStatus channelStatus) {
            if (channelStatus.getChannelFlag() == ChannelFlag.SUCCESS) {
                return WireAssetConstants.PROP_VALUE_NO_ERROR.value();
            }
            String errorMessage = WireAssetConstants.ERROR_NOT_SPECIFIED_MESSAGE.value();
            Exception exception = channelStatus.getException();
            String exceptionMsg = channelStatus.getExceptionMessage();
            if (Objects.nonNull(exception) && Objects.nonNull(exceptionMsg)) {
                errorMessage = String.valueOf(exceptionMsg) + " " + exception.toString();
            } else if (Objects.isNull(exception) && Objects.nonNull(exceptionMsg)) {
                errorMessage = exceptionMsg;
            } else if (Objects.nonNull(exception)) {
                errorMessage = exception.toString();
            }
            return errorMessage;
        }
    }

    private static class FillerChain
    implements RecordFiller {
        private final RecordFiller[] fillers = new RecordFiller[3];
        private int len = 0;

        private FillerChain() {
        }

        void add(RecordFiller filler) {
            this.fillers[this.len] = filler;
            ++this.len;
        }

        @Override
        public void fill(Map<String, TypedValue<?>> envelopeProperties, ChannelRecord record) {
            int i = 0;
            while (i < this.fillers.length && this.fillers[i] != null) {
                this.fillers[i].fill(envelopeProperties, record);
                ++i;
            }
        }
    }

    private static class TimestampFiller
    implements RecordFiller {
        private final String timestampKey;

        public TimestampFiller(ChannelRecord record) {
            this.timestampKey = String.valueOf(record.getChannelName()) + WireAssetConstants.PROP_SUFFIX_TIMESTAMP.value();
        }

        @Override
        public void fill(Map<String, TypedValue<?>> envelopeProperties, ChannelRecord record) {
            envelopeProperties.put(this.timestampKey, (TypedValue<?>)TypedValues.newLongValue((long)record.getTimestamp()));
        }
    }

    private static class ValueFiller
    implements RecordFiller {
        private final String valueKey;

        public ValueFiller(ChannelRecord record) {
            this.valueKey = record.getChannelName();
        }

        @Override
        public void fill(Map<String, TypedValue<?>> envelopeProperties, ChannelRecord record) {
            if (record.getChannelStatus().getChannelFlag() == ChannelFlag.SUCCESS) {
                envelopeProperties.put(this.valueKey, record.getValue());
                String unit = record.getUnit();
                if (!Objects.isNull(unit) && !unit.trim().isEmpty()) {
                    envelopeProperties.put(String.valueOf(this.valueKey) + WireAssetConstants.PROP_SUFFIX_UNIT.value(), (TypedValue<?>)new StringValue(unit));
                }
            }
        }
    }
}

