/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.cm;

import org.eclipse.equinox.internal.cm.LogTracker;
import org.eclipse.equinox.internal.cm.SerializedTaskQueue;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.service.cm.SynchronousConfigurationListener;
import org.osgi.util.tracker.ServiceTracker;

public class EventDispatcher {
    final ServiceTracker<ConfigurationListener, ConfigurationListener> tracker;
    final ServiceTracker<SynchronousConfigurationListener, SynchronousConfigurationListener> syncTracker;
    private final SerializedTaskQueue queue = new SerializedTaskQueue("ConfigurationListener Event Queue");
    private ServiceReference<ConfigurationAdmin> configAdminReference;
    final LogTracker log;

    public EventDispatcher(BundleContext context, LogTracker log) {
        this.log = log;
        this.tracker = new ServiceTracker(context, ConfigurationListener.class, null);
        this.syncTracker = new ServiceTracker(context, SynchronousConfigurationListener.class, null);
    }

    public void start() {
        this.tracker.open();
        this.syncTracker.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.tracker.close();
        this.syncTracker.close();
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            this.configAdminReference = null;
        }
    }

    synchronized void setServiceReference(ServiceReference<ConfigurationAdmin> reference) {
        if (this.configAdminReference == null) {
            this.configAdminReference = reference;
        }
    }

    public void dispatchEvent(int type, String factoryPid, String pid) {
        ServiceReference[] refs;
        int n;
        final ConfigurationEvent event = this.createConfigurationEvent(type, factoryPid, pid);
        if (event == null) {
            return;
        }
        ServiceReference[] syncRefs = this.syncTracker.getServiceReferences();
        if (syncRefs != null) {
            ServiceReference[] serviceReferenceArray = syncRefs;
            n = syncRefs.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReference ref = serviceReferenceArray[n2];
                SynchronousConfigurationListener syncListener = (SynchronousConfigurationListener)this.syncTracker.getService(ref);
                if (syncListener != null) {
                    try {
                        syncListener.configurationEvent(event);
                    }
                    catch (Throwable t) {
                        this.log.log(1, t.getMessage(), t);
                    }
                }
                ++n2;
            }
        }
        if ((refs = this.tracker.getServiceReferences()) == null) {
            return;
        }
        ServiceReference[] serviceReferenceArray = refs;
        int n3 = refs.length;
        n = 0;
        while (n < n3) {
            final ServiceReference ref = serviceReferenceArray[n];
            this.queue.put(new Runnable(){

                @Override
                public void run() {
                    ConfigurationListener listener = (ConfigurationListener)EventDispatcher.this.tracker.getService(ref);
                    if (listener == null) {
                        return;
                    }
                    try {
                        listener.configurationEvent(event);
                    }
                    catch (Throwable t) {
                        EventDispatcher.this.log.log(1, t.getMessage(), t);
                    }
                }
            });
            ++n;
        }
    }

    private synchronized ConfigurationEvent createConfigurationEvent(int type, String factoryPid, String pid) {
        if (this.configAdminReference == null) {
            return null;
        }
        return new ConfigurationEvent(this.configAdminReference, type, factoryPid, pid);
    }
}

