/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.net.firewall;

import org.eclipse.kura.net.NetConfig;
import org.eclipse.kura.net.firewall.RuleType;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class FirewallNatConfig
implements NetConfig {
    private final String sourceInterface;
    private final String destinationInterface;
    private final String protocol;
    private final String source;
    private final String destination;
    private final boolean masquerade;
    private final RuleType type;

    @Deprecated
    public FirewallNatConfig(String srcIface, String dstIface, String protocol, String src, String dst, boolean masquerade) {
        this.sourceInterface = srcIface;
        this.destinationInterface = dstIface;
        this.protocol = protocol;
        this.source = src;
        this.destination = dst;
        this.masquerade = masquerade;
        this.type = RuleType.GENERIC;
    }

    public FirewallNatConfig(String srcIface, String dstIface, String protocol, String src, String dst, boolean masquerade, RuleType type) {
        this.sourceInterface = srcIface;
        this.destinationInterface = dstIface;
        this.protocol = protocol;
        this.source = src;
        this.destination = dst;
        this.masquerade = masquerade;
        this.type = type;
    }

    public String getSourceInterface() {
        return this.sourceInterface;
    }

    public String getDestinationInterface() {
        return this.destinationInterface;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getSource() {
        return this.source;
    }

    public String getDestination() {
        return this.destination;
    }

    public boolean isMasquerade() {
        return this.masquerade;
    }

    public RuleType getRuleType() {
        return this.type;
    }

    @Override
    public boolean isValid() {
        boolean result = false;
        if (this.destinationInterface != null && !this.destinationInterface.trim().isEmpty() && this.sourceInterface != null && !this.sourceInterface.trim().isEmpty()) {
            result = true;
        }
        return result;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.destinationInterface == null ? 0 : this.destinationInterface.hashCode());
        result = 31 * result + (this.sourceInterface == null ? 0 : this.sourceInterface.hashCode());
        result = 31 * result + (this.protocol == null ? 0 : this.protocol.hashCode());
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        result = 31 * result + (this.destination == null ? 0 : this.destination.hashCode());
        result = 31 * result + (this.masquerade ? 1231 : 1237);
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FirewallNatConfig other = (FirewallNatConfig)obj;
        if (this.masquerade != other.masquerade) {
            return false;
        }
        if (this.sourceInterface == null) {
            if (other.sourceInterface != null) {
                return false;
            }
        } else {
            if (!this.sourceInterface.equals(other.sourceInterface)) {
                return false;
            }
            if (!this.protocol.equals(other.protocol)) {
                return false;
            }
        }
        if (this.destinationInterface == null ? other.destinationInterface != null : !this.destinationInterface.equals(other.destinationInterface)) {
            return false;
        }
        if (this.source == null ? other.source != null : !this.source.equals(other.source)) {
            return false;
        }
        if (this.destination == null ? other.destination != null : !this.destination.equals(other.destination)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals((Object)other.type));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("FirewallNatConfig [m_sourceInterface=");
        builder.append(this.sourceInterface);
        builder.append(", destinationInterface=");
        builder.append(this.destinationInterface);
        builder.append(", source=");
        builder.append(this.source);
        builder.append(", destination=");
        builder.append(this.destination);
        builder.append(", type=");
        builder.append((Object)this.type);
        builder.append("]");
        return builder.toString();
    }
}

