/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.ble;

import com.github.hypfvieh.bluetooth.wrapper.BluetoothGattDescriptor;
import java.util.UUID;
import org.eclipse.kura.KuraBluetoothIOException;
import org.eclipse.kura.bluetooth.le.BluetoothLeGattCharacteristic;
import org.eclipse.kura.bluetooth.le.BluetoothLeGattDescriptor;
import org.eclipse.kura.internal.ble.BluetoothLeGattCharacteristicImpl;
import org.freedesktop.dbus.exceptions.DBusException;

public class BluetoothLeGattDescriptorImpl
implements BluetoothLeGattDescriptor {
    private final BluetoothGattDescriptor descriptor;

    public BluetoothLeGattDescriptorImpl(BluetoothGattDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public byte[] readValue() throws KuraBluetoothIOException {
        byte[] value;
        try {
            value = this.descriptor.readValue(null);
        }
        catch (DBusException e) {
            throw new KuraBluetoothIOException((Throwable)e, (Object)"Read descriptor value failed");
        }
        return value;
    }

    public void writeValue(byte[] value) throws KuraBluetoothIOException {
        try {
            this.descriptor.writeValue(value, null);
        }
        catch (DBusException e) {
            throw new KuraBluetoothIOException((Throwable)e, (Object)"Write descriptor value failed");
        }
    }

    public UUID getUUID() {
        String uuid = this.descriptor.getUuid();
        if (uuid == null) {
            return null;
        }
        return UUID.fromString(uuid);
    }

    public BluetoothLeGattCharacteristic getCharacteristic() {
        return new BluetoothLeGattCharacteristicImpl(this.descriptor.getCharacteristic());
    }

    public byte[] getValue() {
        return this.descriptor.getValue();
    }
}

