/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.emulator.gpio;

import java.io.IOException;
import org.eclipse.kura.gpio.KuraClosedDeviceException;
import org.eclipse.kura.gpio.KuraGPIODeviceException;
import org.eclipse.kura.gpio.KuraGPIODirection;
import org.eclipse.kura.gpio.KuraGPIOMode;
import org.eclipse.kura.gpio.KuraGPIOPin;
import org.eclipse.kura.gpio.KuraGPIOTrigger;
import org.eclipse.kura.gpio.KuraUnavailableDeviceException;
import org.eclipse.kura.gpio.PinStatusListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmulatedPin
implements KuraGPIOPin {
    private static final Logger logger = LoggerFactory.getLogger(EmulatedPin.class);
    private boolean internalValue = false;
    String pinName = null;
    int pinIndex = -1;
    private KuraGPIODirection direction = KuraGPIODirection.OUTPUT;
    private KuraGPIOMode mode = KuraGPIOMode.OUTPUT_OPEN_DRAIN;
    private KuraGPIOTrigger trigger = KuraGPIOTrigger.NONE;

    public EmulatedPin(String pinName) {
        this.pinName = pinName;
    }

    public EmulatedPin(int pinIndex) {
        this.pinIndex = pinIndex;
    }

    public EmulatedPin(String pinName, KuraGPIODirection direction, KuraGPIOMode mode, KuraGPIOTrigger trigger) {
        this.pinName = pinName;
        this.direction = direction;
        this.mode = mode;
        this.trigger = trigger;
    }

    public EmulatedPin(int pinIndex, KuraGPIODirection direction, KuraGPIOMode mode, KuraGPIOTrigger trigger) {
        this.pinIndex = pinIndex;
        this.direction = direction;
        this.mode = mode;
        this.trigger = trigger;
    }

    public void setValue(boolean active) throws KuraUnavailableDeviceException, KuraClosedDeviceException, IOException {
        this.internalValue = active;
        logger.debug("Emulated GPIO Pin {} changed to {}", this.pinName != null ? this.pinName : Integer.valueOf(this.pinIndex), (Object)(active ? "on" : "off"));
    }

    public boolean getValue() throws KuraUnavailableDeviceException, KuraClosedDeviceException, IOException {
        return this.internalValue;
    }

    public void addPinStatusListener(PinStatusListener listener) throws KuraClosedDeviceException, IOException {
    }

    public void removePinStatusListener(PinStatusListener listener) throws KuraClosedDeviceException, IOException {
    }

    public void open() throws KuraGPIODeviceException, KuraUnavailableDeviceException, IOException {
        logger.info("Emulated GPIO Pin {} open.", this.pinName != null ? this.pinName : Integer.valueOf(this.pinIndex));
    }

    public void close() throws IOException {
        logger.info("Emulated GPIO Pin {} closed.", this.pinName != null ? this.pinName : Integer.valueOf(this.pinIndex));
    }

    public String toString() {
        return this.pinName != null ? "GPIO Pin: " + this.pinName : "Gpio PIN #" + String.valueOf(this.pinIndex);
    }

    public KuraGPIODirection getDirection() {
        return this.direction;
    }

    public KuraGPIOMode getMode() {
        return this.mode;
    }

    public KuraGPIOTrigger getTrigger() {
        return this.trigger;
    }

    public String getName() {
        return this.pinName != null ? this.pinName : String.valueOf(this.pinIndex);
    }

    public int getIndex() {
        return this.pinIndex;
    }

    public boolean isOpen() {
        return true;
    }
}

