/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.wire.asset;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.asset.AssetConfiguration;
import org.eclipse.kura.asset.provider.BaseAsset;
import org.eclipse.kura.channel.Channel;
import org.eclipse.kura.channel.ChannelRecord;
import org.eclipse.kura.channel.ChannelType;
import org.eclipse.kura.channel.listener.ChannelEvent;
import org.eclipse.kura.channel.listener.ChannelListener;
import org.eclipse.kura.core.configuration.metatype.Tad;
import org.eclipse.kura.core.configuration.metatype.Tocd;
import org.eclipse.kura.driver.PreparedRead;
import org.eclipse.kura.internal.wire.asset.RecordFiller;
import org.eclipse.kura.internal.wire.asset.RecordFillers;
import org.eclipse.kura.internal.wire.asset.Utils;
import org.eclipse.kura.internal.wire.asset.WireAssetChannelDescriptor;
import org.eclipse.kura.internal.wire.asset.WireAssetConstants;
import org.eclipse.kura.internal.wire.asset.WireAssetOCD;
import org.eclipse.kura.internal.wire.asset.WireAssetOptions;
import org.eclipse.kura.type.TypedValue;
import org.eclipse.kura.type.TypedValues;
import org.eclipse.kura.util.collection.CollectionUtil;
import org.eclipse.kura.wire.WireComponent;
import org.eclipse.kura.wire.WireEmitter;
import org.eclipse.kura.wire.WireEnvelope;
import org.eclipse.kura.wire.WireHelperService;
import org.eclipse.kura.wire.WireReceiver;
import org.eclipse.kura.wire.WireRecord;
import org.eclipse.kura.wire.WireSupport;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.wireadmin.Wire;

public final class WireAsset
extends BaseAsset
implements WireEmitter,
WireReceiver {
    private static final Logger logger = LogManager.getLogger(WireAsset.class);
    private volatile WireHelperService wireHelperService;
    private WireSupport wireSupport;
    private WireAssetOptions options = new WireAssetOptions();
    private PreparedEmit preparedEmit;

    public void bindWireHelperService(WireHelperService wireHelperService) {
        if (Objects.isNull(this.wireHelperService)) {
            this.wireHelperService = wireHelperService;
        }
    }

    public void unbindWireHelperService(WireHelperService wireHelperService) {
        if (this.wireHelperService == wireHelperService) {
            this.wireHelperService = null;
        }
    }

    protected void activate(ComponentContext componentContext, Map<String, Object> properties) {
        logger.debug("Activating Wire Asset...");
        this.wireSupport = this.wireHelperService.newWireSupport((WireComponent)this, componentContext.getServiceReference());
        super.activate(componentContext, properties);
        logger.debug("Activating Wire Asset...Done");
    }

    public void updated(Map<String, Object> properties) {
        logger.debug("Updating Wire Asset...");
        this.options = new WireAssetOptions(properties);
        super.updated(properties);
        logger.debug("Updating Wire Asset...Done");
    }

    protected void deactivate(ComponentContext context) {
        logger.debug("Deactivating Wire Asset...");
        super.deactivate(context);
        logger.debug("Deactivating Wire Asset...Done");
    }

    public void consumersConnected(Wire[] wires) {
        this.wireSupport.consumersConnected(wires);
    }

    protected String getFactoryPid() {
        return "org.eclipse.kura.asset";
    }

    public void onWireReceive(WireEnvelope wireEnvelope) {
        Objects.requireNonNull(wireEnvelope, "Wire Envelope cannot be null");
        this.emitAllReadChannels();
        List records = wireEnvelope.getRecords();
        for (WireRecord wireRecord : records) {
            List<ChannelRecord> channelRecordsToWrite = this.determineWritingChannels(wireRecord);
            this.writeChannels(channelRecordsToWrite);
        }
    }

    protected void onPreparedReadCreated(PreparedRead preparedRead) {
        this.preparedEmit = new PreparedEmit(preparedRead.getChannelRecords());
    }

    protected void onPreparedReadReleased(PreparedRead preparedRead) {
        this.preparedEmit = null;
    }

    private void emitAllReadChannels() {
        if (this.hasReadChannels()) {
            try {
                this.emitChannelRecords(this.readAllChannels());
            }
            catch (Exception e) {
                logger.error("Error while performing read from the Wire Asset...", (Throwable)e);
            }
        }
    }

    private List<ChannelRecord> determineWritingChannels(WireRecord record) {
        Objects.requireNonNull(record, "Wire Record cannot be null");
        List channelRecordsToWrite = CollectionUtil.newArrayList();
        AssetConfiguration assetConfiguration = this.getAssetConfiguration();
        Map channels = assetConfiguration.getAssetChannels();
        for (Map.Entry channelEntry : channels.entrySet()) {
            Map wireRecordProperties;
            Channel channel = (Channel)channelEntry.getValue();
            String channelName = channel.getName();
            ChannelType channelType = channel.getType();
            if (channelType != ChannelType.WRITE && channelType != ChannelType.READ_WRITE || !(wireRecordProperties = record.getProperties()).containsKey(channelName)) continue;
            TypedValue value = (TypedValue)wireRecordProperties.get(channelName);
            if (channel.getValueType() != value.getType()) continue;
            channelRecordsToWrite.add(channel.createWriteRecord(value));
        }
        return channelRecordsToWrite;
    }

    private void emitChannelRecords(List<ChannelRecord> channelRecords) {
        Objects.requireNonNull(channelRecords, "List of Channel Records cannot be null");
        if (channelRecords.isEmpty()) {
            throw new IllegalArgumentException("Channel Records cannot be empty");
        }
        Map<String, TypedValue<?>> wireRecordProperties = this.preparedEmit != null ? this.preparedEmit.execute(channelRecords) : Utils.toWireRecordProperties(channelRecords, this.options);
        try {
            wireRecordProperties.put(WireAssetConstants.PROP_ASSET_NAME.value(), (TypedValue<?>)TypedValues.newStringValue((String)this.getKuraServicePid()));
        }
        catch (KuraException e) {
            logger.error("Configurations cannot be null", (Throwable)e);
        }
        this.wireSupport.emit(Collections.singletonList(new WireRecord(wireRecordProperties)));
    }

    private void writeChannels(List<ChannelRecord> channelRecordsToWrite) {
        Objects.requireNonNull(channelRecordsToWrite, "List of Channel Records cannot be null");
        if (channelRecordsToWrite.isEmpty()) {
            return;
        }
        try {
            this.write(channelRecordsToWrite);
        }
        catch (Exception e) {
            logger.error("Error while performing write from the Wire Asset...", (Throwable)e);
        }
    }

    private boolean isListeningChannel(Map<String, Object> properties) {
        try {
            return Boolean.parseBoolean(properties.get(WireAssetConstants.LISTEN_PROP_NAME.value()).toString());
        }
        catch (Exception exception) {
            logger.warn("Failed to retreive \"listen\" property from channel configuration");
            return false;
        }
    }

    protected boolean isChannelListenerValid(BaseAsset.ChannelListenerRegistration reg, Channel channel) {
        if (!super.isChannelListenerValid(reg, channel)) {
            return false;
        }
        ChannelListener listener = reg.getChannelListener();
        if (!(listener instanceof EmitterChannelListener)) {
            return true;
        }
        return ((EmitterChannelListener)listener).outer() != this;
    }

    protected void updateChannelListenerRegistrations(Set<BaseAsset.ChannelListenerRegistration> listeners, AssetConfiguration config) {
        super.updateChannelListenerRegistrations(listeners, config);
        config.getAssetChannels().entrySet().stream().filter(e -> this.isListeningChannel(((Channel)e.getValue()).getConfiguration())).map(e -> new BaseAsset.ChannelListenerRegistration((String)e.getKey(), (ChannelListener)new EmitterChannelListener())).forEach(listeners::add);
    }

    protected List<Tad> getAssetChannelDescriptor() {
        return (List)WireAssetChannelDescriptor.get().getDescriptor();
    }

    protected Tocd getOCD() {
        return new WireAssetOCD();
    }

    public Object polled(Wire wire) {
        return this.wireSupport.polled(wire);
    }

    public void producersConnected(Wire[] wires) {
        this.wireSupport.producersConnected(wires);
    }

    public void updated(Wire wire, Object value) {
        this.wireSupport.updated(wire, value);
    }

    private class EmitterChannelListener
    implements ChannelListener {
        private EmitterChannelListener() {
        }

        public void onChannelEvent(ChannelEvent event) {
            if (WireAsset.this.options.emitAllChannels()) {
                WireAsset.this.emitAllReadChannels();
            } else {
                Channel channel;
                ChannelRecord eventRecord = event.getChannelRecord();
                if ((eventRecord.getUnit() == null || eventRecord.getUnit().isEmpty()) && (channel = (Channel)WireAsset.this.getAssetConfiguration().getAssetChannels().get(eventRecord.getChannelName())) != null) {
                    eventRecord.setUnit(channel.getUnit());
                }
                WireAsset.this.emitChannelRecords(Collections.singletonList(eventRecord));
            }
        }

        public WireAsset outer() {
            return WireAsset.this;
        }
    }

    private class PreparedEmit {
        private final List<ChannelRecord> preparedRecords;
        private final List<RecordFiller> recordFillers;

        PreparedEmit(List<ChannelRecord> records) {
            this.preparedRecords = records;
            this.recordFillers = RecordFillers.create(this.preparedRecords, WireAsset.this.options);
        }

        Map<String, TypedValue<?>> execute(List<ChannelRecord> channelRecords) {
            if (channelRecords != this.preparedRecords) {
                return Utils.toWireRecordProperties(channelRecords, WireAsset.this.options);
            }
            return Utils.toWireRecordProperties(channelRecords, WireAsset.this.options, this.recordFillers);
        }
    }
}

