/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.xml.marshaller.unmarshaller;

import java.util.List;
import org.eclipse.kura.core.inventory.resources.DockerContainer;
import org.eclipse.kura.core.inventory.resources.DockerContainers;
import org.eclipse.kura.internal.xml.marshaller.unmarshaller.XmlJavaDataMapper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlJavaDockerContainersMapper
implements XmlJavaDataMapper {
    private static final String CONTAINERS = "containers";
    private static final String CONTAINERS_CONTAINER = "container";
    private static final String CONTAINERS_CONTAINER_NAME = "name";
    private static final String CONTAINERS_CONTAINER_VERSION = "version";

    @Override
    public Element marshal(Document doc, Object object) throws Exception {
        Element packages = doc.createElement(CONTAINERS);
        doc.appendChild(packages);
        DockerContainers containers = (DockerContainers)object;
        List containerList = containers.getDockerContainers();
        for (DockerContainer xcontainer : containerList) {
            Element packageInstalled = doc.createElement(CONTAINERS_CONTAINER);
            XmlJavaDockerContainersMapper.marshalContainer(doc, xcontainer, packageInstalled);
            packages.appendChild(packageInstalled);
        }
        return packages;
    }

    @Override
    public <T> T unmarshal(Document doc) throws Exception {
        return null;
    }

    private static void marshalContainer(Document doc, DockerContainer container, Element packageInstalled) {
        String containerName = container.getName();
        String containerVersion = container.getVersion();
        if (containerName != null && !containerName.trim().isEmpty()) {
            Element name = doc.createElement(CONTAINERS_CONTAINER_NAME);
            name.setTextContent(containerName);
            packageInstalled.appendChild(name);
        }
        if (containerVersion != null && !containerVersion.trim().isEmpty()) {
            Element version = doc.createElement(CONTAINERS_CONTAINER_VERSION);
            version.setTextContent(containerVersion);
            packageInstalled.appendChild(version);
        }
    }
}

