/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.wire.timer;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.internal.wire.timer.CronTimerExecutor;
import org.eclipse.kura.internal.wire.timer.SimpleTimerExecutor;
import org.eclipse.kura.internal.wire.timer.TimerExecutor;
import org.eclipse.kura.internal.wire.timer.TimerOptions;
import org.eclipse.kura.type.LongValue;
import org.eclipse.kura.type.TypedValues;
import org.eclipse.kura.wire.WireComponent;
import org.eclipse.kura.wire.WireEmitter;
import org.eclipse.kura.wire.WireHelperService;
import org.eclipse.kura.wire.WireRecord;
import org.eclipse.kura.wire.WireSupport;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.wireadmin.Wire;

public class Timer
implements WireEmitter,
ConfigurableComponent {
    private static final Logger logger = LogManager.getLogger(Timer.class);
    private WireHelperService wireHelperService;
    private WireSupport wireSupport;
    private Optional<TimerExecutor> timerExecutor = Optional.empty();

    public void bindWireHelperService(WireHelperService wireHelperService) {
        this.wireHelperService = wireHelperService;
    }

    protected void activate(ComponentContext ctx, Map<String, Object> properties) {
        logger.debug("Activating Timer...");
        this.wireSupport = this.wireHelperService.newWireSupport((WireComponent)this, ctx.getServiceReference());
        this.doUpdate(new TimerOptions(properties));
        logger.debug("Activating Timer... Done");
    }

    protected void updated(Map<String, Object> properties) {
        logger.debug("Updating Timer...");
        this.doUpdate(new TimerOptions(properties));
        logger.debug("Updating Timer... Done");
    }

    protected void deactivate() {
        logger.debug("Dectivating Timer...");
        this.shutdownExecutor();
        logger.debug("Dectivating Timer... Done");
    }

    private void doUpdate(TimerOptions options) {
        this.shutdownExecutor();
        try {
            this.timerExecutor = "SIMPLE".equalsIgnoreCase(options.getType()) ? Optional.of(new SimpleTimerExecutor(options, this.wireSupport)) : Optional.of(new CronTimerExecutor(options, this.wireSupport));
        }
        catch (Exception e) {
            logger.warn("failed to start timer", (Throwable)e);
        }
    }

    private void shutdownExecutor() {
        if (this.timerExecutor.isPresent()) {
            this.timerExecutor.get().shutdown();
            this.timerExecutor = Optional.empty();
        }
    }

    public void consumersConnected(Wire[] wires) {
        this.wireSupport.consumersConnected(wires);
    }

    public Object polled(Wire wire) {
        return this.wireSupport.polled(wire);
    }

    static void emit(WireSupport wireSupport) {
        LongValue timestamp = TypedValues.newLongValue((long)System.currentTimeMillis());
        WireRecord timerWireRecord = new WireRecord(Collections.singletonMap("TIMER", timestamp));
        wireSupport.emit(Collections.singletonList(timerWireRecord));
    }
}

