/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server;

import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.kura.log.LogEntry;
import org.eclipse.kura.log.LogProvider;
import org.eclipse.kura.web.server.OsgiRemoteServiceServlet;
import org.eclipse.kura.web.server.util.ServiceLocator;
import org.eclipse.kura.web.shared.GwtKuraException;
import org.eclipse.kura.web.shared.model.GwtLogEntry;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.eclipse.kura.web.shared.service.GwtLogService;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GwtLogServiceImpl
extends OsgiRemoteServiceServlet
implements GwtLogService {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(GwtLogServiceImpl.class);
    private static final LogEntriesCache cache = new LogEntriesCache();
    private static final List<String> registeredLogProviders = new LinkedList<String>();

    @Override
    public List<String> initLogProviders(GwtXSRFToken xsrfToken) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        this.loadLogProviders();
        return registeredLogProviders;
    }

    @Override
    public List<GwtLogEntry> readLogs(int fromId) throws GwtKuraException {
        return cache.getLogs(fromId);
    }

    private void loadLogProviders() {
        try {
            ArrayList<String> availableLogProviders = new ArrayList<String>();
            List logProviderRefs = (List)ServiceLocator.getInstance().getServiceReferences(LogProvider.class, "(objectClass=*)");
            for (ServiceReference logProviderRef : logProviderRefs) {
                String pid = (String)logProviderRef.getProperty("kura.service.pid");
                LogProvider service = (LogProvider)FrameworkUtil.getBundle(LogProvider.class).getBundleContext().getService(logProviderRef);
                availableLogProviders.add(pid);
                if (pid == null || service == null || registeredLogProviders.contains(pid)) continue;
                service.registerLogListener(entry -> {
                    GwtLogEntry gwtEntry = new GwtLogEntry();
                    gwtEntry.setProperties(entry.getProperties());
                    gwtEntry.setSourceLogProviderPid(pid);
                    gwtEntry.setTimestamp(this.getFormattedTimestamp(entry));
                    cache.add(gwtEntry);
                });
                registeredLogProviders.add(pid);
                logger.info("LogProvider {} loaded.", (Object)pid);
            }
            for (String pid : registeredLogProviders) {
                if (availableLogProviders.contains(pid)) continue;
                registeredLogProviders.remove(pid);
                logger.info("LogProvider {} no more available.", (Object)pid);
            }
        }
        catch (GwtKuraException gwtKuraException) {
            logger.error("Error loading log providers.");
        }
    }

    private String getFormattedTimestamp(LogEntry entry) {
        String time = "UNDEFINED";
        try {
            return Instant.ofEpochSecond(entry.getTimestamp()).atZone(ZoneId.systemDefault()).toLocalDateTime().toString();
        }
        catch (Exception exception) {
            return time;
        }
    }

    private static final class LogEntriesCache {
        private static final LinkedList<GwtLogEntry> cache = new LinkedList();
        private static final int MAX_CACHE_SIZE = 1000;
        private static int nextEntryId = 0;

        private LogEntriesCache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(GwtLogEntry newEntry) {
            LinkedList<GwtLogEntry> linkedList = cache;
            synchronized (linkedList) {
                if (cache.size() >= 1000) {
                    cache.removeFirst();
                }
                LogEntriesCache.manageIdIntOverflow();
                newEntry.setId(nextEntryId++);
                cache.add(newEntry);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<GwtLogEntry> getLogs(int fromId) {
            LinkedList<GwtLogEntry> result = new LinkedList<GwtLogEntry>();
            LinkedList<GwtLogEntry> linkedList = cache;
            synchronized (linkedList) {
                cache.forEach(entry -> {
                    if (entry.getId() > fromId) {
                        result.add((GwtLogEntry)entry);
                    }
                });
            }
            return result;
        }

        private static void manageIdIntOverflow() {
            if (nextEntryId >= Integer.MAX_VALUE) {
                logger.info("ID overflow for cached UI log entries. Reindexing.");
                int i = 0;
                while (i < cache.size()) {
                    cache.get(i).setId(i);
                    ++i;
                }
                nextEntryId = cache.size();
            }
        }
    }
}

