/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.deployment.install;

import java.text.ParseException;
import org.eclipse.kura.core.deployment.download.impl.KuraNotifyPayload;
import org.eclipse.kura.message.KuraPayload;

public class KuraInstallPayload
extends KuraPayload {
    public static final String METRIC_CLIENT_ID = "client.id";
    public static final String METRIC_INSTALL_PROGRESS = "dp.install.progress";
    public static final String METRIC_INSTALL_STATUS = "dp.install.status";
    public static final String METRIC_DP_NAME = "dp.name";
    public static final String METRIC_DP_VERSION = "dp.version";
    public static final String METRIC_JOB_ID = "job.id";
    private static final String METRIC_ERROR_MESSAGE = "dp.install.error.message";

    public KuraInstallPayload(String clientId) {
        this.addMetric(METRIC_CLIENT_ID, clientId);
    }

    public KuraInstallPayload(KuraPayload kuraPayload) {
        for (String name : kuraPayload.metricNames()) {
            Object value = kuraPayload.getMetric(name);
            this.addMetric(name, value);
        }
        this.setBody(kuraPayload.getBody());
        this.setPosition(kuraPayload.getPosition());
        this.setTimestamp(kuraPayload.getTimestamp());
    }

    public void setClientId(String requesterClientId) {
        this.addMetric(METRIC_CLIENT_ID, requesterClientId);
    }

    public String getClientId() {
        return (String)this.getMetric(METRIC_CLIENT_ID);
    }

    public void setInstallProgress(int installProgress) {
        this.addMetric(METRIC_INSTALL_PROGRESS, installProgress);
    }

    public int getInstallProgress() {
        return (Integer)this.getMetric(METRIC_INSTALL_PROGRESS);
    }

    public void setInstallStatus(String installStatus) {
        this.addMetric(METRIC_INSTALL_STATUS, installStatus);
    }

    public String getInstallStatus() {
        return (String)this.getMetric(METRIC_INSTALL_STATUS);
    }

    public void setDpName(String dpName) {
        this.addMetric(METRIC_DP_NAME, dpName);
    }

    public void setDpVersion(String dpVersion) {
        this.addMetric(METRIC_DP_VERSION, dpVersion);
    }

    public static KuraNotifyPayload buildFromKuraPayload(KuraPayload payload) throws ParseException {
        if (payload.getMetric(METRIC_CLIENT_ID) == null) {
            throw new ParseException("Not a valid notify payload", 0);
        }
        return new KuraNotifyPayload(payload);
    }

    public void setJobId(long jobId) {
        this.addMetric(METRIC_JOB_ID, jobId);
    }

    public Long getJobId() {
        return (Long)this.getMetric(METRIC_JOB_ID);
    }

    public void setErrorMessage(String errorMessage) {
        this.addMetric(METRIC_ERROR_MESSAGE, errorMessage);
    }

    public String getErrorMessage() {
        return (String)this.getMetric(METRIC_ERROR_MESSAGE);
    }
}

