/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.xml.marshaller.unmarshaller;

import java.util.List;
import org.eclipse.kura.core.inventory.resources.ContainerImage;
import org.eclipse.kura.core.inventory.resources.ContainerImages;
import org.eclipse.kura.internal.xml.marshaller.unmarshaller.XmlJavaDataMapper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlJavaContainerImagesMapper
implements XmlJavaDataMapper {
    private static final String IMAGES = "images";
    private static final String CONTAINERS_IMAGES = "image";
    private static final String CONTAINERS_IMAGES_NAME = "name";
    private static final String CONTAINERS_IMAGES_VERSION = "version";

    @Override
    public Element marshal(Document doc, Object object) throws Exception {
        Element packages = doc.createElement(IMAGES);
        doc.appendChild(packages);
        ContainerImages images = (ContainerImages)object;
        List imageList = images.getContainerImages();
        for (ContainerImage ximage : imageList) {
            Element packageInstalled = doc.createElement(CONTAINERS_IMAGES);
            XmlJavaContainerImagesMapper.marshalContainer(doc, ximage, packageInstalled);
            packages.appendChild(packageInstalled);
        }
        return packages;
    }

    @Override
    public <T> T unmarshal(Document doc) throws Exception {
        return null;
    }

    private static void marshalContainer(Document doc, ContainerImage image, Element packageInstalled) {
        String imageName = image.getName();
        String imageVersion = image.getVersion();
        if (imageName != null && !imageName.trim().isEmpty()) {
            Element name = doc.createElement(CONTAINERS_IMAGES_NAME);
            name.setTextContent(imageName);
            packageInstalled.appendChild(name);
        }
        if (imageVersion != null && !imageVersion.trim().isEmpty()) {
            Element version = doc.createElement(CONTAINERS_IMAGES_VERSION);
            version.setTextContent(imageVersion);
            packageInstalled.appendChild(version);
        }
    }
}

