/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.jaxrs.publisher.internal;

import com.eclipsesource.jaxrs.publisher.ApplicationConfiguration;
import com.eclipsesource.jaxrs.publisher.ServletConfiguration;
import com.eclipsesource.jaxrs.publisher.internal.Configuration;
import com.eclipsesource.jaxrs.publisher.internal.DefaultApplicationConfiguration;
import com.eclipsesource.jaxrs.publisher.internal.ResourcePublisher;
import com.eclipsesource.jaxrs.publisher.internal.RootApplication;
import com.eclipsesource.jaxrs.publisher.internal.ServiceContainer;
import com.eclipsesource.jaxrs.publisher.internal.ServletContainerBridge;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.ws.rs.core.Application;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;

public class JerseyContext {
    private final RootApplication application;
    private final HttpService httpService;
    private final ServletContainerBridge servletContainerBridge;
    private final ResourcePublisher resourcePublisher;
    private volatile boolean isApplicationRegistered;
    private ServletConfiguration servletConfiguration;
    private String rootPath;
    private ServiceContainer applicationConfigurations;

    public JerseyContext(HttpService httpService, Configuration configuration, ServletConfiguration servletConfiguration, ServiceContainer applicationConfigurations) {
        this.httpService = httpService;
        this.rootPath = configuration.getRoothPath();
        this.application = new RootApplication();
        this.applicationConfigurations = applicationConfigurations;
        this.applyApplicationConfigurations(applicationConfigurations);
        this.servletContainerBridge = new ServletContainerBridge(this.application);
        this.servletConfiguration = servletConfiguration;
        this.resourcePublisher = new ResourcePublisher(this.servletContainerBridge, configuration.getPublishDelay());
    }

    void applyApplicationConfigurations(ServiceContainer applicationConfigurations) {
        ServiceContainer.ServiceHolder[] services;
        this.getRootApplication().addProperties(new DefaultApplicationConfiguration().getProperties());
        ServiceContainer.ServiceHolder[] serviceHolderArray = services = applicationConfigurations.getServices();
        int n = services.length;
        int n2 = 0;
        while (n2 < n) {
            Map<String, Object> properties;
            ServiceContainer.ServiceHolder serviceHolder = serviceHolderArray[n2];
            Object service = serviceHolder.getService();
            if (service instanceof ApplicationConfiguration && (properties = ((ApplicationConfiguration)service).getProperties()) != null) {
                this.getRootApplication().addProperties(properties);
            }
            ++n2;
        }
    }

    public void addResource(Object resource) {
        this.getRootApplication().addResource(resource);
        this.registerServletWhenNotAlreadyRegistered();
        this.resourcePublisher.schedulePublishing();
    }

    public void updateConfiguration(Configuration configuration) {
        this.resourcePublisher.setPublishDelay(configuration.getPublishDelay());
        String oldRootPath = this.rootPath;
        this.rootPath = configuration.getRoothPath();
        this.handleRootPath(oldRootPath);
        this.applyApplicationConfigurations(this.applicationConfigurations);
        this.handeRepublish();
    }

    private void handleRootPath(String oldRootPath) {
        if (this.isApplicationRegistered && !oldRootPath.equals(this.rootPath)) {
            this.refreshServletRegistration(oldRootPath);
        }
    }

    public void updateAppConfiguration(ServiceContainer applicationConfigurations) {
        this.applicationConfigurations = applicationConfigurations;
        this.applyApplicationConfigurations(this.applicationConfigurations);
        this.handeRepublish();
    }

    public void updateServletConfiguration(ServletConfiguration servletConfiguration) {
        boolean isServletUpdateRequired = this.servletConfiguration != servletConfiguration;
        this.servletConfiguration = servletConfiguration;
        if (this.isApplicationRegistered && isServletUpdateRequired) {
            this.refreshServletRegistration(this.rootPath);
        }
        this.handeRepublish();
    }

    private void handeRepublish() {
        if (this.isApplicationRegistered) {
            this.resourcePublisher.schedulePublishing();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshServletRegistration(String pathToUnregister) {
        ServletContainerBridge servletContainerBridge = this.servletContainerBridge;
        synchronized (servletContainerBridge) {
            this.safeUnregister(pathToUnregister);
        }
        this.registerServletWhenNotAlreadyRegistered();
    }

    void registerServletWhenNotAlreadyRegistered() {
        if (!this.isApplicationRegistered) {
            this.isApplicationRegistered = true;
            this.registerApplication();
        }
    }

    private void registerApplication() {
        ClassLoader loader = this.getContextClassloader();
        this.setContextClassloader();
        try {
            try {
                this.registerServlet();
            }
            catch (ServletException shouldNotHappen) {
                throw new IllegalStateException(shouldNotHappen);
            }
            catch (NamespaceException shouldNotHappen) {
                throw new IllegalStateException(shouldNotHappen);
            }
        }
        finally {
            this.resetContextClassloader(loader);
        }
    }

    private ClassLoader getContextClassloader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private void setContextClassloader() {
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
    }

    private void registerServlet() throws ServletException, NamespaceException {
        ClassLoader original = this.getContextClassloader();
        try {
            Thread.currentThread().setContextClassLoader(Application.class.getClassLoader());
            this.httpService.registerServlet(this.rootPath, (Servlet)this.servletContainerBridge, this.getInitParams(), this.getHttpContext());
        }
        finally {
            this.resetContextClassloader(original);
        }
    }

    private Dictionary getInitParams() {
        if (this.servletConfiguration != null) {
            return this.servletConfiguration.getInitParams(this.httpService, this.rootPath);
        }
        return null;
    }

    private HttpContext getHttpContext() {
        if (this.servletConfiguration != null) {
            return this.servletConfiguration.getHttpContext(this.httpService, this.rootPath);
        }
        return null;
    }

    private void resetContextClassloader(ClassLoader loader) {
        Thread.currentThread().setContextClassLoader(loader);
    }

    public void removeResource(Object resource) {
        this.getRootApplication().removeResource(resource);
        this.unregisterServletWhenNoResourcePresents();
        this.resourcePublisher.schedulePublishing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterServletWhenNoResourcePresents() {
        if (!this.getRootApplication().hasResources() && this.isApplicationRegistered) {
            this.resourcePublisher.cancelPublishing();
            ServletContainerBridge servletContainerBridge = this.servletContainerBridge;
            synchronized (servletContainerBridge) {
                this.safeUnregister(this.rootPath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> eliminate() {
        this.resourcePublisher.cancelPublishing();
        this.resourcePublisher.shutdown();
        if (this.isApplicationRegistered) {
            ServletContainerBridge servletContainerBridge = this.servletContainerBridge;
            synchronized (servletContainerBridge) {
                this.safeUnregister(this.rootPath);
            }
        }
        return new ArrayList<Object>(this.getRootApplication().getResources());
    }

    void safeUnregister(String rootPath) {
        try {
            this.httpService.unregister(rootPath);
        }
        catch (Exception exception) {}
        this.isApplicationRegistered = false;
    }

    RootApplication getRootApplication() {
        return this.application;
    }
}

