/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stream;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.stream.StreamEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(StreamProducer.class);
    private static final String TYPES = "out,err,file,header,url";
    private static final String INVALID_URI = "Invalid uri, valid form: 'stream:{out,err,file,header,url}'";
    private static final List<String> TYPES_LIST = Arrays.asList("out,err,file,header,url".split(","));
    private StreamEndpoint endpoint;
    private String uri;
    private OutputStream outputStream;
    private URLConnection urlConnection;
    private AtomicInteger count = new AtomicInteger();

    public StreamProducer(StreamEndpoint endpoint, String uri) throws Exception {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.validateUri(uri);
    }

    protected void doStart() throws Exception {
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.closeStream(null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) throws Exception {
        this.delay(this.endpoint.getDelay());
        StreamProducer streamProducer = this;
        synchronized (streamProducer) {
            try {
                this.openStream(exchange);
                this.writeToStream(this.outputStream, exchange);
            }
            finally {
                this.closeStream(exchange, false);
            }
        }
    }

    private OutputStream resolveStreamFromUrl() throws IOException {
        String u = this.endpoint.getUrl();
        ObjectHelper.notEmpty((String)u, (String)"url");
        LOG.debug("About to write to url: {}", (Object)u);
        URL url = new URL(u);
        this.urlConnection = url.openConnection();
        this.urlConnection.setDoOutput(true);
        if (this.endpoint.getConnectTimeout() > 0) {
            this.urlConnection.setConnectTimeout(this.endpoint.getConnectTimeout());
        }
        if (this.endpoint.getReadTimeout() > 0) {
            this.urlConnection.setReadTimeout(this.endpoint.getReadTimeout());
        }
        if (this.endpoint.getHttpHeaders() != null) {
            this.endpoint.getHttpHeaders().forEach((k, v) -> this.urlConnection.addRequestProperty((String)k, v.toString()));
        }
        return this.urlConnection.getOutputStream();
    }

    private OutputStream resolveStreamFromFile() throws IOException {
        String fileName = this.endpoint.getFileName();
        ObjectHelper.notEmpty((String)fileName, (String)"fileName");
        LOG.debug("About to write to file: {}", (Object)fileName);
        File f = new File(fileName);
        f.getParentFile().mkdirs();
        f.createNewFile();
        return new FileOutputStream(f, true);
    }

    private OutputStream resolveStreamFromHeader(Object o, Exchange exchange) throws CamelExchangeException {
        return (OutputStream)exchange.getContext().getTypeConverter().convertTo(OutputStream.class, o);
    }

    private void delay(long ms) throws InterruptedException {
        if (ms == 0L) {
            return;
        }
        LOG.trace("Delaying {} millis", (Object)ms);
        Thread.sleep(ms);
    }

    private void writeToStream(OutputStream outputStream, Exchange exchange) throws IOException, CamelExchangeException {
        byte[] bytes;
        Object body = exchange.getIn().getBody();
        if (body == null) {
            this.log.debug("Body is null, cannot write it to the stream.");
            return;
        }
        if (!(body instanceof String) && (bytes = (byte[])exchange.getIn().getBody(byte[].class)) != null) {
            LOG.debug("Writing as byte[]: {} to {}", (Object)bytes, (Object)outputStream);
            outputStream.write(bytes);
            return;
        }
        String s = (String)exchange.getIn().getMandatoryBody(String.class);
        Charset charset = this.endpoint.getCharset();
        OutputStreamWriter writer = new OutputStreamWriter(outputStream, charset);
        BufferedWriter bw = IOHelper.buffered((Writer)writer);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Writing as text: {} to {} using encoding: {}", new Object[]{body, outputStream, charset});
        }
        bw.write(s);
        bw.write(System.lineSeparator());
        bw.flush();
    }

    private void openStream() throws Exception {
        if (this.outputStream != null) {
            return;
        }
        if ("out".equals(this.uri)) {
            this.outputStream = System.out;
        } else if ("err".equals(this.uri)) {
            this.outputStream = System.err;
        } else if ("file".equals(this.uri)) {
            this.outputStream = this.resolveStreamFromFile();
        } else if ("url".equals(this.uri)) {
            this.outputStream = this.resolveStreamFromUrl();
        }
        this.count.set(this.outputStream == null ? 0 : this.endpoint.getAutoCloseCount());
        LOG.debug("Opened stream '{}'", (Object)this.endpoint.getEndpointKey());
    }

    private void openStream(Exchange exchange) throws Exception {
        if (this.outputStream != null) {
            return;
        }
        if ("header".equals(this.uri)) {
            this.outputStream = this.resolveStreamFromHeader(exchange.getIn().getHeader("stream"), exchange);
            LOG.debug("Opened stream '{}'", (Object)this.endpoint.getEndpointKey());
        } else {
            this.openStream();
        }
    }

    private Boolean isDone(Exchange exchange) {
        return exchange != null && (Boolean)exchange.getProperty("CamelSplitComplete", (Object)Boolean.FALSE, Boolean.class) != false;
    }

    private void closeStream(Exchange exchange, boolean force) throws Exception {
        boolean expiredStream;
        if (this.outputStream == null) {
            return;
        }
        boolean systemStream = this.outputStream == System.out || this.outputStream == System.err;
        boolean headerStream = "header".equals(this.uri);
        boolean reachedLimit = this.endpoint.getAutoCloseCount() > 0 && this.count.decrementAndGet() <= 0;
        boolean isDone = this.endpoint.isCloseOnDone() && this.isDone(exchange) != false;
        boolean bl = expiredStream = force || headerStream || isDone || reachedLimit;
        if (!systemStream && expiredStream) {
            if (this.urlConnection != null) {
                try {
                    InputStream is = this.urlConnection.getInputStream();
                    IOHelper.close((Closeable)is);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.outputStream.close();
            this.outputStream = null;
            this.urlConnection = null;
            LOG.debug("Closed stream '{}'", (Object)this.endpoint.getEndpointKey());
        }
    }

    private void validateUri(String uri) throws Exception {
        String[] s = uri.split(":");
        if (s.length < 2) {
            throw new IllegalArgumentException(INVALID_URI);
        }
        String[] t = s[1].split("\\?");
        if (t.length < 1) {
            throw new IllegalArgumentException(INVALID_URI);
        }
        this.uri = t[0].trim();
        if (this.uri.startsWith("//")) {
            this.uri = this.uri.substring(2);
        }
        if (!TYPES_LIST.contains(this.uri)) {
            throw new IllegalArgumentException(INVALID_URI);
        }
    }
}

