/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.configuration.upgrade;

import java.util.Map;
import org.eclipse.kura.configuration.ComponentConfiguration;
import org.eclipse.kura.core.configuration.upgrade.WireAssetConfigurationUpgrade;
import org.osgi.framework.BundleContext;

public class ConfigurationUpgrade {
    private static final String KURA_CLOUD_SERVICE_FACTORY_PID = "kura.cloud.service.factory.pid";
    private static final String FACTORY_PID = "org.eclipse.kura.core.cloud.factory.DefaultCloudServiceFactory";
    private static final String CLOUD_SERVICE_FACTORY_PID = "org.eclipse.kura.cloud.CloudService";
    private static final String DATA_SERVICE_FACTORY_PID = "org.eclipse.kura.data.DataService";
    private static final String DATA_TRANSPORT_SERVICE_FACTORY_PID = "org.eclipse.kura.core.data.transport.mqtt.MqttDataTransport";
    private static final String CLOUD_SERVICE_PID = "org.eclipse.kura.cloud.CloudService";
    private static final String DATA_SERVICE_PID = "org.eclipse.kura.data.DataService";
    private static final String DATA_TRANSPORT_SERVICE_PID = "org.eclipse.kura.core.data.transport.mqtt.MqttDataTransport";
    private static final String DATA_SERVICE_REFERENCE_NAME = "DataService";
    private static final String DATA_TRANSPORT_SERVICE_REFERENCE_NAME = "DataTransportService";
    private static final String REFERENCE_TARGET_VALUE_FORMAT = "(kura.service.pid=%s)";

    public static void upgrade(ComponentConfiguration config, BundleContext bundleContext) {
        if (config == null) {
            return;
        }
        String pid = config.getPid();
        Map props = config.getConfigurationProperties();
        if (props == null) {
            return;
        }
        Object factoryPid = props.get("service.factoryPid");
        if ("org.eclipse.kura.cloud.CloudService".equals(pid)) {
            props.put("service.factoryPid", "org.eclipse.kura.cloud.CloudService");
            String name = "DataService.target";
            props.put(name, String.format(REFERENCE_TARGET_VALUE_FORMAT, "org.eclipse.kura.data.DataService"));
            props.put(KURA_CLOUD_SERVICE_FACTORY_PID, FACTORY_PID);
        } else if ("org.eclipse.kura.data.DataService".equals(pid)) {
            props.put("service.factoryPid", "org.eclipse.kura.data.DataService");
            String name = "DataTransportService.target";
            props.put(name, String.format(REFERENCE_TARGET_VALUE_FORMAT, "org.eclipse.kura.core.data.transport.mqtt.MqttDataTransport"));
            props.put(KURA_CLOUD_SERVICE_FACTORY_PID, FACTORY_PID);
        } else if ("org.eclipse.kura.core.data.transport.mqtt.MqttDataTransport".equals(pid)) {
            props.put("service.factoryPid", "org.eclipse.kura.core.data.transport.mqtt.MqttDataTransport");
            props.put(KURA_CLOUD_SERVICE_FACTORY_PID, FACTORY_PID);
        } else if ("org.eclipse.kura.wire.WireAsset".equals(factoryPid)) {
            WireAssetConfigurationUpgrade.upgrade(props);
        }
    }
}

