/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.mtoolkit.iagent.internal.rpc;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.application.ApplicationException;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.tigris.mtoolkit.iagent.Error;
import org.tigris.mtoolkit.iagent.event.EventData;
import org.tigris.mtoolkit.iagent.event.EventSynchronizer;
import org.tigris.mtoolkit.iagent.internal.rpc.Activator;
import org.tigris.mtoolkit.iagent.internal.utils.DebugUtils;
import org.tigris.mtoolkit.iagent.internal.utils.ExceptionCodeHelper;
import org.tigris.mtoolkit.iagent.rpc.Remote;
import org.tigris.mtoolkit.iagent.rpc.RemoteApplicationAdmin;
import org.tigris.mtoolkit.iagent.rpc.RemoteCapabilitiesManager;

public class RemoteApplicationAdminImpl
implements Remote,
RemoteApplicationAdmin,
ServiceTrackerCustomizer {
    private static final String OSGI_APPLICATION_PACKAGE = "org.osgi.service.application.";
    private static final String APPLICATION_DESCRIPTOR = "org.osgi.service.application.ApplicationDescriptor";
    private static final String APPLICATION_HANDLE = "org.osgi.service.application.ApplicationHandle";
    public static final String SYNCH_APPLICATION_EVENT = "synch_application_event";
    private static final String EVENT_TYPE_KEY = "type";
    private static final String EVENT_APPLICATION_ID_KEY = "application_id";
    private static final int APP_INSTALLED = 1;
    private static final int APP_UNINSTALLED = 16;
    private static final int APP_STARTED = 4;
    private static final int APP_STOPPED = 8;
    private static final String UNINSTALLED_STATE = "UNINSTALLED";
    private static final String INSTALLED_STATE = "INSTALLED";
    private static final String MIXED_STATE = "MIXED";
    private static final String ERROR_STATE = "ERROR";
    private static final String UNKNOWN_STATE = "UNKNOWN";
    private ServiceRegistration registration;
    private BundleContext bc;
    private ServiceTracker applicationTracker;
    private ServiceTracker handlesTracker;
    private boolean suppressEventFiring = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public Class[] remoteInterfaces() {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.tigris.mtoolkit.iagent.rpc.RemoteApplicationAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        return classArray;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void register(BundleContext bundleContext) {
        Class<?> clazz;
        block6: {
            Class<?> clazz2;
            this.bc = bundleContext;
            this.suppressEventFiring = true;
            try {
                this.applicationTracker = new ServiceTracker(this.bc, APPLICATION_DESCRIPTOR, (ServiceTrackerCustomizer)this);
                this.applicationTracker.open(true);
                this.handlesTracker = new ServiceTracker(this.bc, APPLICATION_HANDLE, (ServiceTrackerCustomizer)this);
                this.handlesTracker.open(true);
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                this.suppressEventFiring = false;
                throw throwable;
            }
            {
                Object var2_4 = null;
                this.suppressEventFiring = false;
                clazz = class$0;
                if (clazz != null) break block6;
            }
            try {
                clazz2 = Class.forName("org.tigris.mtoolkit.iagent.rpc.RemoteApplicationAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = class$0 = clazz2;
        }
        this.registration = this.bc.registerService(clazz.getName(), (Object)this, null);
        RemoteCapabilitiesManager capMan = Activator.getCapabilitiesManager();
        if (capMan != null) {
            capMan.setCapability("remote.application.support", new Boolean(true));
        }
    }

    public void unregister(BundleContext bc) {
        RemoteCapabilitiesManager capMan;
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
        if (this.applicationTracker != null) {
            this.applicationTracker.close();
            this.applicationTracker = null;
        }
        if (this.handlesTracker != null) {
            this.handlesTracker.close();
            this.handlesTracker = null;
        }
        if ((capMan = Activator.getCapabilitiesManager()) != null) {
            capMan.setCapability("remote.application.support", new Boolean(false));
        }
        this.bc = null;
    }

    private void fireApplicationEvent(String id, int type) {
        Dictionary event = this.convertApplicationEvent(id, type);
        EventSynchronizer synchronizer = Activator.getSynchronizer();
        if (synchronizer != null) {
            synchronizer.enqueue(new EventData(event, SYNCH_APPLICATION_EVENT));
        }
    }

    public String[] getApplications() {
        ServiceReference[] refs = this.applicationTracker.getServiceReferences();
        if (refs == null) {
            return new String[0];
        }
        this.debug("[getApplications] " + refs.length + " applications available.");
        Object[] ids = new String[refs.length];
        int i = 0;
        while (i < refs.length) {
            ids[i] = (String)refs[i].getProperty("service.pid");
            ++i;
        }
        this.debug("[getApplications] Application ids: " + DebugUtils.convertForDebug(ids));
        return ids;
    }

    public long getRemoteServiceID() {
        ServiceReference localRef;
        block5: {
            ServiceRegistration localRegistration;
            block4: {
                try {
                    localRegistration = this.registration;
                    if (localRegistration != null) break block4;
                    return -1L;
                }
                catch (IllegalStateException illegalStateException) {
                    return -1L;
                }
            }
            localRef = localRegistration.getReference();
            if (localRef != null) break block5;
            return -1L;
        }
        return (Long)localRef.getProperty("service.id");
    }

    private final void debug(String message) {
        DebugUtils.debug(this, message);
    }

    private final void error(String message, Throwable e) {
        DebugUtils.error(this, message, e);
    }

    public Object start(String applicationID, Map properties) {
        Object descriptor = this.findApplicationDescriptor(applicationID);
        if (descriptor == null) {
            return new Error(-7903, "Application with ID \"" + applicationID + "\" is not installed.");
        }
        Object result = this.launchFromDescriptor(descriptor, properties);
        return result;
    }

    public Object stop(String applicationID) {
        Object[] handles = this.handlesTracker.getServices();
        if (handles == null) {
            return null;
        }
        int i = 0;
        while (i < handles.length) {
            Object result;
            String id = this.getApplicationIdFromHandle(handles[i]);
            if (id != null && id.equals(applicationID) && (result = this.destroyHandle(handles[i])) != null) {
                return result;
            }
            ++i;
        }
        return null;
    }

    private Object launchFromDescriptor(Object descriptor, Map properties) {
        try {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.util.Map");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.invokeMethod1(descriptor, "launch", clazz, properties);
            return null;
        }
        catch (Exception e) {
            if (e instanceof ApplicationException) {
                return new Error(ExceptionCodeHelper.fromApplicationExceptionCode(((ApplicationException)e).getErrorCode()), "Application start failed: " + DebugUtils.toString(e));
            }
            return new Error(-7000, "Application start failed: " + DebugUtils.toString(e));
        }
    }

    private Object destroyHandle(Object handle) {
        try {
            this.invokeMethod0(handle, "destroy");
            return null;
        }
        catch (Exception e) {
            return new Error(-7000, "Application stop failed: " + DebugUtils.toString(e));
        }
    }

    private Object findApplicationDescriptor(String applicationID) {
        ServiceReference ref = this.findDescriptorReference(applicationID);
        if (ref != null) {
            return this.applicationTracker.getService(ref);
        }
        return null;
    }

    private ServiceReference findDescriptorReference(String applicationId) {
        ServiceReference[] refs = this.applicationTracker.getServiceReferences();
        if (refs == null) {
            return null;
        }
        int i = 0;
        while (i < refs.length) {
            String id = this.getApplicationIdFromReference(refs[i]);
            if (applicationId.equals(id)) {
                return refs[i];
            }
            ++i;
        }
        return null;
    }

    public String getState(String applicationId) {
        Object descriptor = this.findApplicationDescriptor(applicationId);
        if (descriptor == null) {
            return UNINSTALLED_STATE;
        }
        Object[] handles = this.findHandles(applicationId);
        if (handles.length == 0) {
            return INSTALLED_STATE;
        }
        if (handles.length == 1) {
            return this.getHandleState(handles[0]);
        }
        if (handles.length > 1) {
            return MIXED_STATE;
        }
        return UNKNOWN_STATE;
    }

    private String getHandleState(Object handle) {
        try {
            return (String)this.invokeMethod0(handle, "getState");
        }
        catch (Exception e) {
            this.error("Failed to get application state", e);
            return ERROR_STATE;
        }
    }

    private Object[] findHandles(String applicationId) {
        Object[] handles = this.handlesTracker.getServices();
        if (handles == null) {
            return new Object[0];
        }
        ArrayList<Object> filtered = new ArrayList<Object>(handles.length);
        int i = 0;
        while (i < handles.length) {
            String id = this.getApplicationIdFromHandle(handles[i]);
            if (id != null && id.equals(applicationId)) {
                filtered.add(handles[i]);
            }
            ++i;
        }
        return filtered.toArray();
    }

    private Dictionary convertApplicationEvent(String applicationId, int type) {
        Hashtable<String, Object> event = new Hashtable<String, Object>();
        ((Dictionary)event).put(EVENT_TYPE_KEY, new Integer(type));
        ((Dictionary)event).put(EVENT_APPLICATION_ID_KEY, applicationId);
        return event;
    }

    private String getApplicationIdFromReference(ServiceReference ref) {
        return (String)ref.getProperty("service.pid");
    }

    private String getApplicationIdFromHandle(Object obj) {
        try {
            Object descriptor = this.invokeMethod0(obj, "getApplicationDescriptor");
            return this.getApplicationIdFromDescriptor(descriptor);
        }
        catch (Exception e) {
            this.error("Failed to get application descriptor from " + obj, e);
            return null;
        }
    }

    private String getApplicationIdFromDescriptor(Object obj) {
        try {
            return (String)this.invokeMethod0(obj, "getApplicationId");
        }
        catch (Exception e) {
            this.error("Failed to get application id from " + obj, e);
            return null;
        }
    }

    private Object invokeMethod0(Object obj, String method) throws Exception {
        return this.invokeMethodn(obj, method, null, null);
    }

    private Object invokeMethod1(Object obj, String method, Class paramType, Object param) throws Exception {
        return this.invokeMethodn(obj, method, new Class[]{paramType}, new Object[]{param});
    }

    private Object invokeMethodn(Object obj, String method, Class[] paramTypes, Object[] param) throws Exception {
        Class<?> clazz = obj.getClass();
        try {
            Method m = clazz.getMethod(method, paramTypes);
            return m.invoke(obj, param);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof Exception) {
                throw (Exception)e.getTargetException();
            }
            throw e;
        }
    }

    private boolean testObjectClass(Object value, String className) {
        if (value instanceof String[]) {
            String[] classes = (String[])value;
            int i = 0;
            while (i < classes.length) {
                if (classes[i].equals(className)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return className.equals(value);
    }

    public Object addingService(ServiceReference reference) {
        Object service = this.bc.getService(reference);
        if (!this.suppressEventFiring) {
            String id;
            if (this.testObjectClass(reference.getProperty("objectClass"), APPLICATION_DESCRIPTOR)) {
                String id2 = this.getApplicationIdFromDescriptor(service);
                if (id2 != null) {
                    this.fireApplicationEvent(id2, 1);
                }
            } else if (this.testObjectClass(reference.getProperty("objectClass"), APPLICATION_HANDLE) && (id = this.getApplicationIdFromHandle(service)) != null) {
                this.fireApplicationEvent(id, 4);
            }
        }
        return service;
    }

    public void modifiedService(ServiceReference reference, Object service) {
    }

    public void removedService(ServiceReference reference, Object service) {
        this.bc.ungetService(reference);
        if (!this.suppressEventFiring) {
            String id;
            if (this.testObjectClass(reference.getProperty("objectClass"), APPLICATION_DESCRIPTOR)) {
                String id2 = this.getApplicationIdFromDescriptor(service);
                if (id2 != null) {
                    this.fireApplicationEvent(id2, 16);
                }
            } else if (this.testObjectClass(reference.getProperty("objectClass"), APPLICATION_HANDLE) && (id = this.getApplicationIdFromHandle(service)) != null) {
                this.fireApplicationEvent(id, 8);
            }
        }
    }

    public Object getProperties(String applicationId) {
        Object descriptor = this.findApplicationDescriptor(applicationId);
        if (descriptor == null) {
            return new Error(-7903, "Application has been uninstalled");
        }
        try {
            Object result;
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((result = this.invokeMethod1(descriptor, "getProperties", clazz, null)) instanceof Map) {
                Map map = this.convertProperties((Map)result);
                ServiceReference sr = this.findDescriptorReference(applicationId);
                if (sr != null) {
                    map.putAll(this.getReferenceProperties(sr));
                }
                return map;
            }
        }
        catch (Exception e) {
            return new Error(-7000, "Cannot get properties: " + DebugUtils.toString(e));
        }
        return new Hashtable();
    }

    private Map getReferenceProperties(ServiceReference ref) {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        String[] keys = ref.getPropertyKeys();
        int i = 0;
        while (i < keys.length) {
            Object value = ref.getProperty(keys[i]);
            if (value != null) {
                props.put(keys[i], this.convertObject(ref.getProperty(keys[i])));
            }
            ++i;
        }
        return props;
    }

    private Map convertProperties(Map props) {
        Hashtable result = new Hashtable();
        Set keys = props.keySet();
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            Object value = props.get(key);
            if (value == null) continue;
            result.put(key, this.convertObject(value));
        }
        return result;
    }

    private Object convertObject(Object obj) {
        if (obj instanceof URL) {
            return obj.toString();
        }
        if (obj instanceof URL[]) {
            URL[] urls = (URL[])obj;
            String[] result = new String[urls.length];
            int i = 0;
            while (i < result.length) {
                result[i] = urls[i].toString();
                ++i;
            }
            return result;
        }
        return obj;
    }
}

