/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.ai.triton.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.ai.triton.server.TritonServerInstanceManager;
import org.eclipse.kura.ai.triton.server.TritonServerServiceOptions;
import org.eclipse.kura.container.orchestration.ContainerConfiguration;
import org.eclipse.kura.container.orchestration.ContainerInstanceDescriptor;
import org.eclipse.kura.container.orchestration.ContainerNetworkConfiguration;
import org.eclipse.kura.container.orchestration.ContainerOrchestrationService;
import org.eclipse.kura.container.orchestration.ContainerState;
import org.eclipse.kura.container.orchestration.ImageConfiguration;
import org.eclipse.kura.container.orchestration.ImageInstanceDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TritonServerContainerManager
implements TritonServerInstanceManager {
    private static final Logger logger = LoggerFactory.getLogger(TritonServerContainerManager.class);
    private static final int MONITOR_PERIOD = 30;
    private static final String TRITON_CONTAINER_NAME = "tritonserver-kura";
    private static final String TRITON_LOGGING_TYPE = "DEFAULT";
    private static final String TRITON_INTERNAL_MODEL_REPO = "/models";
    private static final boolean TRITON_FRAMEWORK_MANAGED = true;
    private static final List<Integer> TRITON_INTERNAL_PORTS = Arrays.asList(8000, 8001, 8002);
    private TritonServerServiceOptions options;
    private ContainerOrchestrationService containerOrchestrationService;
    private String decryptionFolderPath;
    private ScheduledExecutorService scheduledExecutorService;
    private ScheduledFuture<?> scheduledFuture;

    protected TritonServerContainerManager(TritonServerServiceOptions options, ContainerOrchestrationService containerOrchestrationService, String decryptionFolderPath) {
        this.options = options;
        this.containerOrchestrationService = containerOrchestrationService;
        this.decryptionFolderPath = decryptionFolderPath;
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
    }

    @Override
    public void start() {
        if (!this.isImageAvailable()) {
            logger.error("Docker image not available on disk. Aborting....");
            return;
        }
        this.startContainerServerMonitor();
    }

    @Override
    public void stop() {
        this.stopLocalServerMonitor();
        this.stopScheduledExecutor();
    }

    @Override
    public void kill() {
        this.killLocalServerMonitor();
        this.stopScheduledExecutor();
    }

    private void startContainerServerMonitor() {
        this.scheduledFuture = this.scheduledExecutorService.scheduleAtFixedRate(() -> {
            Thread.currentThread().setName(this.getClass().getSimpleName());
            if (!this.isServerRunning()) {
                this.startLocalServer();
            }
        }, 0L, 30L, TimeUnit.SECONDS);
    }

    private void startLocalServer() {
        ContainerConfiguration containerConfiguration = this.createContainerConfiguration();
        try {
            String containerID = this.containerOrchestrationService.startContainer(containerConfiguration);
            logger.info("Nvidia Triton Container started. Container ID: {}", (Object)containerID);
        }
        catch (InterruptedException e) {
            logger.info("Nvidia Triton Container start interrupted.", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (KuraException e) {
            logger.info("Nvidia Triton Container not started.", (Throwable)e);
        }
    }

    private void stopLocalServerMonitor() {
        this.stopMonitor();
        this.stopLocalServer();
    }

    private void killLocalServerMonitor() {
        this.stopMonitor();
        this.killLocalServer();
    }

    private void stopMonitor() {
        if (Objects.nonNull(this.scheduledFuture)) {
            this.scheduledFuture.cancel(true);
            while (!this.scheduledFuture.isDone()) {
                TritonServerContainerManager.sleepFor(500L);
            }
        }
    }

    private synchronized void stopLocalServer() {
        try {
            String containerID = this.getContainerID();
            this.containerOrchestrationService.stopContainer(containerID);
            this.containerOrchestrationService.deleteContainer(containerID);
        }
        catch (KuraException e) {
            logger.error("Can't stop container. Caused by", (Throwable)e);
        }
    }

    private synchronized void killLocalServer() {
        this.stopLocalServer();
    }

    private void stopScheduledExecutor() {
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdown();
            while (!this.scheduledExecutorService.isTerminated()) {
                TritonServerContainerManager.sleepFor(500L);
            }
            this.scheduledExecutorService = null;
        }
    }

    @Override
    public boolean isServerRunning() {
        Optional<ContainerInstanceDescriptor> existingInstance;
        block3: {
            try {
                existingInstance = this.containerOrchestrationService.listContainerDescriptors().stream().filter(c -> c.getContainerName().equals(TRITON_CONTAINER_NAME)).findAny();
                if (existingInstance.isPresent()) break block3;
                return false;
            }
            catch (IllegalStateException e) {
                logger.error("Cannot retrieve container status information", (Throwable)e);
                return false;
            }
        }
        ContainerInstanceDescriptor descr = existingInstance.get();
        return descr.getContainerState() == ContainerState.ACTIVE || descr.getContainerState() == ContainerState.STARTING;
    }

    private boolean isImageAvailable() {
        List existingImage;
        try {
            existingImage = this.containerOrchestrationService.listImageInstanceDescriptors();
        }
        catch (IllegalStateException e) {
            logger.error("Cannot retrieve container image status information", (Throwable)e);
            return false;
        }
        for (ImageInstanceDescriptor imageDescriptor : existingImage) {
            if (!imageDescriptor.getImageName().equals(this.options.getContainerImage()) || !imageDescriptor.getImageTag().equals(this.options.getContainerImageTag())) continue;
            return true;
        }
        return false;
    }

    private String getContainerID() throws KuraException {
        Optional<ContainerInstanceDescriptor> existingInstance = this.containerOrchestrationService.listContainerDescriptors().stream().filter(c -> c.getContainerName().equals(TRITON_CONTAINER_NAME)).findAny();
        if (!existingInstance.isPresent()) {
            throw new KuraException(KuraErrorCode.NOT_FOUND, new Object[]{"Can't find Kura-managed Triton server container"});
        }
        ContainerInstanceDescriptor descr = existingInstance.get();
        return descr.getContainerId();
    }

    private static void sleepFor(long timeout) {
        try {
            Thread.sleep(timeout);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.debug(e.getMessage(), (Throwable)e);
        }
    }

    private ContainerConfiguration createContainerConfiguration() {
        ImageConfiguration.ImageConfigurationBuilder imageConfigBuilder = new ImageConfiguration.ImageConfigurationBuilder();
        imageConfigBuilder.setImageName(this.options.getContainerImage());
        imageConfigBuilder.setImageTag(this.options.getContainerImageTag());
        imageConfigBuilder.setRegistryCredentials(Optional.empty());
        ContainerNetworkConfiguration.ContainerNetworkConfigurationBuilder networkConfigurationBuilder = new ContainerNetworkConfiguration.ContainerNetworkConfigurationBuilder();
        networkConfigurationBuilder.setNetworkMode(Optional.empty());
        ContainerConfiguration.ContainerConfigurationBuilder builder = new ContainerConfiguration.ContainerConfigurationBuilder();
        builder.setImageConfiguration(imageConfigBuilder.build());
        builder.setContainerNetowrkConfiguration(networkConfigurationBuilder.build());
        builder.setContainerName(TRITON_CONTAINER_NAME);
        builder.setFrameworkManaged(Boolean.valueOf(true));
        builder.setLoggingType(TRITON_LOGGING_TYPE);
        builder.setInternalPorts(TRITON_INTERNAL_PORTS);
        builder.setExternalPorts(Arrays.asList(this.options.getHttpPort(), this.options.getGrpcPort(), this.options.getMetricsPort()));
        builder.setMemory(this.options.getContainerMemory());
        builder.setCpus(this.options.getContainerCpus());
        builder.setGpus(this.options.getContainerGpus());
        if (this.options.isModelEncryptionPasswordSet()) {
            builder.setVolumes(Collections.singletonMap(this.decryptionFolderPath, TRITON_INTERNAL_MODEL_REPO));
        } else {
            builder.setVolumes(Collections.singletonMap(this.options.getModelRepositoryPath(), TRITON_INTERNAL_MODEL_REPO));
        }
        ArrayList<String> entrypointOverride = new ArrayList<String>();
        entrypointOverride.add("tritonserver");
        entrypointOverride.add("--model-repository=/models");
        entrypointOverride.add("--model-control-mode=explicit");
        if (!this.options.getBackendsConfigs().isEmpty()) {
            this.options.getBackendsConfigs().forEach(config -> {
                boolean bl = entrypointOverride.add("--backend-config=" + config);
            });
        }
        builder.setEntryPoint(entrypointOverride);
        return builder.build();
    }
}

