/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.json.marshaller.unmarshaller.wiregraph;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.eclipse.kura.configuration.ComponentConfiguration;
import org.eclipse.kura.core.configuration.ComponentConfigurationImpl;
import org.eclipse.kura.wire.graph.MultiportWireConfiguration;
import org.eclipse.kura.wire.graph.WireComponentConfiguration;
import org.eclipse.kura.wire.graph.WireGraphConfiguration;

public class WireGraphJsonMarshallUnmarshallImpl {
    private static final String RENDERING_PROPERTIES_KEY = "renderingProperties";
    private static final String OUTPUT_PORT_COUNT_KEY = "outputPortCount";
    private static final String INPUT_PORT_COUNT_KEY = "inputPortCount";
    private static final String PID_KEY = "pid";
    private static final String OUTPUT_PORT_NAMES_KEY = "outputPortNames";
    private static final String INPUT_PORT_NAMES_KEY = "inputPortNames";
    private static final String POSITION_KEY = "position";
    private static final String RECEIVER_PID_KEY = "receiver";
    private static final String RECEIVER_PORT_KEY = "receiverPort";
    private static final String EMITTER_PID_KEY = "emitter";
    private static final String EMITTER_PORT_KEY = "emitterPort";
    private static final String WIRES_KEY = "wires";
    private static final String COMPONENTS_KEY = "components";

    public static JsonObject marshalWireGraphConfiguration(WireGraphConfiguration graphConfiguration) {
        JsonArray wireConfigurationJson = WireGraphJsonMarshallUnmarshallImpl.marshalWireConfigurationList(graphConfiguration.getWireConfigurations());
        JsonArray wireComponentConfigurationJson = WireGraphJsonMarshallUnmarshallImpl.marshalWireComponentConfigurationList(graphConfiguration.getWireComponentConfigurations());
        JsonObject wireGraphConfiguration = new JsonObject();
        wireGraphConfiguration.add(COMPONENTS_KEY, (JsonValue)wireComponentConfigurationJson);
        wireGraphConfiguration.add(WIRES_KEY, (JsonValue)wireConfigurationJson);
        return wireGraphConfiguration;
    }

    private static JsonObject marshalWireConfiguration(MultiportWireConfiguration wireConfig) {
        JsonObject result = new JsonObject();
        result.add(EMITTER_PID_KEY, wireConfig.getEmitterPid());
        result.add(EMITTER_PORT_KEY, wireConfig.getEmitterPort());
        result.add(RECEIVER_PID_KEY, wireConfig.getReceiverPid());
        result.add(RECEIVER_PORT_KEY, wireConfig.getReceiverPort());
        return result;
    }

    private static JsonArray marshalWireConfigurationList(List<MultiportWireConfiguration> wireConfigurations) {
        JsonArray value = new JsonArray();
        for (MultiportWireConfiguration wireConfiguration : wireConfigurations) {
            value.add((JsonValue)WireGraphJsonMarshallUnmarshallImpl.marshalWireConfiguration(wireConfiguration));
        }
        return value;
    }

    private static JsonArray marshalWireComponentConfigurationList(List<WireComponentConfiguration> wireComponentConfigurations) {
        JsonArray value = new JsonArray();
        for (WireComponentConfiguration wireComponentConfiguration : wireComponentConfigurations) {
            String pid = wireComponentConfiguration.getConfiguration().getPid();
            value.add((JsonValue)WireGraphJsonMarshallUnmarshallImpl.marshalComponentProperties(pid, wireComponentConfiguration.getProperties()));
        }
        return value;
    }

    private static JsonObject marshalComponentProperties(String pid, Map<String, Object> componentProperties) {
        JsonObject result = new JsonObject();
        JsonObject resultElems = new JsonObject();
        JsonObject position = WireGraphJsonMarshallUnmarshallImpl.marshalPosition(componentProperties);
        resultElems.add(POSITION_KEY, (JsonValue)position);
        JsonObject inputPortNames = WireGraphJsonMarshallUnmarshallImpl.marshalInputPortNames(componentProperties);
        resultElems.add(INPUT_PORT_NAMES_KEY, (JsonValue)inputPortNames);
        JsonObject outputPortNames = WireGraphJsonMarshallUnmarshallImpl.marshalOutputPortNames(componentProperties);
        resultElems.add(OUTPUT_PORT_NAMES_KEY, (JsonValue)outputPortNames);
        result.add(PID_KEY, pid);
        WireGraphJsonMarshallUnmarshallImpl.addPropertyChecked(componentProperties, INPUT_PORT_COUNT_KEY, INPUT_PORT_COUNT_KEY, Integer.class, (arg_0, arg_1) -> ((JsonObject)result).add(arg_0, arg_1));
        WireGraphJsonMarshallUnmarshallImpl.addPropertyChecked(componentProperties, OUTPUT_PORT_COUNT_KEY, OUTPUT_PORT_COUNT_KEY, Integer.class, (arg_0, arg_1) -> ((JsonObject)result).add(arg_0, arg_1));
        result.add(RENDERING_PROPERTIES_KEY, (JsonValue)resultElems);
        return result;
    }

    private static JsonObject marshalPosition(Map<String, Object> componentProperties) {
        JsonObject positionElems = new JsonObject();
        WireGraphJsonMarshallUnmarshallImpl.addPropertyChecked(componentProperties, "x", "position.x", Float.class, (arg_0, arg_1) -> ((JsonObject)positionElems).add(arg_0, arg_1));
        WireGraphJsonMarshallUnmarshallImpl.addPropertyChecked(componentProperties, "y", "position.y", Float.class, (arg_0, arg_1) -> ((JsonObject)positionElems).add(arg_0, arg_1));
        return positionElems;
    }

    private static JsonObject marshalInputPortNames(Map<String, Object> componentProperties) {
        JsonObject inputPortElems = new JsonObject();
        for (Map.Entry<String, Object> mapEntry : componentProperties.entrySet()) {
            if (!mapEntry.getKey().startsWith(INPUT_PORT_NAMES_KEY) || !(mapEntry.getValue() instanceof String)) continue;
            String portNumber = mapEntry.getKey().split("\\.")[1];
            inputPortElems.add(portNumber, (String)mapEntry.getValue());
        }
        return inputPortElems;
    }

    private static JsonObject marshalOutputPortNames(Map<String, Object> componentProperties) {
        JsonObject outputPortElems = new JsonObject();
        for (Map.Entry<String, Object> mapEntry : componentProperties.entrySet()) {
            if (!mapEntry.getKey().startsWith(OUTPUT_PORT_NAMES_KEY) || !(mapEntry.getValue() instanceof String)) continue;
            String portNumber = mapEntry.getKey().split("\\.")[1];
            outputPortElems.add(portNumber, (String)mapEntry.getValue());
        }
        return outputPortElems;
    }

    public static WireGraphConfiguration unmarshalToWireGraphConfiguration(String jsonString) {
        List<Object> wireCompConfigList = new ArrayList();
        List<Object> wireConfigList = new ArrayList();
        JsonObject json = Json.parse((String)jsonString).asObject();
        for (JsonObject.Member member : json) {
            String name = member.getName();
            JsonValue value = member.getValue();
            if (WIRES_KEY.equalsIgnoreCase(name) && value.isArray()) {
                wireConfigList = WireGraphJsonMarshallUnmarshallImpl.unmarshalWireConfiguration(value.asArray());
                continue;
            }
            if (!COMPONENTS_KEY.equalsIgnoreCase(name) || !value.isArray()) continue;
            wireCompConfigList = WireGraphJsonMarshallUnmarshallImpl.unmarshalWireComponentConfiguration(value.asArray());
        }
        return new WireGraphConfiguration(wireCompConfigList, wireConfigList);
    }

    private static List<MultiportWireConfiguration> unmarshalWireConfiguration(JsonArray array) {
        ArrayList<MultiportWireConfiguration> wireConfigurationList = new ArrayList<MultiportWireConfiguration>();
        array.forEach(jsonWireConfigValue -> {
            JsonObject jsonWireConfig = jsonWireConfigValue.asObject();
            String emitterPid = null;
            String receiverPid = null;
            int emitterPort = 0;
            int receiverPort = 0;
            for (JsonObject.Member member : jsonWireConfig) {
                String name = member.getName();
                JsonValue value = member.getValue();
                if (EMITTER_PID_KEY.equalsIgnoreCase(name) && value.isString()) {
                    emitterPid = value.asString();
                    continue;
                }
                if (RECEIVER_PID_KEY.equalsIgnoreCase(name) && value.isString()) {
                    receiverPid = value.asString();
                    continue;
                }
                if (EMITTER_PORT_KEY.equalsIgnoreCase(name) && value.isNumber()) {
                    emitterPort = value.asInt();
                    continue;
                }
                if (!RECEIVER_PORT_KEY.equalsIgnoreCase(name) || !value.isNumber()) continue;
                receiverPort = value.asInt();
            }
            if (emitterPid != null && receiverPid != null) {
                MultiportWireConfiguration wireConfiguration = new MultiportWireConfiguration(emitterPid, receiverPid, emitterPort, receiverPort);
                wireConfigurationList.add(wireConfiguration);
            }
        });
        return wireConfigurationList;
    }

    private static List<WireComponentConfiguration> unmarshalWireComponentConfiguration(JsonArray array) {
        ArrayList<WireComponentConfiguration> wireComponentConfigurationList = new ArrayList<WireComponentConfiguration>();
        Iterator jsonIterator = array.iterator();
        while (jsonIterator.hasNext()) {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            String componentPid = null;
            JsonObject jsonWireComponentConfiguration = ((JsonValue)jsonIterator.next()).asObject();
            for (JsonObject.Member member : jsonWireComponentConfiguration) {
                String name = member.getName();
                JsonValue value = member.getValue();
                if (INPUT_PORT_COUNT_KEY.equalsIgnoreCase(name) && value.isNumber()) {
                    properties.put(name, value.asInt());
                    continue;
                }
                if (OUTPUT_PORT_COUNT_KEY.equalsIgnoreCase(name) && value.isNumber()) {
                    properties.put(name, value.asInt());
                    continue;
                }
                if (RENDERING_PROPERTIES_KEY.equalsIgnoreCase(name) && value.isObject()) {
                    Map<String, Object> renderingProperties = WireGraphJsonMarshallUnmarshallImpl.unmarshalRenderingProperties(value.asObject());
                    properties.putAll(renderingProperties);
                    continue;
                }
                if (!PID_KEY.equalsIgnoreCase(name) || !value.isString()) continue;
                componentPid = value.asString();
            }
            if (componentPid == null) continue;
            ComponentConfigurationImpl componentConfiguration = new ComponentConfigurationImpl(componentPid, null, null);
            WireComponentConfiguration wireComponentConfiguration = new WireComponentConfiguration((ComponentConfiguration)componentConfiguration, properties);
            wireComponentConfigurationList.add(wireComponentConfiguration);
        }
        return wireComponentConfigurationList;
    }

    private static Map<String, Object> unmarshalRenderingProperties(JsonObject jsonRenderingProps) {
        HashMap<String, Object> renderingProps = new HashMap<String, Object>();
        for (JsonObject.Member member : jsonRenderingProps) {
            String name = member.getName();
            JsonValue value = member.getValue();
            if (POSITION_KEY.equalsIgnoreCase(name) && value.isObject()) {
                Map<String, Object> positionMap = WireGraphJsonMarshallUnmarshallImpl.unmarshalPosition(value.asObject());
                renderingProps.putAll(positionMap);
                continue;
            }
            if (INPUT_PORT_NAMES_KEY.equalsIgnoreCase(name) && value.isObject()) {
                Map<String, Object> inputPortNamesMap = WireGraphJsonMarshallUnmarshallImpl.unmarshalInputPortNames(value.asObject());
                renderingProps.putAll(inputPortNamesMap);
                continue;
            }
            if (!OUTPUT_PORT_NAMES_KEY.equalsIgnoreCase(name) || !value.isObject()) continue;
            Map<String, Object> outputPortNamesMap = WireGraphJsonMarshallUnmarshallImpl.unmarshalOutputPortNames(value.asObject());
            renderingProps.putAll(outputPortNamesMap);
        }
        return renderingProps;
    }

    private static Map<String, Object> unmarshalInputPortNames(JsonObject jsonInputPortNames) {
        HashMap<String, Object> inputPortNamesMap = new HashMap<String, Object>();
        for (JsonObject.Member member : jsonInputPortNames) {
            String name = member.getName();
            JsonValue value = member.getValue();
            if (!value.isString()) continue;
            inputPortNamesMap.put("inputPortNames." + name, value.asString());
        }
        return inputPortNamesMap;
    }

    private static Map<String, Object> unmarshalOutputPortNames(JsonObject jsonOutputPortNames) {
        HashMap<String, Object> outputPortNamesMap = new HashMap<String, Object>();
        for (JsonObject.Member member : jsonOutputPortNames) {
            String name = member.getName();
            JsonValue value = member.getValue();
            if (!value.isString()) continue;
            outputPortNamesMap.put("outputPortNames." + name, value.asString());
        }
        return outputPortNamesMap;
    }

    private static Map<String, Object> unmarshalPosition(JsonObject jsonPositionPros) {
        HashMap<String, Object> positionMap = new HashMap<String, Object>();
        for (JsonObject.Member member : jsonPositionPros) {
            String name = member.getName();
            JsonValue value = member.getValue();
            if ("x".equalsIgnoreCase(name) && value.isNumber()) {
                positionMap.put("position.x", Float.valueOf(value.asFloat()));
                continue;
            }
            if (!"y".equalsIgnoreCase(name) || !value.isNumber()) continue;
            positionMap.put("position.y", Float.valueOf(value.asFloat()));
        }
        return positionMap;
    }

    private static <T> void addPropertyChecked(Map<String, Object> componentProperties, String jsonPropertyKey, String componentPropertyKey, Class<T> expectedClass, BiConsumer<String, T> adder) {
        Object property = componentProperties.get(componentPropertyKey);
        if (!expectedClass.isInstance(property)) {
            return;
        }
        adder.accept(jsonPropertyKey, (String)property);
    }
}

