/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.mtoolkit.iagent.pmp;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.framework.BundleContext;
import org.tigris.mtoolkit.iagent.internal.pmp.Server;
import org.tigris.mtoolkit.iagent.pmp.PMPException;
import org.tigris.mtoolkit.iagent.pmp.PMPServer;

public class PMPServerFactory {
    public static final String MAX_STRING = "maxstringlength";
    public static final String MAX_ARRAY = "maxarraylength";
    public static final String TIMEOUT = "timeout";

    public static PMPServer createServer(BundleContext context, int port, Dictionary props) throws PMPException {
        if (props == null) {
            props = new Hashtable<String, Object>();
        }
        String uri = "tcp://:" + String.valueOf(port);
        ((Dictionary)props).put("uri", uri);
        ((Dictionary)props).put("port", new Integer(port));
        if (((Dictionary)props).get(TIMEOUT) == null) {
            ((Dictionary)props).put(TIMEOUT, new Integer(10000));
        }
        if (((Dictionary)props).get(MAX_STRING) == null) {
            ((Dictionary)props).put(MAX_STRING, new Integer(255));
        }
        if (((Dictionary)props).get(MAX_ARRAY) == null) {
            ((Dictionary)props).put(MAX_ARRAY, new Integer(300000));
        }
        try {
            Server newServer = new Server(context, props);
            return newServer;
        }
        catch (IOException exc) {
            String msg = "Error creating transport configuration for " + ((Dictionary)props).get("uri");
            throw new PMPException(msg, exc);
        }
    }
}

