/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.bcpg.InputStreamPacket;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.bcpg.SymmetricKeyAlgorithmTags;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.util.Arrays;

public abstract class PGPEncryptedData
implements SymmetricKeyAlgorithmTags {
    InputStreamPacket encData;
    InputStream encStream;
    TruncatedStream truncStream;
    PGPDigestCalculator integrityCalculator;

    PGPEncryptedData(InputStreamPacket inputStreamPacket) {
        this.encData = inputStreamPacket;
    }

    public InputStream getInputStream() {
        return this.encData.getInputStream();
    }

    public boolean isIntegrityProtected() {
        return this.encData instanceof SymmetricEncIntegrityPacket;
    }

    public boolean verify() throws PGPException, IOException {
        if (!this.isIntegrityProtected()) {
            throw new PGPException("data not integrity protected.");
        }
        while (this.encStream.read() >= 0) {
        }
        int[] nArray = this.truncStream.getLookAhead();
        OutputStream outputStream = this.integrityCalculator.getOutputStream();
        outputStream.write((byte)nArray[0]);
        outputStream.write((byte)nArray[1]);
        byte[] byArray = this.integrityCalculator.getDigest();
        byte[] byArray2 = new byte[byArray.length];
        for (int i = 0; i != byArray2.length; ++i) {
            byArray2[i] = (byte)nArray[i + 2];
        }
        return Arrays.constantTimeAreEqual((byte[])byArray, (byte[])byArray2);
    }

    public int getVersion() {
        throw new UnsupportedOperationException("not supported - override required");
    }

    public int getAlgorithm() {
        throw new UnsupportedOperationException("not supported - override required");
    }

    protected class TruncatedStream
    extends InputStream {
        int[] lookAhead = new int[22];
        int bufPtr;
        InputStream in;

        TruncatedStream(InputStream inputStream) throws IOException {
            for (int i = 0; i != this.lookAhead.length; ++i) {
                this.lookAhead[i] = inputStream.read();
                if (this.lookAhead[i] >= 0) continue;
                throw new EOFException();
            }
            this.bufPtr = 0;
            this.in = inputStream;
        }

        @Override
        public int read() throws IOException {
            int n = this.in.read();
            if (n >= 0) {
                int n2 = this.lookAhead[this.bufPtr];
                this.lookAhead[this.bufPtr] = n;
                this.bufPtr = (this.bufPtr + 1) % this.lookAhead.length;
                return n2;
            }
            return -1;
        }

        int[] getLookAhead() {
            int n;
            int[] nArray = new int[this.lookAhead.length];
            int n2 = 0;
            for (n = this.bufPtr; n != this.lookAhead.length; ++n) {
                nArray[n2++] = this.lookAhead[n];
            }
            for (n = 0; n != this.bufPtr; ++n) {
                nArray[n2++] = this.lookAhead[n];
            }
            return nArray;
        }
    }
}

