/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.rest.service.listing.provider.dto;

import java.util.List;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.internal.rest.service.listing.provider.util.FilterBuilder;

public class FilterDTO {
    private final String name;
    private final String value;
    private final List<FilterDTO> and;
    private final List<FilterDTO> or;
    private final FilterDTO not;

    public FilterDTO(String name, String value, List<FilterDTO> and, List<FilterDTO> or, FilterDTO not) {
        this.name = name;
        this.value = value;
        this.and = and;
        this.or = or;
        this.not = not;
    }

    public String toOSGIFilter() {
        return this.toOSGIFilter(new FilterBuilder()).build();
    }

    public void validate() throws KuraException {
        int count = 0;
        if (this.name != null) {
            if (this.name.contains(" ")) {
                throw new KuraException(KuraErrorCode.BAD_REQUEST, new Object[]{"Name must contain no spaces"});
            }
            if (this.name.trim().isEmpty()) {
                throw new KuraException(KuraErrorCode.BAD_REQUEST, new Object[]{"Name must not be empty"});
            }
            ++count;
        }
        if (this.and != null) {
            ++count;
        }
        if (this.or != null) {
            ++count;
        }
        if (this.not != null) {
            ++count;
        }
        if (count != 1) {
            throw new KuraException(KuraErrorCode.BAD_REQUEST, new Object[]{"Exactly one among the \"name\", \"and\", \"or\" and \"not\" properties must be specified"});
        }
    }

    private FilterBuilder toOSGIFilter(FilterBuilder filterBuilder) {
        if (this.name != null) {
            filterBuilder.property(this.name, this.value);
        } else if (this.and != null) {
            filterBuilder.and(b -> this.and.forEach(f -> {
                FilterBuilder filterBuilder2 = f.toOSGIFilter((FilterBuilder)b);
            }));
        } else if (this.or != null) {
            filterBuilder.or(b -> this.or.forEach(f -> {
                FilterBuilder filterBuilder2 = f.toOSGIFilter((FilterBuilder)b);
            }));
        } else if (this.not != null) {
            filterBuilder.not(this.not::toOSGIFilter);
        }
        return filterBuilder;
    }
}

