/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server.net;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.configuration.ConfigurationService;
import org.eclipse.kura.configuration.Password;
import org.eclipse.kura.core.net.AbstractNetInterface;
import org.eclipse.kura.core.net.util.NetworkUtil;
import org.eclipse.kura.core.util.NetUtil;
import org.eclipse.kura.net.IP4Address;
import org.eclipse.kura.net.IPAddress;
import org.eclipse.kura.net.NetConfig;
import org.eclipse.kura.net.NetConfigIP4;
import org.eclipse.kura.net.NetInterfaceAddressConfig;
import org.eclipse.kura.net.NetInterfaceConfig;
import org.eclipse.kura.net.NetInterfaceState;
import org.eclipse.kura.net.NetInterfaceStatus;
import org.eclipse.kura.net.NetInterfaceType;
import org.eclipse.kura.net.NetworkAdminService;
import org.eclipse.kura.net.dhcp.DhcpLease;
import org.eclipse.kura.net.dhcp.DhcpServerConfigIP4;
import org.eclipse.kura.net.firewall.FirewallAutoNatConfig;
import org.eclipse.kura.net.firewall.FirewallNatConfig;
import org.eclipse.kura.net.firewall.FirewallOpenPortConfigIP4;
import org.eclipse.kura.net.firewall.FirewallPortForwardConfigIP4;
import org.eclipse.kura.net.modem.CellularModem;
import org.eclipse.kura.net.modem.ModemConfig;
import org.eclipse.kura.net.modem.ModemConnectionStatus;
import org.eclipse.kura.net.modem.ModemInterface;
import org.eclipse.kura.net.modem.ModemInterfaceAddressConfig;
import org.eclipse.kura.net.modem.ModemManagerService;
import org.eclipse.kura.net.modem.ModemPdpContext;
import org.eclipse.kura.net.modem.ModemPdpContextType;
import org.eclipse.kura.net.modem.ModemRegistrationStatus;
import org.eclipse.kura.net.modem.ModemTechnologyType;
import org.eclipse.kura.net.wifi.WifiBgscan;
import org.eclipse.kura.net.wifi.WifiBgscanModule;
import org.eclipse.kura.net.wifi.WifiChannel;
import org.eclipse.kura.net.wifi.WifiCiphers;
import org.eclipse.kura.net.wifi.WifiClientMonitorService;
import org.eclipse.kura.net.wifi.WifiConfig;
import org.eclipse.kura.net.wifi.WifiHotspotInfo;
import org.eclipse.kura.net.wifi.WifiInterfaceAddressConfig;
import org.eclipse.kura.net.wifi.WifiMode;
import org.eclipse.kura.net.wifi.WifiRadioMode;
import org.eclipse.kura.net.wifi.WifiSecurity;
import org.eclipse.kura.system.SystemService;
import org.eclipse.kura.usb.UsbDevice;
import org.eclipse.kura.web.server.util.GwtServerUtil;
import org.eclipse.kura.web.server.util.KuraExceptionHandler;
import org.eclipse.kura.web.server.util.ServiceLocator;
import org.eclipse.kura.web.shared.GwtKuraErrorCode;
import org.eclipse.kura.web.shared.GwtKuraException;
import org.eclipse.kura.web.shared.GwtSafeHtmlUtils;
import org.eclipse.kura.web.shared.model.GwtDhcpLease;
import org.eclipse.kura.web.shared.model.GwtFirewallNatEntry;
import org.eclipse.kura.web.shared.model.GwtFirewallOpenPortEntry;
import org.eclipse.kura.web.shared.model.GwtFirewallPortForwardEntry;
import org.eclipse.kura.web.shared.model.GwtModemAuthType;
import org.eclipse.kura.web.shared.model.GwtModemInterfaceConfig;
import org.eclipse.kura.web.shared.model.GwtModemPdpEntry;
import org.eclipse.kura.web.shared.model.GwtModemPdpType;
import org.eclipse.kura.web.shared.model.GwtNetIfConfigMode;
import org.eclipse.kura.web.shared.model.GwtNetIfStatus;
import org.eclipse.kura.web.shared.model.GwtNetIfType;
import org.eclipse.kura.web.shared.model.GwtNetInterfaceConfig;
import org.eclipse.kura.web.shared.model.GwtNetRouterMode;
import org.eclipse.kura.web.shared.model.GwtWifiBgscanModule;
import org.eclipse.kura.web.shared.model.GwtWifiChannelFrequency;
import org.eclipse.kura.web.shared.model.GwtWifiCiphers;
import org.eclipse.kura.web.shared.model.GwtWifiConfig;
import org.eclipse.kura.web.shared.model.GwtWifiHotspotEntry;
import org.eclipse.kura.web.shared.model.GwtWifiNetInterfaceConfig;
import org.eclipse.kura.web.shared.model.GwtWifiRadioMode;
import org.eclipse.kura.web.shared.model.GwtWifiSecurity;
import org.eclipse.kura.web.shared.model.GwtWifiWirelessMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GwtNetworkServiceImpl {
    private static final Logger logger = LoggerFactory.getLogger(GwtNetworkServiceImpl.class);
    private static final String FIREWALL_CONFIGURATION_SERVICE_PID = "org.eclipse.kura.net.admin.FirewallConfigurationService";
    private static final String ENABLED = "enabled";
    private static final String UNKNOWN_NETWORK = "0.0.0.0/0";

    public static List<GwtNetInterfaceConfig> findNetInterfaceConfigurations(boolean recompute) throws GwtKuraException {
        List<GwtNetInterfaceConfig> result = GwtNetworkServiceImpl.privateFindNetInterfaceConfigurations(recompute);
        return GwtServerUtil.replaceNetworkConfigListSensitivePasswordsWithPlaceholder(result);
    }

    private static List<GwtNetInterfaceConfig> privateFindNetInterfaceConfigurations(boolean recompute) throws GwtKuraException {
        logger.debug("Starting");
        ArrayList<GwtNetInterfaceConfig> gwtNetConfigs = new ArrayList<GwtNetInterfaceConfig>();
        NetworkAdminService nas = null;
        try {
            nas = ServiceLocator.getInstance().getService(NetworkAdminService.class);
        }
        catch (Exception t) {
            logger.warn("Exception", (Throwable)t);
            return gwtNetConfigs;
        }
        ModemManagerService modemManagerService = null;
        try {
            modemManagerService = ServiceLocator.getInstance().getService(ModemManagerService.class);
        }
        catch (Exception t) {
            logger.warn("{ModemManagerService} Exception", (Throwable)t);
        }
        WifiClientMonitorService wifiClientMonitorService = null;
        try {
            wifiClientMonitorService = ServiceLocator.getInstance().getService(WifiClientMonitorService.class);
        }
        catch (Exception t) {
            logger.warn("{WifiClientMonitorService} Exception", (Throwable)t);
        }
        try {
            for (NetInterfaceConfig netIfConfig : nas.getNetworkInterfaceConfigs(recompute)) {
                logger.debug("Getting config for {} with type {}", (Object)netIfConfig.getName(), (Object)netIfConfig.getType());
                logger.debug("Interface State: {}", (Object)netIfConfig.getState());
                GwtNetInterfaceConfig gwtNetConfig = GwtNetworkServiceImpl.createGwtNetConfig((NetInterfaceConfig<? extends NetInterfaceAddressConfig>)netIfConfig);
                gwtNetConfig.setName(netIfConfig.getName());
                gwtNetConfig.setInterfaceName(netIfConfig.getName());
                gwtNetConfig.setHwName(netIfConfig.getName());
                if (netIfConfig.getType() != null) {
                    gwtNetConfig.setHwType(netIfConfig.getType().name());
                }
                if (netIfConfig.getState() != null) {
                    gwtNetConfig.setHwState(netIfConfig.getState().name());
                }
                logger.debug("MAC: {}", (Object)NetUtil.hardwareAddressToString((byte[])netIfConfig.getHardwareAddress()));
                gwtNetConfig.setHwAddress(NetUtil.hardwareAddressToString((byte[])netIfConfig.getHardwareAddress()));
                gwtNetConfig.setHwDriver(netIfConfig.getDriver());
                gwtNetConfig.setHwDriverVersion(netIfConfig.getDriverVersion());
                gwtNetConfig.setHwFirmware(netIfConfig.getFirmwareVersion());
                gwtNetConfig.setHwMTU(netIfConfig.getMTU());
                if (netIfConfig.getUsbDevice() != null) {
                    gwtNetConfig.setHwUsbDevice(netIfConfig.getUsbDevice().getUsbDevicePath());
                } else {
                    gwtNetConfig.setHwUsbDevice("N/A");
                }
                NetInterfaceAddressConfig addressConfig = ((AbstractNetInterface)netIfConfig).getNetInterfaceAddressConfig();
                if (addressConfig != null) {
                    List netConfigs;
                    if (addressConfig.getAddress() != null) {
                        logger.debug("current address: {}", (Object)addressConfig.getAddress().getHostAddress());
                    }
                    if (addressConfig.getNetworkPrefixLength() >= 0 && addressConfig.getNetworkPrefixLength() <= 32) {
                        logger.debug("current prefix length: {}", (Object)addressConfig.getNetworkPrefixLength());
                    }
                    if (addressConfig.getNetmask() != null) {
                        logger.debug("current netmask: {}", (Object)addressConfig.getNetmask().getHostAddress());
                    }
                    if ((netConfigs = addressConfig.getConfigs()) != null) {
                        boolean isNatEnabled = false;
                        boolean isDhcpServerEnabled = false;
                        for (NetConfig netConfig : netConfigs) {
                            if (netConfig instanceof NetConfigIP4) {
                                List dnsServers;
                                StringBuilder sb;
                                logger.debug("Setting up NetConfigIP4 with status {}", (Object)((NetConfigIP4)netConfig).getStatus());
                                if (((NetConfigIP4)netConfig).getStatus() == NetInterfaceStatus.netIPv4StatusEnabledLAN) {
                                    gwtNetConfig.setStatus(GwtNetIfStatus.netIPv4StatusEnabledLAN.name());
                                } else if (((NetConfigIP4)netConfig).getStatus() == NetInterfaceStatus.netIPv4StatusEnabledWAN) {
                                    gwtNetConfig.setStatus(GwtNetIfStatus.netIPv4StatusEnabledWAN.name());
                                } else if (((NetConfigIP4)netConfig).getStatus() == NetInterfaceStatus.netIPv4StatusUnmanaged) {
                                    gwtNetConfig.setStatus(GwtNetIfStatus.netIPv4StatusUnmanaged.name());
                                } else if (((NetConfigIP4)netConfig).getStatus() == NetInterfaceStatus.netIPv4StatusL2Only) {
                                    gwtNetConfig.setStatus(GwtNetIfStatus.netIPv4StatusL2Only.name());
                                } else {
                                    gwtNetConfig.setStatus(GwtNetIfStatus.netIPv4StatusDisabled.name());
                                }
                                if (((NetConfigIP4)netConfig).isDhcp() || netIfConfig.isLoopback()) {
                                    if (((NetConfigIP4)netConfig).isDhcp()) {
                                        gwtNetConfig.setConfigMode(GwtNetIfConfigMode.netIPv4ConfigModeDHCP.name());
                                    }
                                    if (netIfConfig.isLoopback()) {
                                        gwtNetConfig.setConfigMode(GwtNetIfConfigMode.netIPv4ConfigModeManual.name());
                                    }
                                    if (addressConfig.getAddress() != null) {
                                        gwtNetConfig.setIpAddress(addressConfig.getAddress().getHostAddress());
                                    } else {
                                        gwtNetConfig.setIpAddress("");
                                    }
                                    if (addressConfig.getNetworkPrefixLength() > 0 && addressConfig.getNetworkPrefixLength() <= 32) {
                                        gwtNetConfig.setSubnetMask(NetworkUtil.getNetmaskStringForm((int)addressConfig.getNetworkPrefixLength()));
                                    } else if (addressConfig.getNetmask() != null) {
                                        gwtNetConfig.setSubnetMask(addressConfig.getNetmask().getHostAddress());
                                    } else {
                                        gwtNetConfig.setSubnetMask("");
                                    }
                                    if (addressConfig.getGateway() != null) {
                                        gwtNetConfig.setGateway(addressConfig.getGateway().getHostAddress());
                                    } else {
                                        gwtNetConfig.setGateway("");
                                    }
                                    sb = new StringBuilder();
                                    dnsServers = addressConfig.getDnsServers();
                                    if (dnsServers != null && !dnsServers.isEmpty()) {
                                        String sep = "";
                                        for (IPAddress dnsServer : dnsServers) {
                                            sb.append(sep).append(dnsServer.getHostAddress());
                                            sep = "\n";
                                        }
                                        logger.debug("DNS Servers: {}", (Object)sb);
                                        gwtNetConfig.setReadOnlyDnsServers(sb.toString());
                                    } else {
                                        logger.debug("DNS Servers: [empty String]");
                                        gwtNetConfig.setReadOnlyDnsServers("");
                                    }
                                } else {
                                    gwtNetConfig.setConfigMode(GwtNetIfConfigMode.netIPv4ConfigModeManual.name());
                                    if (((NetConfigIP4)netConfig).getAddress() != null) {
                                        gwtNetConfig.setIpAddress(((IP4Address)((NetConfigIP4)netConfig).getAddress()).getHostAddress());
                                    } else {
                                        gwtNetConfig.setIpAddress("");
                                    }
                                    if (((NetConfigIP4)netConfig).getSubnetMask() != null) {
                                        gwtNetConfig.setSubnetMask(((IP4Address)((NetConfigIP4)netConfig).getSubnetMask()).getHostAddress());
                                    } else {
                                        gwtNetConfig.setSubnetMask("");
                                    }
                                    if (((NetConfigIP4)netConfig).getGateway() != null) {
                                        logger.debug("Gateway for {} is: {}", (Object)netIfConfig.getName(), (Object)((IP4Address)((NetConfigIP4)netConfig).getGateway()).getHostAddress());
                                        gwtNetConfig.setGateway(((IP4Address)((NetConfigIP4)netConfig).getGateway()).getHostAddress());
                                    } else {
                                        gwtNetConfig.setGateway("");
                                    }
                                }
                                sb = new StringBuilder();
                                dnsServers = ((NetConfigIP4)netConfig).getDnsServers();
                                if (dnsServers != null && !dnsServers.isEmpty()) {
                                    IPAddress dnsServer;
                                    dnsServer = dnsServers.iterator();
                                    while (dnsServer.hasNext()) {
                                        IP4Address dnsServer2 = (IP4Address)dnsServer.next();
                                        if (dnsServer2.getHostAddress().equals("127.0.0.1")) continue;
                                        sb.append(' ').append(dnsServer2.getHostAddress());
                                    }
                                    logger.debug("DNS Servers: {}", (Object)sb);
                                    gwtNetConfig.setDnsServers(sb.toString().trim());
                                } else {
                                    logger.debug("DNS Servers: [empty String]");
                                    gwtNetConfig.setDnsServers("");
                                }
                            }
                            if (netConfig instanceof WifiConfig) {
                                WifiMode activeWirelessMode;
                                int[] channels;
                                logger.debug("Setting up WifiConfigIP4");
                                WifiConfig wifiConfig = (WifiConfig)netConfig;
                                GwtWifiConfig gwtWifiConfig = new GwtWifiConfig();
                                if (wifiConfig.getMode() == WifiMode.MASTER) {
                                    gwtWifiConfig.setWirelessMode(GwtWifiWirelessMode.netWifiWirelessModeAccessPoint.name());
                                    ((GwtWifiNetInterfaceConfig)gwtNetConfig).setAccessPointWifiConfig(gwtWifiConfig);
                                } else if (wifiConfig.getMode() == WifiMode.INFRA) {
                                    gwtWifiConfig.setWirelessMode(GwtWifiWirelessMode.netWifiWirelessModeStation.name());
                                    ((GwtWifiNetInterfaceConfig)gwtNetConfig).setStationWifiConfig(gwtWifiConfig);
                                } else if (wifiConfig.getMode() == WifiMode.ADHOC) {
                                    gwtWifiConfig.setWirelessMode(GwtWifiWirelessMode.netWifiWirelessModeAdHoc.name());
                                    ((GwtWifiNetInterfaceConfig)gwtNetConfig).setAdhocWifiConfig(gwtWifiConfig);
                                }
                                gwtWifiConfig.setWirelessSsid(wifiConfig.getSSID());
                                gwtWifiConfig.setDriver(wifiConfig.getDriver());
                                switch (wifiConfig.getSecurity()) {
                                    case SECURITY_WPA: {
                                        gwtWifiConfig.setSecurity(GwtWifiSecurity.netWifiSecurityWPA.name());
                                        break;
                                    }
                                    case SECURITY_WPA2: {
                                        gwtWifiConfig.setSecurity(GwtWifiSecurity.netWifiSecurityWPA2.name());
                                        break;
                                    }
                                    case SECURITY_WPA_WPA2: {
                                        gwtWifiConfig.setSecurity(GwtWifiSecurity.netWifiSecurityWPA_WPA2.name());
                                        break;
                                    }
                                    case SECURITY_WEP: {
                                        gwtWifiConfig.setSecurity(GwtWifiSecurity.netWifiSecurityWEP.name());
                                        break;
                                    }
                                    default: {
                                        gwtWifiConfig.setSecurity(GwtWifiSecurity.netWifiSecurityNONE.name());
                                    }
                                }
                                if (wifiConfig.getPairwiseCiphers() == WifiCiphers.CCMP_TKIP) {
                                    gwtWifiConfig.setPairwiseCiphers(GwtWifiCiphers.netWifiCiphers_CCMP_TKIP.name());
                                } else if (wifiConfig.getPairwiseCiphers() == WifiCiphers.TKIP) {
                                    gwtWifiConfig.setPairwiseCiphers(GwtWifiCiphers.netWifiCiphers_TKIP.name());
                                } else if (wifiConfig.getPairwiseCiphers() == WifiCiphers.CCMP) {
                                    gwtWifiConfig.setPairwiseCiphers(GwtWifiCiphers.netWifiCiphers_CCMP.name());
                                }
                                if (wifiConfig.getGroupCiphers() == WifiCiphers.CCMP_TKIP) {
                                    gwtWifiConfig.setGroupCiphers(GwtWifiCiphers.netWifiCiphers_CCMP_TKIP.name());
                                } else if (wifiConfig.getGroupCiphers() == WifiCiphers.TKIP) {
                                    gwtWifiConfig.setGroupCiphers(GwtWifiCiphers.netWifiCiphers_TKIP.name());
                                } else if (wifiConfig.getGroupCiphers() == WifiCiphers.CCMP) {
                                    gwtWifiConfig.setGroupCiphers(GwtWifiCiphers.netWifiCiphers_CCMP.name());
                                }
                                WifiBgscan wifiBgscan = wifiConfig.getBgscan();
                                if (wifiBgscan != null) {
                                    if (wifiBgscan.getModule() == WifiBgscanModule.NONE) {
                                        gwtWifiConfig.setBgscanModule(GwtWifiBgscanModule.netWifiBgscanMode_NONE.name());
                                    } else if (wifiBgscan.getModule() == WifiBgscanModule.SIMPLE) {
                                        gwtWifiConfig.setBgscanModule(GwtWifiBgscanModule.netWifiBgscanMode_SIMPLE.name());
                                    } else if (wifiBgscan.getModule() == WifiBgscanModule.LEARN) {
                                        gwtWifiConfig.setBgscanModule(GwtWifiBgscanModule.netWifiBgscanMode_LEARN.name());
                                    }
                                    gwtWifiConfig.setBgscanRssiThreshold(wifiBgscan.getRssiThreshold());
                                    gwtWifiConfig.setBgscanShortInterval(wifiBgscan.getShortInterval());
                                    gwtWifiConfig.setBgscanLongInterval(wifiBgscan.getLongInterval());
                                }
                                gwtWifiConfig.setPingAccessPoint(wifiConfig.pingAccessPoint());
                                gwtWifiConfig.setIgnoreSSID(wifiConfig.ignoreSSID());
                                Password psswd = wifiConfig.getPasskey();
                                if (psswd != null) {
                                    String password = new String(psswd.getPassword());
                                    gwtWifiConfig.setPassword(password);
                                }
                                if ((channels = wifiConfig.getChannels()) != null) {
                                    ArrayList<Integer> alChannels = new ArrayList<Integer>();
                                    int[] nArray = channels;
                                    int n = channels.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        int channel = nArray[n2];
                                        alChannels.add(channel);
                                        ++n2;
                                    }
                                    gwtWifiConfig.setChannels(alChannels);
                                }
                                Enum gwtWifiRadioMode = null;
                                if (wifiConfig.getRadioMode() != null) {
                                    switch (wifiConfig.getRadioMode()) {
                                        case RADIO_MODE_80211a: {
                                            gwtWifiRadioMode = GwtWifiRadioMode.netWifiRadioModeA;
                                            break;
                                        }
                                        case RADIO_MODE_80211b: {
                                            gwtWifiRadioMode = GwtWifiRadioMode.netWifiRadioModeB;
                                            break;
                                        }
                                        case RADIO_MODE_80211g: {
                                            gwtWifiRadioMode = GwtWifiRadioMode.netWifiRadioModeBG;
                                            break;
                                        }
                                        case RADIO_MODE_80211nHT20: 
                                        case RADIO_MODE_80211nHT40below: 
                                        case RADIO_MODE_80211nHT40above: {
                                            gwtWifiRadioMode = GwtWifiRadioMode.netWifiRadioModeBGN;
                                            break;
                                        }
                                        case RADIO_MODE_80211_AC: {
                                            gwtWifiRadioMode = GwtWifiRadioMode.netWifiRadioModeANAC;
                                            break;
                                        }
                                    }
                                }
                                if (gwtWifiRadioMode != null) {
                                    gwtWifiConfig.setRadioMode(gwtWifiRadioMode.name());
                                }
                                if ((activeWirelessMode = ((WifiInterfaceAddressConfig)addressConfig).getMode()) == WifiMode.MASTER) {
                                    ((GwtWifiNetInterfaceConfig)gwtNetConfig).setWirelessMode(GwtWifiWirelessMode.netWifiWirelessModeAccessPoint.name());
                                    gwtNetConfig.setHwRssi("N/A");
                                } else if (activeWirelessMode == WifiMode.INFRA) {
                                    ((GwtWifiNetInterfaceConfig)gwtNetConfig).setWirelessMode(GwtWifiWirelessMode.netWifiWirelessModeStation.name());
                                    if (wifiClientMonitorService != null && wifiConfig.getMode().equals((Object)WifiMode.INFRA)) {
                                        if (gwtNetConfig.getStatus().equals(GwtNetIfStatus.netIPv4StatusDisabled.name()) || gwtNetConfig.getStatus().equals(GwtNetIfStatus.netIPv4StatusUnmanaged.name())) {
                                            gwtNetConfig.setHwRssi("N/A");
                                        } else {
                                            GwtNetworkServiceImpl.readRssi(wifiClientMonitorService, gwtNetConfig, netIfConfig.getName(), wifiConfig.getSSID(), recompute);
                                        }
                                    }
                                } else if (activeWirelessMode == WifiMode.ADHOC) {
                                    ((GwtWifiNetInterfaceConfig)gwtNetConfig).setWirelessMode(GwtWifiWirelessMode.netWifiWirelessModeAdHoc.name());
                                    gwtNetConfig.setHwRssi("N/A");
                                } else {
                                    ((GwtWifiNetInterfaceConfig)gwtNetConfig).setWirelessMode(GwtWifiWirelessMode.netWifiWirelessModeDisabled.name());
                                    gwtNetConfig.setHwRssi("N/A");
                                }
                            }
                            if (netConfig instanceof ModemConfig) {
                                logger.debug("Setting up ModemConfig");
                                ModemConfig modemConfig = (ModemConfig)netConfig;
                                GwtModemInterfaceConfig gwtModemConfig = (GwtModemInterfaceConfig)gwtNetConfig;
                                if (modemManagerService != null) {
                                    UsbDevice usbDevice = netIfConfig.getUsbDevice();
                                    String modemServiceId = null;
                                    if (usbDevice != null) {
                                        modemServiceId = netIfConfig.getUsbDevice().getUsbPort();
                                    }
                                    if (modemServiceId != null) {
                                        GwtNetInterfaceConfig currentConfig = gwtNetConfig;
                                        modemManagerService.withModemService(modemServiceId, m -> {
                                            if (!m.isPresent()) {
                                                return null;
                                            }
                                            CellularModem cellModemService = (CellularModem)m.get();
                                            try {
                                                String imei = cellModemService.getSerialNumber();
                                                logger.debug("Setting IMEI/MEID to {}", (Object)imei);
                                                gwtModemConfig.setHwSerial(imei);
                                            }
                                            catch (KuraException e) {
                                                logger.warn("Failed to get IMEI from modem", (Throwable)e);
                                            }
                                            try {
                                                int rssi = cellModemService.getSignalStrength(recompute);
                                                logger.debug("Setting Received Signal Strength to {}", (Object)rssi);
                                                gwtModemConfig.setHwRssi(Integer.toString(rssi));
                                            }
                                            catch (KuraException e) {
                                                logger.warn("Failed to get Received Signal Strength from modem", (Throwable)e);
                                            }
                                            try {
                                                String iccid = cellModemService.getIntegratedCirquitCardId(recompute);
                                                logger.debug("Setting ICCID to {}", (Object)iccid);
                                                gwtModemConfig.setHwICCID(iccid);
                                            }
                                            catch (KuraException e) {
                                                logger.warn("Failed to get ICCID from modem", (Throwable)e);
                                            }
                                            try {
                                                String imsi = cellModemService.getMobileSubscriberIdentity(recompute);
                                                logger.debug("Setting IMSI to {}", (Object)imsi);
                                                gwtModemConfig.setHwIMSI(imsi);
                                            }
                                            catch (KuraException e) {
                                                logger.warn("Failed to get IMSI from modem", (Throwable)e);
                                            }
                                            try {
                                                ModemRegistrationStatus registration = cellModemService.getRegistrationStatus(recompute);
                                                logger.debug("Setting Registration Status to {}", (Object)registration.name());
                                                gwtModemConfig.setHwRegistration(registration.name());
                                            }
                                            catch (KuraException e) {
                                                logger.warn("Failed to get Registration from modem", (Throwable)e);
                                            }
                                            try {
                                                String plmnid = cellModemService.getPLMNID();
                                                logger.debug("Setting PLMNID to {}", (Object)plmnid);
                                                gwtModemConfig.setHwPLMNID(plmnid);
                                            }
                                            catch (KuraException e) {
                                                logger.warn("Failed to get PLMNID from modem", (Throwable)e);
                                            }
                                            try {
                                                String network = cellModemService.getNetworkName();
                                                logger.debug("Setting Network to {}", (Object)network);
                                                gwtModemConfig.setHwNetwork(network);
                                            }
                                            catch (KuraException e) {
                                                logger.warn("Failed to get Network from modem", (Throwable)e);
                                            }
                                            try {
                                                String radio = cellModemService.getRadio();
                                                logger.debug("Setting Radio to {}", (Object)radio);
                                                gwtModemConfig.setHwRadio(radio);
                                            }
                                            catch (KuraException e) {
                                                logger.warn("Failed to get Radio from modem", (Throwable)e);
                                            }
                                            try {
                                                String band = cellModemService.getBand();
                                                logger.debug("Setting Band to {}", (Object)band);
                                                gwtModemConfig.setHwBand(band);
                                            }
                                            catch (KuraException e) {
                                                logger.warn("Failed to get Band from modem", (Throwable)e);
                                            }
                                            try {
                                                String lac = cellModemService.getLAC();
                                                logger.debug("Setting Band to {}", (Object)lac);
                                                gwtModemConfig.setHwLAC(lac);
                                            }
                                            catch (KuraException e) {
                                                logger.warn("Failed to get LAC from modem", (Throwable)e);
                                            }
                                            try {
                                                String ci = cellModemService.getCI();
                                                logger.debug("Setting CI to {}", (Object)ci);
                                                gwtModemConfig.setHwCI(ci);
                                            }
                                            catch (KuraException e) {
                                                logger.warn("Failed to get CI from modem", (Throwable)e);
                                            }
                                            try {
                                                String sModel = cellModemService.getModel();
                                                ((GwtModemInterfaceConfig)currentConfig).setModel(sModel);
                                            }
                                            catch (KuraException e) {
                                                logger.warn("Failed to get model information from modem", (Throwable)e);
                                            }
                                            try {
                                                boolean gpsSupported = cellModemService.isGpsSupported();
                                                logger.debug("Setting GPS supported to {}", (Object)gpsSupported);
                                                ((GwtModemInterfaceConfig)currentConfig).setGpsSupported(gpsSupported);
                                            }
                                            catch (KuraException e) {
                                                logger.warn("Failed to get GPS supported from modem", (Throwable)e);
                                            }
                                            try {
                                                String firmwareVersion = cellModemService.getFirmwareVersion();
                                                logger.debug("Setting firwmare version to {}", (Object)firmwareVersion);
                                                ((GwtModemInterfaceConfig)currentConfig).setHwFirmware(firmwareVersion);
                                            }
                                            catch (KuraException e) {
                                                logger.warn("Failed to get firmware version from modem", (Throwable)e);
                                            }
                                            return null;
                                        });
                                    }
                                }
                                gwtModemConfig.setConfigMode(GwtNetIfConfigMode.netIPv4ConfigModeDHCP.name());
                                if (addressConfig.getAddress() != null) {
                                    gwtModemConfig.setIpAddress(addressConfig.getAddress().getHostAddress());
                                }
                                if (addressConfig.getNetmask() != null) {
                                    gwtModemConfig.setSubnetMask(addressConfig.getNetmask().getHostAddress());
                                }
                                gwtModemConfig.setDialString(modemConfig.getDialString());
                                ModemConfig.AuthType authType = modemConfig.getAuthType();
                                if (authType == ModemConfig.AuthType.AUTO) {
                                    gwtModemConfig.setAuthType(GwtModemAuthType.netModemAuthAUTO);
                                } else if (authType == ModemConfig.AuthType.CHAP) {
                                    gwtModemConfig.setAuthType(GwtModemAuthType.netModemAuthCHAP);
                                } else if (authType == ModemConfig.AuthType.PAP) {
                                    gwtModemConfig.setAuthType(GwtModemAuthType.netModemAuthPAP);
                                } else {
                                    gwtModemConfig.setAuthType(GwtModemAuthType.netModemAuthNONE);
                                }
                                gwtModemConfig.setInterfaceName("ppp" + modemConfig.getPppNumber());
                                gwtModemConfig.setUsername(modemConfig.getUsername());
                                gwtModemConfig.setPassword(modemConfig.getPasswordAsPassword().toString());
                                gwtModemConfig.setPppNum(modemConfig.getPppNumber());
                                gwtModemConfig.setResetTimeout(modemConfig.getResetTimeout());
                                gwtModemConfig.setPersist(modemConfig.isPersist());
                                gwtModemConfig.setHoldoff(modemConfig.getHoldoff());
                                gwtModemConfig.setMaxFail(modemConfig.getMaxFail());
                                gwtModemConfig.setIdle(modemConfig.getIdle());
                                gwtModemConfig.setActiveFilter(modemConfig.getActiveFilter());
                                gwtModemConfig.setLcpEchoInterval(modemConfig.getLcpEchoInterval());
                                gwtModemConfig.setLcpEchoFailure(modemConfig.getLcpEchoFailure());
                                gwtModemConfig.setGpsEnabled(modemConfig.isGpsEnabled());
                                gwtModemConfig.setDiversityEnabled(modemConfig.isDiversityEnabled());
                                gwtModemConfig.setProfileID(modemConfig.getProfileID());
                                ModemConfig.PdpType pdpType = modemConfig.getPdpType();
                                if (pdpType == ModemConfig.PdpType.IP) {
                                    gwtModemConfig.setPdpType(GwtModemPdpType.netModemPdpIP);
                                } else if (pdpType == ModemConfig.PdpType.PPP) {
                                    gwtModemConfig.setPdpType(GwtModemPdpType.netModemPdpPPP);
                                } else if (pdpType == ModemConfig.PdpType.IPv6) {
                                    gwtModemConfig.setPdpType(GwtModemPdpType.netModemPdpIPv6);
                                } else {
                                    gwtModemConfig.setPdpType(GwtModemPdpType.netModemPdpUnknown);
                                }
                                gwtModemConfig.setApn(modemConfig.getApn());
                                gwtModemConfig.setDataCompression(modemConfig.getDataCompression());
                                gwtModemConfig.setHeaderCompression(modemConfig.getHeaderCompression());
                                ModemConnectionStatus connectionStatus = ((ModemInterfaceAddressConfig)addressConfig).getConnectionStatus();
                                if (connectionStatus == ModemConnectionStatus.DISCONNECTED) {
                                    gwtModemConfig.setHwState(NetInterfaceState.DISCONNECTED.name());
                                } else if (connectionStatus == ModemConnectionStatus.CONNECTING) {
                                    gwtModemConfig.setHwState(NetInterfaceState.IP_CONFIG.name());
                                } else if (connectionStatus == ModemConnectionStatus.CONNECTED) {
                                    gwtModemConfig.setHwState(NetInterfaceState.ACTIVATED.name());
                                } else {
                                    gwtModemConfig.setHwState(NetInterfaceState.UNKNOWN.name());
                                }
                                gwtModemConfig.setConnectionType(((ModemInterfaceAddressConfig)addressConfig).getConnectionType().name());
                            }
                            if (netConfig instanceof DhcpServerConfigIP4) {
                                logger.debug("Setting up DhcpServerConfigIP4: {} to {}", (Object)((IP4Address)((DhcpServerConfigIP4)netConfig).getRangeStart()).getHostAddress(), (Object)((IP4Address)((DhcpServerConfigIP4)netConfig).getRangeEnd()).getHostAddress());
                                logger.debug("Setting up DhcpServerConfigIP4: {}", (Object)netConfig);
                                isDhcpServerEnabled = ((DhcpServerConfigIP4)netConfig).isEnabled();
                                gwtNetConfig.setRouterDhcpBeginAddress(((IP4Address)((DhcpServerConfigIP4)netConfig).getRangeStart()).getHostAddress());
                                gwtNetConfig.setRouterDhcpEndAddress(((IP4Address)((DhcpServerConfigIP4)netConfig).getRangeEnd()).getHostAddress());
                                gwtNetConfig.setRouterDhcpSubnetMask(((IP4Address)((DhcpServerConfigIP4)netConfig).getSubnetMask()).getHostAddress());
                                gwtNetConfig.setRouterDhcpDefaultLease(((DhcpServerConfigIP4)netConfig).getDefaultLeaseTime());
                                gwtNetConfig.setRouterDhcpMaxLease(((DhcpServerConfigIP4)netConfig).getMaximumLeaseTime());
                                gwtNetConfig.setRouterDnsPass(((DhcpServerConfigIP4)netConfig).isPassDns());
                            }
                            if (!(netConfig instanceof FirewallAutoNatConfig)) continue;
                            logger.debug("Setting up FirewallAutoNatConfig");
                            isNatEnabled = true;
                        }
                        if (isDhcpServerEnabled && isNatEnabled) {
                            logger.debug("setting router mode to DHCP and NAT");
                            gwtNetConfig.setRouterMode(GwtNetRouterMode.netRouterDchpNat.name());
                        } else if (isDhcpServerEnabled && !isNatEnabled) {
                            logger.debug("setting router mode to DHCP only");
                            gwtNetConfig.setRouterMode(GwtNetRouterMode.netRouterDchp.name());
                        } else if (!isDhcpServerEnabled && isNatEnabled) {
                            logger.debug("setting router mode to NAT only");
                            gwtNetConfig.setRouterMode(GwtNetRouterMode.netRouterNat.name());
                        } else {
                            logger.debug("setting router mode to disabled");
                            gwtNetConfig.setRouterMode(GwtNetRouterMode.netRouterOff.name());
                        }
                    }
                }
                gwtNetConfigs.add(gwtNetConfig);
            }
        }
        catch (Throwable t) {
            KuraExceptionHandler.handle(t);
        }
        logger.debug("Returning");
        return gwtNetConfigs;
    }

    private static void readRssi(WifiClientMonitorService wifiClientMonitorService, GwtNetInterfaceConfig gwtNetConfig, String interfaceName, String ssid, boolean recompute) {
        try {
            int rssi = wifiClientMonitorService.getSignalLevel(interfaceName, ssid, recompute);
            logger.debug("Setting Received Signal Strength to {}", (Object)rssi);
            gwtNetConfig.setHwRssi(Integer.toString(rssi));
        }
        catch (KuraException e) {
            logger.warn("Failed", (Throwable)e);
        }
    }

    private static GwtNetInterfaceConfig createGwtNetConfig(NetInterfaceConfig<? extends NetInterfaceAddressConfig> netIfConfig) {
        GwtNetInterfaceConfig gwtNetConfig;
        if (netIfConfig.getType() == NetInterfaceType.WIFI) {
            gwtNetConfig = new GwtWifiNetInterfaceConfig();
        } else if (netIfConfig.getType() == NetInterfaceType.MODEM) {
            gwtNetConfig = new GwtModemInterfaceConfig();
            ((GwtModemInterfaceConfig)gwtNetConfig).setModemId(((ModemInterface)netIfConfig).getModemIdentifier());
            ((GwtModemInterfaceConfig)gwtNetConfig).setManufacturer(((ModemInterface)netIfConfig).getManufacturer());
            ((GwtModemInterfaceConfig)gwtNetConfig).setModel(((ModemInterface)netIfConfig).getModel());
            ArrayList<String> technologyList = new ArrayList<String>();
            List technologyTypes = ((ModemInterface)netIfConfig).getTechnologyTypes();
            if (technologyTypes != null) {
                for (ModemTechnologyType techType : technologyTypes) {
                    technologyList.add(techType.name());
                }
            }
            ((GwtModemInterfaceConfig)gwtNetConfig).setNetworkTechnology(technologyList);
        } else {
            gwtNetConfig = new GwtNetInterfaceConfig();
            gwtNetConfig.setHwRssi("N/A");
        }
        return gwtNetConfig;
    }

    public static void updateNetInterfaceConfigurations(GwtNetInterfaceConfig config) throws GwtKuraException {
        ConfigurationService configurationService = ServiceLocator.getInstance().getService(ConfigurationService.class);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        String basePropName = "net.interface." + config.getName() + ".config.";
        String status = config.getStatus();
        if (logger.isDebugEnabled()) {
            logger.debug("config.getStatus(): {}", (Object)GwtSafeHtmlUtils.htmlEscape(status));
        }
        try {
            NetInterfaceStatus netInterfaceStatus = GwtNetworkServiceImpl.getNetInterfaceStatus(status);
            properties.put(String.valueOf(basePropName) + "ip4.status", netInterfaceStatus.name());
            if (config.getHwTypeEnum() == GwtNetIfType.ETHERNET || config.getHwTypeEnum() == GwtNetIfType.WIFI || config.getHwTypeEnum() == GwtNetIfType.MODEM) {
                GwtNetworkServiceImpl.fillIp4AndDhcpProperties(config, properties, basePropName);
            }
            if (config.getHwTypeEnum() == GwtNetIfType.WIFI && config instanceof GwtWifiNetInterfaceConfig) {
                GwtWifiConfig gwtWifiConfig = ((GwtWifiNetInterfaceConfig)config).getActiveWifiConfig();
                if (gwtWifiConfig != null) {
                    GwtNetworkServiceImpl.fillWifiProperties(gwtWifiConfig, properties, basePropName, config.getName());
                }
            } else if (config.getHwTypeEnum() == GwtNetIfType.MODEM && config instanceof GwtModemInterfaceConfig) {
                GwtModemInterfaceConfig gwtModemConfig = (GwtModemInterfaceConfig)config;
                GwtNetworkServiceImpl.fillModemProperties(gwtModemConfig, properties, basePropName, netInterfaceStatus);
            }
            configurationService.updateConfiguration("org.eclipse.kura.net.admin.NetworkConfigurationService", properties, true);
        }
        catch (UnknownHostException | KuraException e) {
            throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR, e);
        }
    }

    public static ArrayList<GwtFirewallOpenPortEntry> findDeviceFirewallOpenPorts() throws GwtKuraException {
        NetworkAdminService nas = ServiceLocator.getInstance().getService(NetworkAdminService.class);
        ArrayList<GwtFirewallOpenPortEntry> gwtOpenPortEntries = new ArrayList<GwtFirewallOpenPortEntry>();
        try {
            List firewallConfigs = nas.getFirewallConfiguration();
            if (firewallConfigs != null && !firewallConfigs.isEmpty()) {
                for (NetConfig netConfig : firewallConfigs) {
                    if (!(netConfig instanceof FirewallOpenPortConfigIP4)) continue;
                    logger.debug("findDeviceFirewallOpenPorts() :: adding new Open Port Entry: {}", (Object)((FirewallOpenPortConfigIP4)netConfig).getPort());
                    GwtFirewallOpenPortEntry entry = new GwtFirewallOpenPortEntry();
                    if (((FirewallOpenPortConfigIP4)netConfig).getPortRange() != null) {
                        entry.setPortRange(((FirewallOpenPortConfigIP4)netConfig).getPortRange());
                    } else {
                        entry.setPortRange(String.valueOf(((FirewallOpenPortConfigIP4)netConfig).getPort()));
                    }
                    entry.setProtocol(((FirewallOpenPortConfigIP4)netConfig).getProtocol().toString());
                    entry.setPermittedNetwork(String.valueOf(((IP4Address)((FirewallOpenPortConfigIP4)netConfig).getPermittedNetwork().getIpAddress()).getHostAddress()) + "/" + ((FirewallOpenPortConfigIP4)netConfig).getPermittedNetwork().getPrefix());
                    entry.setPermittedInterfaceName(((FirewallOpenPortConfigIP4)netConfig).getPermittedInterfaceName());
                    entry.setUnpermittedInterfaceName(((FirewallOpenPortConfigIP4)netConfig).getUnpermittedInterfaceName());
                    entry.setPermittedMAC(((FirewallOpenPortConfigIP4)netConfig).getPermittedMac());
                    entry.setSourcePortRange(((FirewallOpenPortConfigIP4)netConfig).getSourcePortRange());
                    gwtOpenPortEntries.add(entry);
                }
            }
            return new ArrayList<GwtFirewallOpenPortEntry>(gwtOpenPortEntries);
        }
        catch (KuraException e) {
            throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR, (Throwable)e);
        }
    }

    public static ArrayList<GwtWifiHotspotEntry> findWifiHotspots(String interfaceName, String wirelessSsid) throws GwtKuraException {
        NetworkAdminService nas = ServiceLocator.getInstance().getService(NetworkAdminService.class);
        SystemService systemService = ServiceLocator.getInstance().getService(SystemService.class);
        ArrayList<GwtWifiHotspotEntry> gwtWifiHotspotsEntries = new ArrayList<GwtWifiHotspotEntry>();
        try {
            List wifiHotspotInfoList = nas.getWifiHotspotList(interfaceName);
            if (wifiHotspotInfoList != null) {
                for (WifiHotspotInfo wifiHotspotInfo : wifiHotspotInfoList) {
                    String ssid = wifiHotspotInfo.getSsid();
                    if (wifiHotspotInfo.getChannel() > systemService.getKuraWifiTopChannel() || ssid == null || ssid.equals(wirelessSsid)) continue;
                    GwtWifiHotspotEntry gwtWifiHotspotEntry = new GwtWifiHotspotEntry();
                    gwtWifiHotspotEntry.setMacAddress(wifiHotspotInfo.getMacAddress());
                    gwtWifiHotspotEntry.setSSID(ssid);
                    gwtWifiHotspotEntry.setsignalStrength(wifiHotspotInfo.getSignalLevel());
                    gwtWifiHotspotEntry.setChannel(wifiHotspotInfo.getChannel());
                    gwtWifiHotspotEntry.setFrequency(wifiHotspotInfo.getFrequency());
                    if (wifiHotspotInfo.getSecurity() == WifiSecurity.NONE || wifiHotspotInfo.getSecurity() == WifiSecurity.SECURITY_NONE) {
                        gwtWifiHotspotEntry.setSecurity("None");
                    } else if (wifiHotspotInfo.getSecurity() == WifiSecurity.SECURITY_WEP) {
                        gwtWifiHotspotEntry.setSecurity("WEP");
                    } else if (wifiHotspotInfo.getSecurity() == WifiSecurity.SECURITY_WPA) {
                        gwtWifiHotspotEntry.setSecurity("WPA");
                    } else if (wifiHotspotInfo.getSecurity() == WifiSecurity.SECURITY_WPA2) {
                        gwtWifiHotspotEntry.setSecurity("WPA2");
                    } else if (wifiHotspotInfo.getSecurity() == WifiSecurity.SECURITY_WPA_WPA2) {
                        gwtWifiHotspotEntry.setSecurity("WPA/WPA2");
                    }
                    GwtWifiCiphers gwtPairCiphers = null;
                    Enum gwtGroupCiphers = null;
                    EnumSet pairCiphers = wifiHotspotInfo.getPairCiphers();
                    for (WifiSecurity cipher : pairCiphers) {
                        if (gwtPairCiphers == null) {
                            if (cipher == WifiSecurity.PAIR_TKIP) {
                                gwtPairCiphers = GwtWifiCiphers.netWifiCiphers_TKIP;
                                continue;
                            }
                            if (cipher != WifiSecurity.PAIR_CCMP) continue;
                            gwtPairCiphers = GwtWifiCiphers.netWifiCiphers_CCMP;
                            continue;
                        }
                        if (gwtPairCiphers == GwtWifiCiphers.netWifiCiphers_TKIP) {
                            if (cipher != WifiSecurity.PAIR_CCMP) continue;
                            gwtPairCiphers = GwtWifiCiphers.netWifiCiphers_CCMP_TKIP;
                            continue;
                        }
                        if (gwtPairCiphers != GwtWifiCiphers.netWifiCiphers_CCMP || cipher != WifiSecurity.PAIR_TKIP) continue;
                        gwtPairCiphers = GwtWifiCiphers.netWifiCiphers_CCMP_TKIP;
                    }
                    EnumSet groupCiphers = wifiHotspotInfo.getGroupCiphers();
                    for (WifiSecurity cipher : groupCiphers) {
                        if (gwtGroupCiphers == null) {
                            if (cipher == WifiSecurity.GROUP_TKIP) {
                                gwtGroupCiphers = GwtWifiCiphers.netWifiCiphers_TKIP;
                                continue;
                            }
                            if (cipher != WifiSecurity.GROUP_CCMP) continue;
                            gwtGroupCiphers = GwtWifiCiphers.netWifiCiphers_CCMP;
                            continue;
                        }
                        if (gwtGroupCiphers == GwtWifiCiphers.netWifiCiphers_TKIP) {
                            if (cipher != WifiSecurity.GROUP_CCMP) continue;
                            gwtGroupCiphers = GwtWifiCiphers.netWifiCiphers_CCMP_TKIP;
                            continue;
                        }
                        if (gwtGroupCiphers != GwtWifiCiphers.netWifiCiphers_CCMP || cipher != WifiSecurity.GROUP_TKIP) continue;
                        gwtGroupCiphers = GwtWifiCiphers.netWifiCiphers_CCMP_TKIP;
                    }
                    if (gwtPairCiphers != null) {
                        gwtWifiHotspotEntry.setPairwiseCiphers(gwtPairCiphers.name());
                    }
                    if (gwtGroupCiphers != null) {
                        gwtWifiHotspotEntry.setGroupCiphers(gwtGroupCiphers.name());
                    }
                    gwtWifiHotspotsEntries.add(gwtWifiHotspotEntry);
                }
            }
        }
        catch (Throwable t) {
            KuraExceptionHandler.handle(t);
        }
        return new ArrayList<GwtWifiHotspotEntry>(gwtWifiHotspotsEntries);
    }

    public static List<GwtModemPdpEntry> findPdpContextInfo(String interfaceName) throws GwtKuraException {
        ModemManagerService mms = ServiceLocator.getInstance().getService(ModemManagerService.class);
        try {
            return (List)GwtNetworkServiceImpl.withCellularModem(interfaceName, mms, m -> {
                GwtModemPdpEntry gwtModemPdpEntry;
                ArrayList<GwtModemPdpEntry> gwtModemPdpEntries = new ArrayList<GwtModemPdpEntry>();
                if (!m.isPresent()) {
                    return gwtModemPdpEntries;
                }
                CellularModem modem = (CellularModem)m.get();
                List pdpContextInfo = modem.getPdpContextInfo();
                int contextInd = 1;
                int firstAvailableContextNum = 0;
                for (ModemPdpContext pdpContextEntry : pdpContextInfo) {
                    gwtModemPdpEntry = new GwtModemPdpEntry();
                    gwtModemPdpEntry.setContextNumber(pdpContextEntry.getNumber());
                    gwtModemPdpEntry.setPdpType(pdpContextEntry.getType().getValue());
                    gwtModemPdpEntry.setApn(pdpContextEntry.getApn());
                    gwtModemPdpEntries.add(gwtModemPdpEntry);
                    if (firstAvailableContextNum == 0 && contextInd < pdpContextEntry.getNumber()) {
                        firstAvailableContextNum = contextInd;
                    }
                    ++contextInd;
                }
                if (firstAvailableContextNum == 0) {
                    firstAvailableContextNum = contextInd;
                }
                gwtModemPdpEntry = new GwtModemPdpEntry();
                gwtModemPdpEntry.setContextNumber(firstAvailableContextNum);
                gwtModemPdpEntry.setPdpType(ModemPdpContextType.IP.getValue());
                gwtModemPdpEntry.setApn("Please provide APN for this new PDP context ...");
                gwtModemPdpEntries.add(gwtModemPdpEntry);
                return gwtModemPdpEntries;
            });
        }
        catch (KuraException e) {
            throw new GwtKuraException(GwtKuraErrorCode.WARNING, (Throwable)e);
        }
    }

    public static boolean verifyWifiCredentials(String interfaceName, GwtWifiConfig gwtWifiConfig) throws GwtKuraException {
        if (interfaceName == null || gwtWifiConfig == null) {
            throw new GwtKuraException(GwtKuraErrorCode.ILLEGAL_NULL_ARGUMENT);
        }
        NetworkAdminService nas = ServiceLocator.getInstance().getService(NetworkAdminService.class);
        WifiConfig wifiConfig = GwtNetworkServiceImpl.getWifiConfig(gwtWifiConfig);
        return nas.verifyWifiCredentials(interfaceName, wifiConfig, 60);
    }

    public static ArrayList<GwtFirewallPortForwardEntry> findDeviceFirewallPortForwards() throws GwtKuraException {
        NetworkAdminService nas = ServiceLocator.getInstance().getService(NetworkAdminService.class);
        ArrayList<GwtFirewallPortForwardEntry> gwtPortForwardEntries = new ArrayList<GwtFirewallPortForwardEntry>();
        try {
            List firewallConfigs = nas.getFirewallConfiguration();
            if (firewallConfigs != null && !firewallConfigs.isEmpty()) {
                for (NetConfig netConfig : firewallConfigs) {
                    if (!(netConfig instanceof FirewallPortForwardConfigIP4)) continue;
                    logger.debug("findDeviceFirewallPortForwards() :: adding new Port Forward Entry");
                    GwtFirewallPortForwardEntry entry = new GwtFirewallPortForwardEntry();
                    entry.setInboundInterface(((FirewallPortForwardConfigIP4)netConfig).getInboundInterface());
                    entry.setOutboundInterface(((FirewallPortForwardConfigIP4)netConfig).getOutboundInterface());
                    entry.setAddress(((FirewallPortForwardConfigIP4)netConfig).getAddress().getHostAddress());
                    entry.setProtocol(((FirewallPortForwardConfigIP4)netConfig).getProtocol().toString());
                    entry.setInPort(((FirewallPortForwardConfigIP4)netConfig).getInPort());
                    entry.setOutPort(((FirewallPortForwardConfigIP4)netConfig).getOutPort());
                    String masquerade = ((FirewallPortForwardConfigIP4)netConfig).isMasquerade() ? "yes" : "no";
                    entry.setMasquerade(masquerade);
                    entry.setPermittedNetwork(((FirewallPortForwardConfigIP4)netConfig).getPermittedNetwork().toString());
                    entry.setPermittedMAC(((FirewallPortForwardConfigIP4)netConfig).getPermittedMac());
                    entry.setSourcePortRange(((FirewallPortForwardConfigIP4)netConfig).getSourcePortRange());
                    gwtPortForwardEntries.add(entry);
                }
            }
            return new ArrayList<GwtFirewallPortForwardEntry>(gwtPortForwardEntries);
        }
        catch (KuraException e) {
            throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR, (Throwable)e);
        }
    }

    public static ArrayList<GwtFirewallNatEntry> findDeviceFirewallNATs() throws GwtKuraException {
        NetworkAdminService nas = ServiceLocator.getInstance().getService(NetworkAdminService.class);
        ArrayList<GwtFirewallNatEntry> gwtNatEntries = new ArrayList<GwtFirewallNatEntry>();
        try {
            List firewallConfigs = nas.getFirewallConfiguration();
            if (firewallConfigs != null && !firewallConfigs.isEmpty()) {
                for (NetConfig netConfig : firewallConfigs) {
                    if (!(netConfig instanceof FirewallNatConfig)) continue;
                    logger.debug("findDeviceFirewallNATs() :: adding new NAT Entry");
                    GwtFirewallNatEntry entry = new GwtFirewallNatEntry();
                    entry.setInInterface(((FirewallNatConfig)netConfig).getSourceInterface());
                    entry.setOutInterface(((FirewallNatConfig)netConfig).getDestinationInterface());
                    entry.setProtocol(((FirewallNatConfig)netConfig).getProtocol());
                    entry.setSourceNetwork(((FirewallNatConfig)netConfig).getSource());
                    entry.setDestinationNetwork(((FirewallNatConfig)netConfig).getDestination());
                    String masquerade = ((FirewallNatConfig)netConfig).isMasquerade() ? "yes" : "no";
                    entry.setMasquerade(masquerade);
                    gwtNatEntries.add(entry);
                }
            }
            return new ArrayList<GwtFirewallNatEntry>(gwtNatEntries);
        }
        catch (KuraException e) {
            throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR, (Throwable)e);
        }
    }

    public static void updateDeviceFirewallOpenPorts(List<GwtFirewallOpenPortEntry> entries) throws GwtKuraException {
        ConfigurationService configurationService = ServiceLocator.getInstance().getService(ConfigurationService.class);
        HashMap<String, String> properties = new HashMap<String, String>();
        String openPortsPropName = "firewall.open.ports";
        StringBuilder openPorts = new StringBuilder();
        try {
            for (GwtFirewallOpenPortEntry entry : entries) {
                openPorts.append(entry.getPortRange()).append(",");
                openPorts.append(entry.getProtocol()).append(",");
                if (entry.getPermittedNetwork() == null || entry.getPermittedNetwork().equals(UNKNOWN_NETWORK)) {
                    openPorts.append(UNKNOWN_NETWORK);
                } else {
                    GwtNetworkServiceImpl.appendNetwork(entry.getPermittedNetwork(), openPorts);
                }
                openPorts.append(",");
                if (entry.getPermittedInterfaceName() != null) {
                    openPorts.append(entry.getPermittedInterfaceName());
                }
                openPorts.append(",");
                if (entry.getUnpermittedInterfaceName() != null) {
                    openPorts.append(entry.getUnpermittedInterfaceName());
                }
                openPorts.append(",");
                if (entry.getPermittedMAC() != null) {
                    openPorts.append(entry.getPermittedMAC());
                }
                openPorts.append(",");
                if (entry.getSourcePortRange() != null) {
                    openPorts.append(entry.getSourcePortRange());
                }
                openPorts.append(",").append("#").append(";");
            }
            properties.put(openPortsPropName, openPorts.toString());
            configurationService.updateConfiguration(FIREWALL_CONFIGURATION_SERVICE_PID, properties, true);
        }
        catch (UnknownHostException | KuraException e) {
            throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR, e);
        }
    }

    public static void updateDeviceFirewallPortForwards(List<GwtFirewallPortForwardEntry> entries) throws GwtKuraException {
        ConfigurationService configurationService = ServiceLocator.getInstance().getService(ConfigurationService.class);
        HashMap<String, String> properties = new HashMap<String, String>();
        String portForwardingPropName = "firewall.port.forwarding";
        StringBuilder portForwarding = new StringBuilder();
        try {
            for (GwtFirewallPortForwardEntry entry : entries) {
                portForwarding.append(entry.getInboundInterface()).append(",");
                portForwarding.append(entry.getOutboundInterface()).append(",");
                portForwarding.append(((IP4Address)IPAddress.parseHostAddress((String)entry.getAddress())).getHostAddress()).append(",");
                portForwarding.append(entry.getProtocol()).append(",");
                portForwarding.append(entry.getInPort()).append(",");
                portForwarding.append(entry.getOutPort()).append(",");
                if (entry.getMasquerade().equals("yes")) {
                    portForwarding.append("true");
                } else {
                    portForwarding.append("false");
                }
                portForwarding.append(",");
                if (entry.getPermittedNetwork() == null || entry.getPermittedNetwork().equals(UNKNOWN_NETWORK)) {
                    portForwarding.append(UNKNOWN_NETWORK);
                } else {
                    GwtNetworkServiceImpl.appendNetwork(entry.getPermittedNetwork(), portForwarding);
                }
                portForwarding.append(",");
                if (entry.getPermittedMAC() != null) {
                    portForwarding.append(entry.getPermittedMAC());
                }
                portForwarding.append(",");
                if (entry.getSourcePortRange() != null) {
                    portForwarding.append(entry.getSourcePortRange());
                }
                portForwarding.append(",").append("#").append(";");
            }
            properties.put(portForwardingPropName, portForwarding.toString());
            configurationService.updateConfiguration(FIREWALL_CONFIGURATION_SERVICE_PID, properties, true);
        }
        catch (UnknownHostException | KuraException e) {
            throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR, e);
        }
    }

    public static void updateDeviceFirewallNATs(List<GwtFirewallNatEntry> entries) throws GwtKuraException {
        ConfigurationService configurationService = ServiceLocator.getInstance().getService(ConfigurationService.class);
        HashMap<String, String> properties = new HashMap<String, String>();
        String natPropName = "firewall.nat";
        StringBuilder nat = new StringBuilder();
        try {
            for (GwtFirewallNatEntry entry : entries) {
                nat.append(entry.getInInterface()).append(",");
                nat.append(entry.getOutInterface()).append(",");
                nat.append(entry.getProtocol()).append(",");
                if (UNKNOWN_NETWORK.equals(entry.getSourceNetwork())) {
                    nat.append(UNKNOWN_NETWORK);
                } else {
                    GwtNetworkServiceImpl.appendNetwork(entry.getSourceNetwork(), nat);
                }
                nat.append(",");
                if (UNKNOWN_NETWORK.equals(entry.getDestinationNetwork())) {
                    nat.append(UNKNOWN_NETWORK);
                } else {
                    GwtNetworkServiceImpl.appendNetwork(entry.getDestinationNetwork(), nat);
                }
                nat.append(",");
                if (entry.getMasquerade().equals("yes")) {
                    nat.append("true");
                } else {
                    nat.append("false");
                }
                nat.append(",").append("#").append(";");
            }
            properties.put(natPropName, nat.toString());
            configurationService.updateConfiguration(FIREWALL_CONFIGURATION_SERVICE_PID, properties, true);
        }
        catch (UnknownHostException | KuraException e) {
            throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR, e);
        }
    }

    public static void renewDhcpLease(String interfaceName) throws GwtKuraException {
        NetworkAdminService nas = ServiceLocator.getInstance().getService(NetworkAdminService.class);
        try {
            nas.renewDhcpLease(GwtSafeHtmlUtils.htmlEscape(interfaceName));
        }
        catch (KuraException e) {
            throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR, (Throwable)e);
        }
    }

    public static List<GwtWifiChannelFrequency> findFrequencies(String interfaceName, GwtWifiRadioMode radioMode) throws GwtKuraException {
        logger.debug("Find Frequency Network Service impl");
        ArrayList<GwtWifiChannelFrequency> channels = new ArrayList<GwtWifiChannelFrequency>();
        NetworkAdminService nas = ServiceLocator.getInstance().getService(NetworkAdminService.class);
        try {
            List channelFrequencies = nas.getWifiFrequencies(interfaceName);
            boolean hasSystemDFS = nas.isWifiDFS(interfaceName);
            for (WifiChannel channelFreq : channelFrequencies) {
                boolean channelIsfive5Ghz;
                if (logger.isDebugEnabled()) {
                    logger.debug(channelFreq.toString());
                }
                boolean bl = channelIsfive5Ghz = channelFreq.getFrequency() > 2501;
                if ((!radioMode.isFiveGhz() || !channelIsfive5Ghz) && (!radioMode.isTwoDotFourGhz() || channelIsfive5Ghz) || Boolean.TRUE.equals(channelFreq.isRadarDetection()) && !hasSystemDFS) continue;
                GwtWifiChannelFrequency channelFrequency = new GwtWifiChannelFrequency();
                channelFrequency.setChannel(channelFreq.getChannel());
                channelFrequency.setFrequency(channelFreq.getFrequency());
                channelFrequency.setNoIrradiation(channelFreq.isNoInitiatingRadiation());
                channelFrequency.setRadarDetection(channelFreq.isRadarDetection());
                channelFrequency.setDisabled(channelFreq.isDisabled());
                channels.add(channelFrequency);
                logger.debug("Found {} - {} Mhz", (Object)channelFrequency.getChannel(), (Object)channelFrequency.getFrequency());
            }
            return channels;
        }
        catch (KuraException e) {
            logger.error("Find Frequency exception");
            throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR, (Throwable)e);
        }
    }

    public static String getWifiCountryCode() throws GwtKuraException {
        logger.info("Get Wifi Country Code impl");
        NetworkAdminService nas = ServiceLocator.getInstance().getService(NetworkAdminService.class);
        try {
            return nas.getWifiCountryCode();
        }
        catch (KuraException e) {
            logger.error("Get Wifi Country Code exception");
            throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR, (Throwable)e);
        }
    }

    public static boolean isIEEE80211ACSupported(String ifaceName) throws GwtKuraException {
        NetworkAdminService nas = ServiceLocator.getInstance().getService(NetworkAdminService.class);
        try {
            return nas.isWifiIEEE80211AC(ifaceName);
        }
        catch (KuraException e) {
            logger.error("Ieee80211ac support exception");
            throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR, (Throwable)e);
        }
    }

    public static List<String> getDhcpLeases(String interfaceName) throws GwtKuraException {
        ArrayList<String> dhcpLease = new ArrayList<String>();
        NetworkAdminService nas = ServiceLocator.getInstance().getService(NetworkAdminService.class);
        try {
            List leases = nas.getDhcpLeases(interfaceName);
            for (DhcpLease dl : leases) {
                GwtDhcpLease dhcp = new GwtDhcpLease();
                dhcp.setMacAddress(dl.getMacAddress());
                dhcp.setIpAddress(dl.getIpAddress());
                dhcp.setHostname(dl.getHostname());
                dhcpLease.add(dhcp.toString());
            }
            return dhcpLease;
        }
        catch (KuraException e) {
            logger.error("Find Dhcp Lease List Exception");
            throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR, (Throwable)e);
        }
    }

    private static NetInterfaceStatus getNetInterfaceStatus(String status) {
        NetInterfaceStatus netInterfaceStatus = NetInterfaceStatus.netIPv4StatusDisabled;
        if (status.equals(GwtNetIfStatus.netIPv4StatusUnmanaged.name())) {
            netInterfaceStatus = NetInterfaceStatus.netIPv4StatusUnmanaged;
        } else if (status.equals(GwtNetIfStatus.netIPv4StatusL2Only.name())) {
            netInterfaceStatus = NetInterfaceStatus.netIPv4StatusL2Only;
        } else if (status.equals(GwtNetIfStatus.netIPv4StatusEnabledLAN.name())) {
            netInterfaceStatus = NetInterfaceStatus.netIPv4StatusEnabledLAN;
        } else if (status.equals(GwtNetIfStatus.netIPv4StatusEnabledWAN.name())) {
            netInterfaceStatus = NetInterfaceStatus.netIPv4StatusEnabledWAN;
        }
        return netInterfaceStatus;
    }

    private static void fillIp4AndDhcpProperties(GwtNetInterfaceConfig config, Map<String, Object> properties, String basePropName) throws UnknownHostException, KuraException {
        logger.debug("config.getConfigMode(): {}", (Object)config.getConfigMode());
        String dhcpClient4PropName = String.valueOf(basePropName) + "dhcpClient4.enabled";
        String addressPropName = String.valueOf(basePropName) + "ip4.address";
        String prefixPropName = String.valueOf(basePropName) + "ip4.prefix";
        String gatewayPropName = String.valueOf(basePropName) + "ip4.gateway";
        if (GwtNetIfConfigMode.netIPv4ConfigModeDHCP.name().equals(config.getConfigMode())) {
            logger.debug("mode is DHCP");
            properties.put(dhcpClient4PropName, true);
            properties.put(addressPropName, "");
            properties.put(gatewayPropName, "");
        } else {
            logger.debug("mode is STATIC");
            properties.put(dhcpClient4PropName, false);
            if (config.getIpAddress() != null && !config.getIpAddress().isEmpty()) {
                logger.debug("setting address: {}", (Object)config.getIpAddress());
                properties.put(addressPropName, ((IP4Address)IPAddress.parseHostAddress((String)config.getIpAddress())).getHostAddress());
            } else {
                properties.put(addressPropName, "");
            }
            if (config.getSubnetMask() != null && !config.getSubnetMask().isEmpty()) {
                logger.debug("setting subnet mask: {}", (Object)config.getSubnetMask());
                short prefix = NetworkUtil.getNetmaskShortForm((String)((IP4Address)IPAddress.parseHostAddress((String)config.getSubnetMask())).getHostAddress());
                properties.put(prefixPropName, prefix);
            }
            if (config.getGateway() != null && !config.getGateway().isEmpty()) {
                logger.debug("setting gateway: {}", (Object)config.getGateway());
                properties.put(gatewayPropName, ((IP4Address)IPAddress.parseHostAddress((String)config.getGateway())).getHostAddress());
            } else {
                properties.put(gatewayPropName, "");
            }
        }
        GwtNetworkServiceImpl.fillDnsServers(config, properties, basePropName);
        if (GwtNetIfConfigMode.netIPv4ConfigModeManual.name().equals(config.getConfigMode())) {
            GwtNetworkServiceImpl.fillDhcpAndNatProperties(config, properties, basePropName);
        }
    }

    private static void fillDnsServers(GwtNetInterfaceConfig config, Map<String, Object> properties, String basePropName) throws UnknownHostException {
        String regexp = "[\\s,;\\n\\t]+";
        String dnsServerPropName = String.valueOf(basePropName) + "ip4.dnsServers";
        List<String> dnsServers = Arrays.asList(config.getDnsServers().split(regexp));
        if (GwtNetworkServiceImpl.getNetInterfaceStatus(config.getStatus()) == NetInterfaceStatus.netIPv4StatusEnabledWAN && dnsServers != null && !dnsServers.isEmpty()) {
            StringBuilder dnsServersBuilder = new StringBuilder();
            for (String dns : dnsServers) {
                if (dns.trim().isEmpty()) continue;
                dnsServersBuilder.append(((IP4Address)IPAddress.parseHostAddress((String)dns)).getHostAddress()).append(",");
            }
            if (dnsServersBuilder.length() > 0) {
                properties.put(dnsServerPropName, dnsServersBuilder.toString().substring(0, dnsServersBuilder.toString().length() - 1));
            } else {
                properties.put(dnsServerPropName, "");
            }
        } else {
            properties.put(dnsServerPropName, "");
        }
    }

    private static void fillModemProperties(GwtModemInterfaceConfig gwtModemConfig, Map<String, Object> properties, String basePropName, NetInterfaceStatus netInterfaceStatus) throws GwtKuraException {
        Boolean enabled = netInterfaceStatus.equals((Object)NetInterfaceStatus.netIPv4StatusEnabledWAN);
        properties.put(String.valueOf(basePropName) + ENABLED, enabled);
        properties.put(String.valueOf(basePropName) + "apn", gwtModemConfig.getApn());
        properties.put(String.valueOf(basePropName) + "dialString", gwtModemConfig.getDialString());
        GwtNetworkServiceImpl.fillModemPassword(gwtModemConfig, properties, basePropName);
        properties.put(String.valueOf(basePropName) + "username", gwtModemConfig.getUsername());
        properties.put(String.valueOf(basePropName) + "resetTimeout", gwtModemConfig.getResetTimeout());
        properties.put(String.valueOf(basePropName) + "persist", gwtModemConfig.isPersist());
        properties.put(String.valueOf(basePropName) + "holdoff", gwtModemConfig.getHoldoff());
        properties.put(String.valueOf(basePropName) + "maxFail", gwtModemConfig.getMaxFail());
        properties.put(String.valueOf(basePropName) + "idle", gwtModemConfig.getIdle());
        properties.put(String.valueOf(basePropName) + "activeFilter", gwtModemConfig.getActiveFilter());
        properties.put(String.valueOf(basePropName) + "lcpEchoInterval", gwtModemConfig.getLcpEchoInterval());
        properties.put(String.valueOf(basePropName) + "lcpEchoFailure", gwtModemConfig.getLcpEchoFailure());
        properties.put(String.valueOf(basePropName) + "gpsEnabled", gwtModemConfig.isGpsEnabled());
        properties.put(String.valueOf(basePropName) + "diversityEnabled", gwtModemConfig.isDiversityEnabled());
        GwtNetworkServiceImpl.fillModemAuthType(gwtModemConfig, properties, basePropName);
        GwtNetworkServiceImpl.fillModemPdpType(gwtModemConfig, properties, basePropName);
    }

    private static void fillModemPdpType(GwtModemInterfaceConfig gwtModemConfig, Map<String, Object> properties, String basePropName) {
        GwtModemPdpType pdpType = gwtModemConfig.getPdpType();
        if (pdpType != null) {
            String pdpTypePropName = String.valueOf(basePropName) + "pdpType";
            if (pdpType.equals((Object)GwtModemPdpType.netModemPdpIP)) {
                properties.put(pdpTypePropName, ModemConfig.PdpType.IP.name());
            } else if (pdpType.equals((Object)GwtModemPdpType.netModemPdpIPv6)) {
                properties.put(pdpTypePropName, ModemConfig.PdpType.IPv6.name());
            } else if (pdpType.equals((Object)GwtModemPdpType.netModemPdpPPP)) {
                properties.put(pdpTypePropName, ModemConfig.PdpType.PPP.name());
            } else {
                properties.put(pdpTypePropName, ModemConfig.PdpType.UNKNOWN.name());
            }
        }
    }

    private static void fillModemAuthType(GwtModemInterfaceConfig gwtModemConfig, Map<String, Object> properties, String basePropName) {
        GwtModemAuthType authType = gwtModemConfig.getAuthType();
        if (authType != null) {
            String authTypePropName = String.valueOf(basePropName) + "authType";
            if (authType.equals((Object)GwtModemAuthType.netModemAuthNONE)) {
                properties.put(authTypePropName, ModemConfig.AuthType.NONE.name());
            } else if (authType.equals((Object)GwtModemAuthType.netModemAuthAUTO)) {
                properties.put(authTypePropName, ModemConfig.AuthType.AUTO.name());
            } else if (authType.equals((Object)GwtModemAuthType.netModemAuthCHAP)) {
                properties.put(authTypePropName, ModemConfig.AuthType.CHAP.name());
            } else if (authType.equals((Object)GwtModemAuthType.netModemAuthPAP)) {
                properties.put(authTypePropName, ModemConfig.AuthType.PAP.name());
            }
        }
    }

    private static void fillModemPassword(GwtModemInterfaceConfig gwtModemConfig, Map<String, Object> properties, String basePropName) throws GwtKuraException {
        String passKey = GwtSafeHtmlUtils.htmlUnescape(gwtModemConfig.getPassword());
        if (passKey != null && passKey.equals("Placeholder")) {
            List<GwtNetInterfaceConfig> result = GwtNetworkServiceImpl.privateFindNetInterfaceConfigurations(false);
            for (GwtNetInterfaceConfig netConfig : result) {
                if (!(netConfig instanceof GwtModemInterfaceConfig)) continue;
                GwtModemInterfaceConfig oldModemConfig = (GwtModemInterfaceConfig)netConfig;
                if (!gwtModemConfig.getName().equals(oldModemConfig.getName())) continue;
                properties.put(String.valueOf(basePropName) + "password", new Password(GwtSafeHtmlUtils.htmlUnescape(oldModemConfig.getPassword())));
            }
        } else if (passKey != null) {
            properties.put(String.valueOf(basePropName) + "password", new Password(passKey));
        }
    }

    private static void fillDhcpAndNatProperties(GwtNetInterfaceConfig config, Map<String, Object> properties, String basePropName) throws KuraException, UnknownHostException {
        String routerMode = config.getRouterMode();
        String natEnabledPropName = String.valueOf(basePropName) + "nat.enabled";
        StringBuilder dhcpServer4PropName = new StringBuilder(basePropName).append("dhcpServer4.");
        if (routerMode.equals(GwtNetRouterMode.netRouterOff.name())) {
            logger.debug("DCHP and NAT are disabled");
            properties.put(String.valueOf(dhcpServer4PropName.toString()) + ENABLED, false);
            properties.put(natEnabledPropName, false);
        } else if (routerMode.equals(GwtNetRouterMode.netRouterDchp.name())) {
            logger.debug("DCHP is enabled");
            GwtNetworkServiceImpl.fillDhcpServerProperties(config, properties, basePropName);
            properties.put(natEnabledPropName, false);
        } else if (routerMode.equals(GwtNetRouterMode.netRouterDchpNat.name())) {
            logger.debug("DCHP and NAT is enabled");
            GwtNetworkServiceImpl.fillDhcpServerProperties(config, properties, basePropName);
            properties.put(natEnabledPropName, true);
        } else if (routerMode.equals(GwtNetRouterMode.netRouterNat.name())) {
            logger.debug("NAT is enabled");
            properties.put(String.valueOf(dhcpServer4PropName.toString()) + ENABLED, false);
            properties.put(natEnabledPropName, true);
        } else {
            logger.error("Unsupported routerMode: {}", (Object)routerMode);
            throw new KuraException(KuraErrorCode.CONFIGURATION_ERROR, new Object[]{"Unsupported routerMode: " + routerMode});
        }
    }

    private static void fillDhcpServerProperties(GwtNetInterfaceConfig config, Map<String, Object> properties, String basePropName) throws UnknownHostException {
        StringBuilder dhcpServer4PropName = new StringBuilder(basePropName).append("dhcpServer4.");
        properties.put(String.valueOf(dhcpServer4PropName.toString()) + ENABLED, true);
        properties.put(String.valueOf(dhcpServer4PropName.toString()) + "defaultLeaseTime", config.getRouterDhcpDefaultLease());
        properties.put(String.valueOf(dhcpServer4PropName.toString()) + "maxLeaseTime", config.getRouterDhcpMaxLease());
        properties.put(String.valueOf(dhcpServer4PropName.toString()) + "rangeStart", ((IP4Address)IPAddress.parseHostAddress((String)config.getRouterDhcpBeginAddress())).getHostAddress());
        properties.put(String.valueOf(dhcpServer4PropName.toString()) + "rangeEnd", ((IP4Address)IPAddress.parseHostAddress((String)config.getRouterDhcpEndAddress())).getHostAddress());
        properties.put(String.valueOf(dhcpServer4PropName.toString()) + "passDns", config.getRouterDnsPass());
        IP4Address subnetMask = (IP4Address)IPAddress.parseHostAddress((String)config.getRouterDhcpSubnetMask());
        short prefix = NetworkUtil.getNetmaskShortForm((String)subnetMask.getHostAddress());
        properties.put(String.valueOf(dhcpServer4PropName.toString()) + "prefix", prefix);
        ArrayList<IP4Address> dnsServers = new ArrayList<IP4Address>();
        dnsServers.add((IP4Address)IPAddress.parseHostAddress((String)config.getIpAddress()));
        StringBuilder dnsServersBuilder = new StringBuilder();
        dnsServers.forEach(dns -> {
            StringBuilder stringBuilder2 = dnsServersBuilder.append(dns.getHostAddress()).append(",");
        });
        properties.put(String.valueOf(dhcpServer4PropName.toString()) + "ip4.dnsServers", dnsServersBuilder.toString().substring(0, dnsServersBuilder.toString().length() - 1));
    }

    private static WifiConfig getWifiConfig(GwtWifiConfig gwtWifiConfig) throws GwtKuraException {
        WifiCiphers wifiGroupCiphers;
        WifiConfig wifiConfig = new WifiConfig();
        WifiMode wifiMode = GwtNetworkServiceImpl.getWifiConfigWirelessMode(gwtWifiConfig.getWirelessMode());
        wifiConfig.setMode(wifiMode);
        wifiConfig.setSSID(GwtSafeHtmlUtils.htmlUnescape(gwtWifiConfig.getWirelessSsid()));
        wifiConfig.setDriver(gwtWifiConfig.getDriver());
        WifiRadioMode wifiRadioMode = GwtNetworkServiceImpl.getWifiConfigRadioMode(gwtWifiConfig.getRadioModeEnum());
        wifiConfig.setRadioMode(wifiRadioMode);
        String hardwareMode = gwtWifiConfig.getRadioModeEnum().getRadioMode();
        wifiConfig.setHardwareMode(hardwareMode);
        int[] wifiConfigChannels = GwtNetworkServiceImpl.getWifiConfigChannels(gwtWifiConfig.getChannels());
        if (wifiConfigChannels.length > 0) {
            wifiConfig.setChannels(wifiConfigChannels);
        }
        WifiSecurity wifiSecurity = GwtNetworkServiceImpl.getWifiConfigSecurity(gwtWifiConfig.getSecurity());
        wifiConfig.setSecurity(wifiSecurity);
        WifiCiphers wifiPairwiseCiphers = GwtNetworkServiceImpl.getWifiConfigCiphers(gwtWifiConfig.getPairwiseCiphers());
        if (wifiPairwiseCiphers != null) {
            wifiConfig.setPairwiseCiphers(wifiPairwiseCiphers);
        }
        if ((wifiGroupCiphers = GwtNetworkServiceImpl.getWifiConfigCiphers(gwtWifiConfig.getGroupCiphers())) != null) {
            wifiConfig.setGroupCiphers(wifiGroupCiphers);
        }
        WifiBgscan wifiBgscan = GwtNetworkServiceImpl.getWifiConfigBgscan(gwtWifiConfig, gwtWifiConfig.getBgscanModule());
        wifiConfig.setBgscan(wifiBgscan);
        wifiConfig.setPasskey(GwtSafeHtmlUtils.htmlUnescape(gwtWifiConfig.getPassword()));
        wifiConfig.setPingAccessPoint(gwtWifiConfig.pingAccessPoint());
        wifiConfig.setIgnoreSSID(gwtWifiConfig.ignoreSSID());
        wifiConfig.setBroadcast(!gwtWifiConfig.ignoreSSID());
        wifiConfig.setWifiCountryCode(gwtWifiConfig.getCountryCode());
        return wifiConfig;
    }

    private static void fillWifiProperties(GwtWifiConfig gwtWifiConfig, Map<String, Object> properties, String basePropName, String interfaceName) throws KuraException, GwtKuraException {
        WifiBgscan wifiBgscan;
        WifiCiphers wifiGroupCiphers;
        String wifiMode;
        StringBuilder wifiBasePropName = new StringBuilder(basePropName).append("wifi.");
        String mode = gwtWifiConfig.getWirelessMode();
        StringBuilder wifiModeBasePropName = new StringBuilder(wifiBasePropName);
        if (mode != null && mode.equals(GwtWifiWirelessMode.netWifiWirelessModeAccessPoint.name())) {
            wifiMode = WifiMode.MASTER.name();
            wifiModeBasePropName.append("master.");
        } else if (mode != null && mode.equals(GwtWifiWirelessMode.netWifiWirelessModeStation.name())) {
            wifiMode = WifiMode.INFRA.name();
            wifiModeBasePropName.append("infra.");
        } else {
            if (mode != null && mode.equals(GwtWifiWirelessMode.netWifiWirelessModeAdHoc.name())) {
                properties.put(String.valueOf(wifiBasePropName.toString()) + "mode", WifiMode.ADHOC.name());
                return;
            }
            properties.put(String.valueOf(wifiBasePropName.toString()) + "mode", WifiMode.UNKNOWN.name());
            return;
        }
        properties.put(String.valueOf(wifiBasePropName.toString()) + "mode", wifiMode);
        properties.put(String.valueOf(wifiModeBasePropName.toString()) + "ssid", GwtSafeHtmlUtils.htmlUnescape(gwtWifiConfig.getWirelessSsid()));
        properties.put(String.valueOf(wifiModeBasePropName.toString()) + "driver", gwtWifiConfig.getDriver());
        properties.put(String.valueOf(wifiModeBasePropName.toString()) + "radioMode", GwtNetworkServiceImpl.getWifiConfigRadioMode(gwtWifiConfig.getRadioModeEnum()).name());
        GwtNetworkServiceImpl.fillWifiChannelsProperties(gwtWifiConfig, properties, wifiModeBasePropName.toString());
        WifiSecurity wifiSecurity = GwtNetworkServiceImpl.getWifiConfigSecurity(gwtWifiConfig.getSecurity());
        properties.put(String.valueOf(wifiModeBasePropName.toString()) + "securityType", wifiSecurity.name());
        WifiCiphers wifiPairwiseCiphers = GwtNetworkServiceImpl.getWifiConfigCiphers(gwtWifiConfig.getPairwiseCiphers());
        if (wifiPairwiseCiphers != null) {
            properties.put(String.valueOf(wifiModeBasePropName.toString()) + "pairwiseCiphers", wifiPairwiseCiphers.name());
        }
        if ((wifiGroupCiphers = GwtNetworkServiceImpl.getWifiConfigCiphers(gwtWifiConfig.getGroupCiphers())) != null) {
            properties.put(String.valueOf(wifiModeBasePropName.toString()) + "groupCiphers", wifiGroupCiphers.name());
        }
        if ((wifiBgscan = GwtNetworkServiceImpl.getWifiConfigBgscan(gwtWifiConfig, gwtWifiConfig.getBgscanModule())).getModule().equals((Object)WifiBgscanModule.NONE)) {
            properties.put(String.valueOf(wifiModeBasePropName.toString()) + "bgscan", null);
        } else {
            String wifiBgscanString = String.valueOf(wifiBgscan.getModule().name().toLowerCase()) + ":" + wifiBgscan.getShortInterval() + ":" + wifiBgscan.getRssiThreshold() + ":" + wifiBgscan.getLongInterval();
            properties.put(String.valueOf(wifiModeBasePropName.toString()) + "bgscan", wifiBgscanString);
        }
        GwtNetworkServiceImpl.fillWifiPassphrase(gwtWifiConfig, properties, wifiModeBasePropName.toString(), interfaceName, mode);
        properties.put(String.valueOf(wifiModeBasePropName.toString()) + "pingAccessPoint", gwtWifiConfig.pingAccessPoint());
        properties.put(String.valueOf(wifiModeBasePropName.toString()) + "ignoreSSID", gwtWifiConfig.ignoreSSID());
    }

    private static void fillWifiChannelsProperties(GwtWifiConfig gwtWifiConfig, Map<String, Object> properties, String wifiModeBasePropName) {
        int[] wifiConfigChannels = GwtNetworkServiceImpl.getWifiConfigChannels(gwtWifiConfig.getChannels());
        if (wifiConfigChannels.length > 0) {
            StringBuilder wifiConfigChannelsStringBuilder = new StringBuilder();
            int i = 0;
            while (i < wifiConfigChannels.length) {
                wifiConfigChannelsStringBuilder.append(String.valueOf(wifiConfigChannels[i]));
                if (i != wifiConfigChannels.length - 1) {
                    wifiConfigChannelsStringBuilder.append(" ");
                }
                ++i;
            }
            properties.put(String.valueOf(wifiModeBasePropName) + "channel", wifiConfigChannelsStringBuilder.toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void fillWifiPassphrase(GwtWifiConfig gwtWifiConfig, Map<String, Object> properties, String wifiModeBasePropName, String interfaceName, String mode) throws GwtKuraException {
        GwtWifiSecurity security = gwtWifiConfig.getSecurityEnum();
        String passKey = GwtSafeHtmlUtils.htmlUnescape(gwtWifiConfig.getPassword());
        String wifiPassphrasePropName = String.valueOf(wifiModeBasePropName) + "passphrase";
        if (security == GwtWifiSecurity.netWifiSecurityNONE) {
            properties.put(wifiPassphrasePropName, null);
            return;
        }
        String wirelessSSID = gwtWifiConfig.getWirelessSsid();
        if (GwtNetworkServiceImpl.isPlaceholder(passKey, security)) {
            Optional<GwtWifiConfig> oldGwtWifiConfig;
            Optional<GwtWifiConfig> optional = oldGwtWifiConfig = wirelessSSID == null ? GwtNetworkServiceImpl.getOldGwtWifiConfig(interfaceName, mode) : GwtNetworkServiceImpl.getOldGwtWifiConfigBySSID(wirelessSSID, interfaceName, mode);
            if (!oldGwtWifiConfig.isPresent()) throw new GwtKuraException(GwtKuraErrorCode.ILLEGAL_ARGUMENT);
            properties.put(wifiPassphrasePropName, new Password(GwtSafeHtmlUtils.htmlUnescape(oldGwtWifiConfig.get().getPassword())));
            return;
        } else if (passKey != null && mode.equals(GwtWifiWirelessMode.netWifiWirelessModeAccessPoint.name())) {
            GwtServerUtil.validateUserPassword(passKey);
            properties.put(wifiPassphrasePropName, new Password(passKey));
            return;
        } else {
            if (passKey == null) return;
            properties.put(wifiPassphrasePropName, new Password(passKey));
        }
    }

    private static boolean isPlaceholder(String passKey, GwtWifiSecurity security) {
        return passKey != null && (passKey.equals("Placeholder") || security != GwtWifiSecurity.netWifiSecurityNONE && passKey.isEmpty());
    }

    private static Optional<GwtWifiConfig> getOldGwtWifiConfigBySSID(String wirelessSSID, String interfaceName, String mode) throws GwtKuraException {
        Optional<GwtWifiConfig> config = Optional.empty();
        List<GwtNetInterfaceConfig> result = GwtNetworkServiceImpl.privateFindNetInterfaceConfigurations(false);
        for (GwtNetInterfaceConfig netConfig : result) {
            if (!(netConfig instanceof GwtWifiNetInterfaceConfig) || !interfaceName.equals(((GwtWifiNetInterfaceConfig)netConfig).getName())) continue;
            GwtWifiNetInterfaceConfig oldWifiConfig = (GwtWifiNetInterfaceConfig)netConfig;
            GwtWifiConfig oldGwtWifiConfig = mode.equals(GwtWifiWirelessMode.netWifiWirelessModeAccessPoint.name()) ? oldWifiConfig.getAccessPointWifiConfig() : oldWifiConfig.getStationWifiConfig();
            if (oldGwtWifiConfig == null || !oldGwtWifiConfig.getWirelessSsid().equals(wirelessSSID)) continue;
            config = Optional.of(oldGwtWifiConfig);
            break;
        }
        return config;
    }

    private static Optional<GwtWifiConfig> getOldGwtWifiConfig(String interfaceName, String mode) throws GwtKuraException {
        Optional<GwtWifiConfig> config = Optional.empty();
        List<GwtNetInterfaceConfig> result = GwtNetworkServiceImpl.privateFindNetInterfaceConfigurations(false);
        for (GwtNetInterfaceConfig netConfig : result) {
            if (!(netConfig instanceof GwtWifiNetInterfaceConfig) || !interfaceName.equals(((GwtWifiNetInterfaceConfig)netConfig).getName())) continue;
            GwtWifiNetInterfaceConfig oldWifiConfig = (GwtWifiNetInterfaceConfig)netConfig;
            GwtWifiConfig oldGwtWifiConfig = mode.equals(GwtWifiWirelessMode.netWifiWirelessModeAccessPoint.name()) ? oldWifiConfig.getAccessPointWifiConfig() : oldWifiConfig.getStationWifiConfig();
            if (oldGwtWifiConfig == null) continue;
            config = Optional.of(oldGwtWifiConfig);
            break;
        }
        return config;
    }

    private static WifiBgscan getWifiConfigBgscan(GwtWifiConfig gwtWifiConfig, String bgscanModule) {
        WifiBgscanModule wifiBgscanModule = null;
        wifiBgscanModule = GwtWifiBgscanModule.netWifiBgscanMode_SIMPLE.name().equals(bgscanModule) ? WifiBgscanModule.SIMPLE : (GwtWifiBgscanModule.netWifiBgscanMode_LEARN.name().equals(bgscanModule) ? WifiBgscanModule.LEARN : WifiBgscanModule.NONE);
        int bgscanRssiThreshold = gwtWifiConfig.getBgscanRssiThreshold();
        int bgscanShortInterval = gwtWifiConfig.getBgscanShortInterval();
        int bgscanLongInterval = gwtWifiConfig.getBgscanLongInterval();
        return new WifiBgscan(wifiBgscanModule, bgscanShortInterval, bgscanRssiThreshold, bgscanLongInterval);
    }

    private static WifiCiphers getWifiConfigCiphers(String ciphers) {
        WifiCiphers wifiCiphers = null;
        wifiCiphers = GwtWifiCiphers.netWifiCiphers_CCMP_TKIP.name().equals(ciphers) ? WifiCiphers.CCMP_TKIP : (GwtWifiCiphers.netWifiCiphers_TKIP.name().equals(ciphers) ? WifiCiphers.TKIP : WifiCiphers.CCMP);
        return wifiCiphers;
    }

    private static WifiSecurity getWifiConfigSecurity(String security) {
        WifiSecurity wifiSecurity = GwtWifiSecurity.netWifiSecurityWPA.name().equals(security) ? WifiSecurity.SECURITY_WPA : (GwtWifiSecurity.netWifiSecurityWPA2.name().equals(security) ? WifiSecurity.SECURITY_WPA2 : (GwtWifiSecurity.netWifiSecurityWPA_WPA2.name().equals(security) ? WifiSecurity.SECURITY_WPA_WPA2 : (GwtWifiSecurity.netWifiSecurityWEP.name().equals(security) ? WifiSecurity.SECURITY_WEP : WifiSecurity.SECURITY_NONE)));
        return wifiSecurity;
    }

    private static int[] getWifiConfigChannels(List<Integer> alChannels) {
        if (alChannels == null) {
            return new int[0];
        }
        int[] channels = new int[alChannels.size()];
        int i = 0;
        while (i < channels.length) {
            channels[i] = alChannels.get(i);
            ++i;
        }
        return channels;
    }

    private static WifiRadioMode getWifiConfigRadioMode(GwtWifiRadioMode radioMode) throws GwtKuraException {
        WifiRadioMode wifiRadioMode;
        switch (radioMode) {
            case netWifiRadioModeA: {
                wifiRadioMode = WifiRadioMode.RADIO_MODE_80211a;
                break;
            }
            case netWifiRadioModeB: {
                wifiRadioMode = WifiRadioMode.RADIO_MODE_80211b;
                break;
            }
            case netWifiRadioModeBG: {
                wifiRadioMode = WifiRadioMode.RADIO_MODE_80211g;
                break;
            }
            case netWifiRadioModeBGN: {
                wifiRadioMode = WifiRadioMode.RADIO_MODE_80211nHT20;
                break;
            }
            case netWifiRadioModeANAC: {
                wifiRadioMode = WifiRadioMode.RADIO_MODE_80211_AC;
                break;
            }
            default: {
                throw new GwtKuraException(GwtKuraErrorCode.ILLEGAL_ARGUMENT);
            }
        }
        return wifiRadioMode;
    }

    private static WifiMode getWifiConfigWirelessMode(String mode) {
        WifiMode wifiMode = mode != null && mode.equals(GwtWifiWirelessMode.netWifiWirelessModeAccessPoint.name()) ? WifiMode.MASTER : (mode != null && mode.equals(GwtWifiWirelessMode.netWifiWirelessModeStation.name()) ? WifiMode.INFRA : (mode != null && mode.equals(GwtWifiWirelessMode.netWifiWirelessModeAdHoc.name()) ? WifiMode.ADHOC : WifiMode.UNKNOWN));
        return wifiMode;
    }

    private static <T> T withCellularModem(String interfaceName, ModemManagerService modemManagerService, ModemManagerService.ModemFunction<Optional<CellularModem>, T> function) throws KuraException {
        Optional result = (Optional)modemManagerService.withModemService(interfaceName, m -> {
            if (m.isPresent()) {
                return Optional.of(function.apply(m));
            }
            return Optional.empty();
        });
        if (result.isPresent()) {
            return result.get();
        }
        return (T)modemManagerService.withAllModemServices(m -> {
            for (CellularModem modem : m) {
                if (!GwtNetworkServiceImpl.isModemForNetworkInterface(interfaceName, modem)) continue;
                return function.apply(Optional.of(modem));
            }
            return function.apply(Optional.empty());
        });
    }

    private static boolean isModemForNetworkInterface(String ifaceName, CellularModem modemService) {
        List netConfigs = modemService.getConfiguration();
        for (NetConfig netConfig : netConfigs) {
            ModemConfig modemConfig;
            String interfaceName;
            if (!(netConfig instanceof ModemConfig) || !(interfaceName = "ppp" + (modemConfig = (ModemConfig)netConfig).getPppNumber()).equals(ifaceName)) continue;
            return true;
        }
        return false;
    }

    private static void appendNetwork(String address, StringBuilder stringBuilder) throws UnknownHostException {
        String[] networkAddress = address.split("/");
        if (networkAddress.length >= 2) {
            stringBuilder.append(((IP4Address)IPAddress.parseHostAddress((String)networkAddress[0])).getHostAddress()).append("/").append(networkAddress[1]);
        }
    }
}

