/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server.servlet;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.kura.executor.Command;
import org.eclipse.kura.executor.CommandStatus;
import org.eclipse.kura.executor.PrivilegedExecutorService;
import org.eclipse.kura.system.SystemService;
import org.eclipse.kura.web.server.KuraRemoteServiceServlet;
import org.eclipse.kura.web.server.RequiredPermissions;
import org.eclipse.kura.web.server.servlet.AuditServlet;
import org.eclipse.kura.web.server.util.ServiceLocator;
import org.eclipse.kura.web.shared.GwtKuraException;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogServlet
extends AuditServlet {
    private static final long serialVersionUID = 3969980124054250070L;
    private static Logger logger = LoggerFactory.getLogger(LogServlet.class);
    private static final String KURA_JOURNAL_LOG_FILE = "/tmp/kura_journal.log";
    private static final String SYSTEM_JOURNAL_LOG_FILE = "/tmp/system_journal.log";
    private static final String JOURNALCTL_CMD = "journalctl";

    public LogServlet() {
        super("UI Log Download", "Download device logs");
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        KuraRemoteServiceServlet.requirePermissions(httpServletRequest, RequiredPermissions.Mode.ALL, new String[]{"kura.device"});
        try {
            GwtXSRFToken token = new GwtXSRFToken(httpServletRequest.getParameter("xsrfToken"));
            KuraRemoteServiceServlet.checkXSRFToken(httpServletRequest, token);
        }
        catch (Exception e) {
            throw new ServletException("Security error: please retry this operation correctly.", (Throwable)e);
        }
        SystemService ss = null;
        ServiceLocator locator = ServiceLocator.getInstance();
        try {
            ss = locator.getService(SystemService.class);
        }
        catch (GwtKuraException gwtKuraException) {
            logger.warn("Unable to get service");
            return;
        }
        PrivilegedExecutorService pes = null;
        try {
            pes = locator.getService(PrivilegedExecutorService.class);
        }
        catch (GwtKuraException gwtKuraException) {
            logger.warn("Unable to get service");
            return;
        }
        ArrayList<String> paths = new ArrayList<String>();
        String logSourcesVal = ss.getProperties().getProperty("kura.log.download.sources", "/var/log");
        if (logSourcesVal != null && !logSourcesVal.trim().isEmpty()) {
            String[] logSources = logSourcesVal.split(",");
            paths.addAll(Arrays.asList(logSources));
        }
        ArrayList<File> fileList = new ArrayList<File>();
        paths.stream().forEach(path -> {
            try {
                Throwable throwable = null;
                Object var3_4 = null;
                try (Stream<Path> kuraLogDirStream = Files.list(Paths.get(path, new String[0]));){
                    fileList.addAll(kuraLogDirStream.filter(filePath -> filePath.toFile().isFile()).map(Path::toFile).collect(Collectors.toList()));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                logger.warn("Unable to fetch log files for {}", path);
            }
        });
        String outputFields = ss.getProperties().getProperty("kura.log.download.journal.fields", "SYSLOG_IDENTIFIER,PRIORITY,MESSAGE,STACKTRACE");
        if (this.writeJournalLog(pes, outputFields, KURA_JOURNAL_LOG_FILE, "kura")) {
            fileList.add(new File(KURA_JOURNAL_LOG_FILE));
        } else {
            logger.warn("Error producing: {}", (Object)KURA_JOURNAL_LOG_FILE);
        }
        if (this.writeJournalLog(pes, outputFields, SYSTEM_JOURNAL_LOG_FILE)) {
            fileList.add(new File(SYSTEM_JOURNAL_LOG_FILE));
        } else {
            logger.warn("Error producing: {}", (Object)SYSTEM_JOURNAL_LOG_FILE);
        }
        String nonce = httpServletRequest.getParameter("nonce");
        this.createReply(httpServletResponse, fileList, nonce);
        this.removeTmpFiles();
    }

    private void createReply(HttpServletResponse httpServletResponse, List<File> fileList, String nonce) {
        try {
            byte[] zip = this.zipFiles(fileList);
            ServletOutputStream sos = httpServletResponse.getOutputStream();
            Cookie downloadedCookie = new Cookie("LogsDownload-" + nonce, "finished");
            downloadedCookie.setPath("/");
            httpServletResponse.addCookie(downloadedCookie);
            httpServletResponse.setContentType("application/zip");
            httpServletResponse.setHeader("Content-Disposition", "attachment; filename=\"Kura_Logs.zip\"");
            sos.write(zip);
            sos.flush();
        }
        catch (IOException iOException) {
            logger.warn("Unable to create zip file containing log resources");
        }
    }

    /*
     * Loose catch block
     */
    private byte[] zipFiles(List<File> files) throws IOException {
        byte[] bytes = new byte[2048];
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            byte[] byArray;
            ZipOutputStream zos;
            ByteArrayOutputStream baos;
            block17: {
                block16: {
                    baos = new ByteArrayOutputStream();
                    zos = new ZipOutputStream(baos);
                    for (File file : files) {
                        this.zipFile(bytes, zos, file);
                    }
                    zos.flush();
                    zos.close();
                    baos.flush();
                    byArray = baos.toByteArray();
                    if (zos == null) break block16;
                    zos.close();
                }
                if (baos == null) break block17;
                baos.close();
            }
            return byArray;
            {
                catch (Throwable throwable2) {
                    try {
                        if (zos != null) {
                            zos.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (baos != null) {
                            baos.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void zipFile(byte[] bytes, ZipOutputStream zos, File file) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            FileInputStream fis = new FileInputStream(file.getCanonicalPath());
            try {
                try (BufferedInputStream bis = new BufferedInputStream(fis);){
                    int bytesRead;
                    zos.putNextEntry(new ZipEntry(file.getName()));
                    while ((bytesRead = bis.read(bytes)) != -1) {
                        zos.write(bytes, 0, bytesRead);
                    }
                    zos.closeEntry();
                }
                if (fis == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (fis == null) throw throwable;
                fis.close();
                throw throwable;
            }
            fis.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private boolean writeJournalLog(PrivilegedExecutorService pes, String outputFields, String outputFile) {
        return this.writeJournalLog(pes, outputFields, outputFile, null);
    }

    private boolean writeJournalLog(PrivilegedExecutorService pes, String outputFields, String outputFile, String unit) {
        ArrayList<String> commandSequence = new ArrayList<String>();
        commandSequence.add(JOURNALCTL_CMD);
        commandSequence.add("--no-pager");
        if (!Objects.isNull(unit)) {
            commandSequence.add("-u");
            commandSequence.add(unit);
        }
        commandSequence.add("-o");
        commandSequence.add("verbose");
        commandSequence.add("--output-fields=" + outputFields);
        commandSequence.add(">");
        commandSequence.add(outputFile);
        Command command = new Command(commandSequence.toArray(new String[commandSequence.size()]));
        if (logger.isDebugEnabled()) {
            logger.debug("Executing command: {}", (Object)String.join((CharSequence)" ", command.getCommandLine()));
        }
        command.setExecuteInAShell(true);
        CommandStatus status = pes.execute(command);
        return status.getExitStatus().isSuccessful();
    }

    private void removeTmpFiles() {
        try {
            Files.deleteIfExists(new File(KURA_JOURNAL_LOG_FILE).toPath());
            Files.deleteIfExists(new File(SYSTEM_JOURNAL_LOG_FILE).toPath());
        }
        catch (IOException e) {
            logger.warn("Unable to delete temporary log files", (Throwable)e);
        }
    }
}

