/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.configuration;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.KuraPartialSuccessException;
import org.eclipse.kura.configuration.ComponentConfiguration;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.configuration.ConfigurationService;
import org.eclipse.kura.configuration.Password;
import org.eclipse.kura.configuration.SelfConfiguringComponent;
import org.eclipse.kura.configuration.metatype.AD;
import org.eclipse.kura.configuration.metatype.OCD;
import org.eclipse.kura.configuration.metatype.OCDService;
import org.eclipse.kura.core.configuration.ComponentConfigurationImpl;
import org.eclipse.kura.core.configuration.ComponentMetaTypeBundleTracker;
import org.eclipse.kura.core.configuration.XmlComponentConfigurations;
import org.eclipse.kura.core.configuration.metatype.Tocd;
import org.eclipse.kura.core.configuration.upgrade.ConfigurationUpgrade;
import org.eclipse.kura.core.configuration.util.CollectionsUtil;
import org.eclipse.kura.core.configuration.util.ComponentUtil;
import org.eclipse.kura.core.configuration.util.StringUtil;
import org.eclipse.kura.crypto.CryptoService;
import org.eclipse.kura.marshalling.Marshaller;
import org.eclipse.kura.marshalling.Unmarshaller;
import org.eclipse.kura.system.SystemService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.ComponentException;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.component.runtime.dto.ComponentDescriptionDTO;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.MetaTypeService;
import org.osgi.service.metatype.ObjectClassDefinition;
import org.osgi.util.tracker.BundleTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationServiceImpl
implements ConfigurationService,
OCDService {
    private static final String GETTING_CONFIGURATION_ERROR = "Error getting Configuration for component: {}. Ignoring it.";
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationServiceImpl.class);
    private ComponentContext ctx;
    private BundleContext bundleContext;
    private BundleTracker<Bundle> bundleTracker;
    private MetaTypeService metaTypeService;
    private ConfigurationAdmin configurationAdmin;
    private SystemService systemService;
    private CryptoService cryptoService;
    private ServiceComponentRuntime scrService;
    private Marshaller xmlMarshaller;
    private Unmarshaller xmlUnmarshaller;
    protected EventAdmin eventAdmin;
    private final Set<String> allActivatedPids = new HashSet<String>();
    private final Set<String> activatedSelfConfigComponents = new HashSet<String>();
    private final Map<String, Tocd> ocds;
    private final Set<TrackedComponentFactory> factoryPids;
    private final Map<String, String> factoryPidByPid;
    private final Set<String> pendingDeletePids = new HashSet<String>();
    private final Map<String, String> servicePidByPid;

    public void setConfigurationAdmin(ConfigurationAdmin configAdmin) {
        this.configurationAdmin = configAdmin;
    }

    public void unsetConfigurationAdmin(ConfigurationAdmin configAdmin) {
        this.configurationAdmin = null;
    }

    public void setMetaTypeService(MetaTypeService metaTypeService) {
        this.metaTypeService = metaTypeService;
    }

    public void unsetMetaTypeService(MetaTypeService metaTypeService) {
        this.metaTypeService = null;
    }

    public void setSystemService(SystemService systemService) {
        this.systemService = systemService;
    }

    public void unsetSystemService(SystemService systemService) {
        this.systemService = null;
    }

    public void setCryptoService(CryptoService cryptoService) {
        this.cryptoService = cryptoService;
    }

    public void unsetCryptoService(CryptoService cryptoService) {
        this.cryptoService = null;
    }

    public void setScrService(ServiceComponentRuntime scrService) {
        this.scrService = scrService;
    }

    public void unsetScrService(ServiceComponentRuntime scrService) {
        this.scrService = null;
    }

    public void setXmlMarshaller(Marshaller marshaller) {
        this.xmlMarshaller = marshaller;
    }

    public void unsetXmlMarshaller(Marshaller marshaller) {
        this.xmlMarshaller = null;
    }

    public void setXmlUnmarshaller(Unmarshaller unmarshaller) {
        this.xmlUnmarshaller = unmarshaller;
    }

    public void unsetXmlUnmarshaller(Unmarshaller unmarshaller) {
        this.xmlUnmarshaller = null;
    }

    public void setEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    public void unsetEventAdmin(EventAdmin eventAdmin) {
        if (this.eventAdmin == eventAdmin) {
            this.eventAdmin = null;
        }
    }

    public ConfigurationServiceImpl() {
        this.ocds = new HashMap<String, Tocd>();
        this.factoryPids = new HashSet<TrackedComponentFactory>();
        this.factoryPidByPid = new HashMap<String, String>();
        this.servicePidByPid = new HashMap<String, String>();
    }

    protected void activate(ComponentContext componentContext) throws InvalidSyntaxException {
        logger.info("activate...");
        this.ctx = componentContext;
        this.bundleContext = componentContext.getBundleContext();
        try {
            this.loadLatestSnapshotInConfigAdmin();
        }
        catch (Exception e) {
            throw new ComponentException("Error loading latest snapshot", (Throwable)e);
        }
        this.bundleTracker = new ComponentMetaTypeBundleTracker(this.ctx.getBundleContext(), this);
        this.bundleTracker.open();
    }

    protected void addConfigurableComponent(ServiceReference<ConfigurableComponent> reference) {
        String servicePid = ConfigurationServiceImpl.makeString(reference.getProperty("service.pid"));
        if (servicePid == null) {
            return;
        }
        String kuraPid = ConfigurationServiceImpl.makeString(reference.getProperty("kura.service.pid"));
        String factoryPid = ConfigurationServiceImpl.makeString(reference.getProperty("service.factoryPid"));
        this.registerComponentConfiguration(kuraPid, servicePid, factoryPid);
    }

    protected void removeConfigurableComponent(ServiceReference<ConfigurableComponent> reference) {
        String servicePid = ConfigurationServiceImpl.makeString(reference.getProperty("service.pid"));
        if (servicePid == null) {
            return;
        }
        String kuraPid = ConfigurationServiceImpl.makeString(reference.getProperty("kura.service.pid"));
        this.unregisterComponentConfiguration(kuraPid);
    }

    protected void addSelfConfiguringComponent(ServiceReference<SelfConfiguringComponent> reference) {
        String servicePid = ConfigurationServiceImpl.makeString(reference.getProperty("service.pid"));
        if (servicePid == null) {
            return;
        }
        String kuraPid = ConfigurationServiceImpl.makeString(reference.getProperty("kura.service.pid"));
        this.registerSelfConfiguringComponent(kuraPid, servicePid);
    }

    protected void removeSelfConfiguringComponent(ServiceReference<SelfConfiguringComponent> reference) {
        String servicePid = ConfigurationServiceImpl.makeString(reference.getProperty("service.pid"));
        if (servicePid == null) {
            return;
        }
        String kuraPid = ConfigurationServiceImpl.makeString(reference.getProperty("kura.service.pid"));
        this.unregisterComponentConfiguration(kuraPid);
    }

    protected void deactivate(ComponentContext componentContext) {
        logger.info("deactivate...");
        if (this.bundleTracker != null) {
            this.bundleTracker.close();
            this.bundleTracker = null;
        }
    }

    public Set<String> getConfigurableComponentPids() {
        if (this.allActivatedPids.isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.allActivatedPids);
    }

    public List<ComponentConfiguration> getComponentConfigurations() throws KuraException {
        return this.getComponentConfigurationsInternal();
    }

    public List<ComponentConfiguration> getComponentConfigurations(Filter filter) throws KuraException {
        if (filter == null) {
            return this.getComponentConfigurationsInternal();
        }
        try {
            ServiceReference[] refs = this.bundleContext.getAllServiceReferences(null, null);
            ArrayList<ComponentConfiguration> result = new ArrayList<ComponentConfiguration>(refs.length);
            ServiceReference[] serviceReferenceArray = refs;
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                ComponentConfiguration config;
                Object kuraServicePid;
                ServiceReference ref = serviceReferenceArray[n2];
                if (filter.match(ref) && (kuraServicePid = ref.getProperty("kura.service.pid")) instanceof String && (config = this.getComponentConfigurationInternal((String)kuraServicePid)) != null) {
                    result.add(config);
                }
                ++n2;
            }
            return result;
        }
        catch (Exception e) {
            throw new KuraException(KuraErrorCode.CONFIGURATION_ERROR, (Throwable)e, new Object[0]);
        }
    }

    public ComponentConfiguration getComponentConfiguration(String pid) throws KuraException {
        ComponentConfiguration tempConfig = this.getComponentConfigurationInternal(pid);
        if (tempConfig != null && tempConfig.getConfigurationProperties() != null) {
            this.decryptConfigurationProperties(tempConfig.getConfigurationProperties());
        }
        return tempConfig;
    }

    public synchronized void updateConfiguration(String pidToUpdate, Map<String, Object> propertiesToUpdate) throws KuraException {
        this.updateConfiguration(pidToUpdate, propertiesToUpdate, true);
    }

    public synchronized void updateConfiguration(String pidToUpdate, Map<String, Object> propertiesToUpdate, boolean takeSnapshot) throws KuraException {
        ArrayList<ComponentConfiguration> configs = new ArrayList<ComponentConfiguration>();
        ComponentConfigurationImpl cci = new ComponentConfigurationImpl(pidToUpdate, null, propertiesToUpdate);
        configs.add(cci);
        this.updateConfigurations(configs, takeSnapshot);
    }

    public synchronized void updateConfigurations(List<ComponentConfiguration> configsToUpdate) throws KuraException {
        this.updateConfigurations(configsToUpdate, true);
    }

    public synchronized void updateConfigurations(List<ComponentConfiguration> configsToUpdate, boolean takeSnapshot) throws KuraException {
        for (ComponentConfiguration config : configsToUpdate) {
            if (config == null) continue;
            this.encryptConfigurationProperties(config.getConfigurationProperties());
        }
        this.updateConfigurationsInternal(configsToUpdate, takeSnapshot);
    }

    public Set<String> getFactoryComponentPids() {
        return Collections.unmodifiableSet(this.factoryPids.stream().map(TrackedComponentFactory::getFactoryPid).collect(Collectors.toSet()));
    }

    public ComponentConfiguration getDefaultComponentConfiguration(String pid) throws KuraException {
        ComponentConfiguration tempConfig = this.getDefaultComponentConfigurationInternal(pid);
        if (tempConfig != null && tempConfig.getConfigurationProperties() != null) {
            this.decryptConfigurationProperties(tempConfig.getConfigurationProperties());
        }
        return tempConfig;
    }

    public synchronized void createFactoryConfiguration(String factoryPid, String pid, Map<String, Object> properties, boolean takeSnapshot) throws KuraException {
        if (pid == null) {
            throw new KuraException(KuraErrorCode.INVALID_PARAMETER, new Object[]{"pid cannot be null"});
        }
        if (this.servicePidByPid.containsKey(pid)) {
            throw new KuraException(KuraErrorCode.INVALID_PARAMETER, new Object[]{"pid " + pid + " already exists"});
        }
        try {
            logger.info("Creating new configuration for factory pid {} and pid {}", (Object)factoryPid, (Object)pid);
            String servicePid = this.configurationAdmin.createFactoryConfiguration(factoryPid, null).getPid();
            logger.info("Updating newly created configuration for pid {}", (Object)pid);
            HashMap<String, Object> mergedProperties = new HashMap<String, Object>();
            if (properties != null) {
                mergedProperties.putAll(properties);
            }
            OCD ocd = this.ocds.get(factoryPid);
            this.mergeWithDefaults(ocd, mergedProperties);
            mergedProperties.put("kura.service.pid", pid);
            Dictionary<String, Object> dict = CollectionsUtil.mapToDictionary(mergedProperties);
            Configuration config = this.configurationAdmin.getConfiguration(servicePid, "?");
            config.update(dict);
            this.registerComponentConfiguration(pid, servicePid, factoryPid);
            this.pendingDeletePids.remove(pid);
            if (takeSnapshot) {
                this.snapshot();
            }
        }
        catch (IOException e) {
            throw new KuraException(KuraErrorCode.CONFIGURATION_ERROR, (Throwable)e, new Object[]{"Cannot create component instance for factory " + factoryPid});
        }
    }

    public synchronized void deleteFactoryConfiguration(String pid, boolean takeSnapshot) throws KuraException {
        if (pid == null) {
            throw new KuraException(KuraErrorCode.INVALID_PARAMETER, new Object[]{"pid cannot be null"});
        }
        try {
            Configuration[] configurations = this.configurationAdmin.listConfigurations(null);
            if (configurations == null) {
                logger.warn("ConfigurationAdmin has no configurations");
                return;
            }
            Optional<Configuration> config = Arrays.stream(configurations).filter(c -> {
                Object kuraServicePid = c.getProperties().get("kura.service.pid");
                String factoryPid = c.getFactoryPid();
                return pid.equals(kuraServicePid) && factoryPid != null;
            }).findAny();
            if (!config.isPresent()) {
                logger.warn("The component with kura.service.pid {} does not exist or it is not a Factory Component", (Object)pid);
                return;
            }
            logger.info("Deleting factory configuration for component with pid {}...", (Object)pid);
            config.get().delete();
            this.unregisterComponentConfiguration(pid);
            this.pendingDeletePids.add(pid);
            if (takeSnapshot) {
                this.snapshot();
            }
            logger.info("Deleting factory configuration for component with pid {}...done", (Object)pid);
        }
        catch (Exception e) {
            throw new KuraException(KuraErrorCode.CONFIGURATION_ERROR, (Throwable)e, new Object[]{"Cannot delete component instance " + pid});
        }
    }

    public long snapshot() throws KuraException {
        logger.info("Writing snapshot - Getting component configurations...");
        List<ComponentConfiguration> configs = this.buildCurrentConfiguration(null);
        return this.saveSnapshot(configs);
    }

    public long rollback() throws KuraException {
        Set<Long> ids = this.getSnapshots();
        if (ids.size() < 2) {
            throw new KuraException(KuraErrorCode.CONFIGURATION_SNAPSHOT_NOT_FOUND, null, new Object[]{"No Snapshot Available"});
        }
        Long[] snapshots = ids.toArray(new Long[0]);
        Long id = snapshots[ids.size() - 2];
        this.rollback(id);
        return id;
    }

    public synchronized void rollback(long id) throws KuraException {
        XmlComponentConfigurations xmlConfigs = this.loadEncryptedSnapshotFileContent(id);
        logger.info("Rolling back to snapshot {}...", (Object)id);
        HashSet<String> snapshotPids = new HashSet<String>();
        boolean snapshotOnConfirmation = false;
        ArrayList<Exception> causes = new ArrayList<Exception>();
        List<ComponentConfiguration> configs = xmlConfigs.getConfigurations();
        for (String pid : new ArrayList<String>(this.factoryPidByPid.keySet())) {
            try {
                this.deleteFactoryConfiguration(pid, false);
            }
            catch (Exception e) {
                logger.warn("Failed to remove factory configuration for pid: " + pid, (Throwable)e);
                causes.add(e);
            }
        }
        Stream<ComponentConfiguration> factoryConfigurationsInSnapshot = configs.stream().filter(config -> config.getPid() != null && config.getConfigurationProperties().containsKey("service.factoryPid"));
        factoryConfigurationsInSnapshot.forEach(config -> {
            String pid = config.getPid();
            Map properties = config.getConfigurationProperties();
            String factoryPid = properties.get("service.factoryPid").toString();
            try {
                this.createFactoryConfiguration(factoryPid, pid, properties, false);
            }
            catch (Exception e) {
                logger.warn("Error during rollback for component " + pid, (Throwable)e);
                causes.add(e);
            }
        });
        for (ComponentConfiguration config2 : configs) {
            if (config2 == null) continue;
            try {
                this.rollbackConfigurationInternal(config2.getPid(), config2.getConfigurationProperties(), snapshotOnConfirmation);
            }
            catch (Exception e) {
                logger.warn("Error during rollback for component " + config2.getPid(), (Throwable)e);
                causes.add(e);
            }
            snapshotPids.add(config2.getPid());
        }
        HashSet<String> pids = new HashSet<String>(this.allActivatedPids);
        pids.removeAll(snapshotPids);
        for (String pid : pids) {
            logger.info("Rolling back to default configuration for component pid: '{}'", (Object)pid);
            try {
                this.rollbackConfigurationInternal(pid, Collections.emptyMap(), snapshotOnConfirmation);
            }
            catch (Exception e) {
                logger.warn("Error during rollback for component " + pid, (Throwable)e);
                causes.add(e);
            }
        }
        if (!causes.isEmpty()) {
            throw new KuraPartialSuccessException("Rollback", causes);
        }
        this.saveSnapshot(configs);
    }

    public Set<Long> getSnapshots() throws KuraException {
        return this.getSnapshotsInternal();
    }

    public List<ComponentConfiguration> getSnapshot(long sid) throws KuraException {
        ArrayList<ComponentConfiguration> returnConfigs = new ArrayList<ComponentConfiguration>();
        XmlComponentConfigurations xmlConfigs = this.loadEncryptedSnapshotFileContent(sid);
        if (xmlConfigs != null) {
            List<ComponentConfiguration> configs = xmlConfigs.getConfigurations();
            for (ComponentConfiguration config : configs) {
                if (config == null) continue;
                try {
                    this.decryptConfigurationProperties(config.getConfigurationProperties());
                }
                catch (Throwable throwable) {
                    logger.warn("Error during snapshot password decryption");
                }
            }
            returnConfigs.addAll(xmlConfigs.getConfigurations());
        }
        return returnConfigs;
    }

    synchronized void registerComponentOCD(String metatypePid, Tocd ocd, boolean isFactory, Bundle provider) throws KuraException {
        logger.info("Registering metatype pid: {} ...", (Object)metatypePid);
        this.ocds.put(metatypePid, ocd);
        if (isFactory) {
            this.registerFactoryComponentOCD(metatypePid, ocd, provider);
        } else {
            try {
                this.updateWithDefaultConfiguration(metatypePid, ocd);
            }
            catch (IOException e) {
                throw new KuraException(KuraErrorCode.INTERNAL_ERROR, (Throwable)e, new Object[0]);
            }
        }
    }

    synchronized void onBundleRemoved(Bundle bundle) {
        this.factoryPids.removeIf(factory -> {
            Bundle provider = factory.getProviderBundle();
            return provider.getSymbolicName().equals(bundle.getSymbolicName()) && provider.getVersion().equals((Object)bundle.getVersion());
        });
    }

    synchronized void registerComponentConfiguration(String pid, String servicePid, String factoryPid) {
        if (pid == null || servicePid == null) {
            logger.warn("Either PID (kura.service.pid) {} or Service PID (service.pid) {} is null", (Object)pid, (Object)servicePid);
            return;
        }
        if (!this.allActivatedPids.contains(pid)) {
            logger.info("Registering ConfigurableComponent - {}....", (Object)pid);
            this.servicePidByPid.put(pid, servicePid);
            if (factoryPid != null) {
                this.factoryPidByPid.put(pid, factoryPid);
                Tocd factoryOCD = this.ocds.get(factoryPid);
                if (factoryOCD != null) {
                    try {
                        this.updateWithDefaultConfiguration(pid, factoryOCD);
                    }
                    catch (KuraException kuraException) {
                        logger.info("Error seeding updated configuration for pid: {}", (Object)pid);
                    }
                    catch (IOException iOException) {
                        logger.info("Error seeding updated configuration for pid: {}", (Object)pid);
                    }
                }
            }
            this.allActivatedPids.add(pid);
            logger.info("Registering ConfigurableComponent - {}....Done", (Object)pid);
        }
    }

    synchronized void registerSelfConfiguringComponent(String pid, String servicePid) {
        if (pid == null) {
            logger.warn("PID (kura.service.pid) is null");
            return;
        }
        logger.info("Registering SelfConfiguringComponent - {}....", (Object)pid);
        if (!this.allActivatedPids.contains(pid)) {
            this.allActivatedPids.add(pid);
        }
        if (!this.activatedSelfConfigComponents.contains(pid)) {
            this.servicePidByPid.put(pid, servicePid);
            this.activatedSelfConfigComponents.add(pid);
        }
        logger.info("Registering SelfConfiguringComponent - {}....Done", (Object)pid);
    }

    synchronized void unregisterComponentConfiguration(String pid) {
        if (pid == null) {
            logger.warn("pid is null");
            return;
        }
        logger.info("Removing component configuration for pid {}", (Object)pid);
        this.servicePidByPid.remove(pid);
        this.factoryPidByPid.remove(pid);
        this.activatedSelfConfigComponents.remove(pid);
        this.allActivatedPids.remove(pid);
    }

    boolean mergeWithDefaults(OCD ocd, Map<String, Object> properties) throws KuraException {
        boolean changed = false;
        Set<String> keys = properties.keySet();
        Map<String, Object> defaults = this.getDefaultProperties(ocd);
        Set<String> defaultsKeys = defaults.keySet();
        defaultsKeys.removeAll(keys);
        if (!defaultsKeys.isEmpty()) {
            changed = true;
            logger.info("Merging configuration for pid: {}", (Object)ocd.getId());
            for (String key : defaultsKeys) {
                Object value = defaults.get(key);
                properties.put(key, value);
                logger.debug("Merged configuration properties with property with name: {} and default value {}", (Object)key, value);
            }
        }
        return changed;
    }

    Map<String, Object> getDefaultProperties(OCD ocd) throws KuraException {
        return ComponentUtil.getDefaultProperties(ocd, this.ctx);
    }

    void decryptConfigurationProperties(Map<String, Object> configProperties) {
        for (Map.Entry<String, Object> property : configProperties.entrySet()) {
            Object configValue = property.getValue();
            if (!(configValue instanceof Password) && !(configValue instanceof Password[])) continue;
            try {
                Object decryptedValue = this.decryptPasswordProperties(configValue);
                configProperties.put(property.getKey(), decryptedValue);
            }
            catch (Exception exception) {}
        }
    }

    private Object decryptPasswordProperties(Object encryptedValue) throws KuraException {
        Password[] decryptedValue = null;
        if (encryptedValue instanceof Password) {
            decryptedValue = this.decryptPassword((Password)encryptedValue);
        } else if (encryptedValue instanceof Password[]) {
            Password[] encryptedPasswords = (Password[])encryptedValue;
            Password[] decryptedPasswords = new Password[encryptedPasswords.length];
            int i = 0;
            while (i < encryptedPasswords.length) {
                decryptedPasswords[i] = this.decryptPassword(encryptedPasswords[i]);
                ++i;
            }
            decryptedValue = decryptedPasswords;
        }
        return decryptedValue;
    }

    private Password decryptPassword(Password encryptedPassword) throws KuraException {
        return new Password(this.cryptoService.decryptAes(encryptedPassword.getPassword()));
    }

    private synchronized void updateConfigurationsInternal(List<ComponentConfiguration> configsToUpdate, boolean takeSnapshot) throws KuraException {
        boolean snapshotOnConfirmation = false;
        ArrayList<KuraException> causes = new ArrayList<KuraException>();
        List<ComponentConfiguration> configs = this.buildCurrentConfiguration(configsToUpdate);
        block4: for (ComponentConfiguration config : configs) {
            for (ComponentConfiguration configToUpdate : configsToUpdate) {
                if (!config.getPid().equals(configToUpdate.getPid())) continue;
                try {
                    this.updateConfigurationInternal(config.getPid(), config.getConfigurationProperties(), snapshotOnConfirmation);
                }
                catch (KuraException e) {
                    logger.warn("Error during updateConfigurations for component " + config.getPid(), (Throwable)e);
                    causes.add(e);
                }
                continue block4;
            }
        }
        for (ComponentConfiguration config : configsToUpdate) {
            String factoryPid = null;
            Map properties = config.getConfigurationProperties();
            if (properties != null) {
                factoryPid = (String)properties.get("service.factoryPid");
            }
            if (factoryPid == null || this.allActivatedPids.contains(config.getPid())) continue;
            ConfigurationUpgrade.upgrade(config, this.bundleContext);
            String pid = config.getPid();
            logger.info("Creating configuration with pid: {} and factory pid: {}", (Object)pid, (Object)factoryPid);
            try {
                this.createFactoryConfiguration(factoryPid, pid, properties, false);
                configs.add(config);
            }
            catch (KuraException e) {
                logger.warn("Error creating configuration with pid: {} and factory pid: {}", new Object[]{pid, factoryPid, e});
            }
        }
        if (takeSnapshot && configs != null && !configs.isEmpty()) {
            this.saveSnapshot(configs);
        }
        if (!causes.isEmpty()) {
            throw new KuraPartialSuccessException("updateConfigurations", causes);
        }
    }

    private List<ComponentConfiguration> getComponentConfigurationsInternal() throws KuraException {
        ArrayList<ComponentConfiguration> configs = new ArrayList<ComponentConfiguration>();
        ArrayList<String> allPids = new ArrayList<String>(this.allActivatedPids);
        for (String pid : allPids) {
            try {
                ComponentConfiguration cc = this.getComponentConfigurationInternal(pid);
                if (cc == null) continue;
                configs.add(cc);
            }
            catch (Exception e) {
                logger.error("Error getting configuration for component " + pid, (Throwable)e);
                throw new KuraException(KuraErrorCode.CONFIGURATION_ERROR, (Throwable)e, new Object[]{"Error getting configuration for component " + pid});
            }
        }
        return configs;
    }

    private ComponentConfiguration getComponentConfigurationInternal(String pid) {
        ComponentConfiguration cc = !this.activatedSelfConfigComponents.contains(pid) ? this.getConfigurableComponentConfiguration(pid) : this.getSelfConfiguringComponentConfiguration(pid);
        return cc;
    }

    private ComponentConfiguration getDefaultComponentConfigurationInternal(String pid) {
        ComponentConfiguration cc = !this.activatedSelfConfigComponents.contains(pid) ? this.getConfigurableComponentDefaultConfiguration(pid) : this.getSelfConfiguringComponentDefaultConfiguration(pid);
        return cc;
    }

    private ComponentConfiguration getConfigurableComponentDefaultConfiguration(String pid) {
        Tocd ocd = this.getOCDForPid(pid);
        Map<String, Object> props = ComponentUtil.getDefaultProperties(ocd, this.ctx);
        return new ComponentConfigurationImpl(pid, ocd, props);
    }

    private ComponentConfiguration getSelfConfiguringComponentDefaultConfiguration(String pid) {
        ComponentConfiguration cc;
        block5: {
            cc = null;
            try {
                String filter = String.format("(kura.service.pid=%s)", pid);
                ServiceReference[] refs = this.ctx.getBundleContext().getServiceReferences(null, filter);
                if (refs == null || refs.length <= 0) break block5;
                ServiceReference ref = refs[0];
                Object obj = this.ctx.getBundleContext().getService(ref);
                try {
                    cc = this.getSelfConfiguringComponentDefaultConfigurationInternal(obj, pid);
                }
                finally {
                    this.ctx.getBundleContext().ungetService(ref);
                }
            }
            catch (InvalidSyntaxException e) {
                logger.error(GETTING_CONFIGURATION_ERROR, (Object)pid, (Object)e);
            }
        }
        return cc;
    }

    private ComponentConfiguration getSelfConfiguringComponentDefaultConfigurationInternal(Object obj, String pid) {
        ComponentConfigurationImpl cc = null;
        if (obj instanceof SelfConfiguringComponent) {
            SelfConfiguringComponent selfConfigComp = (SelfConfiguringComponent)obj;
            try {
                ComponentConfiguration tempCc = selfConfigComp.getConfiguration();
                if (tempCc.getPid() == null || !tempCc.getPid().equals(pid)) {
                    logger.error("Invalid pid for returned Configuration of SelfConfiguringComponent with pid: {} Ignoring it.", (Object)pid);
                    return cc;
                }
                OCD ocd = tempCc.getDefinition();
                if (ocd != null) {
                    Map<String, Object> props = ComponentUtil.getDefaultProperties(ocd, this.ctx);
                    cc = new ComponentConfigurationImpl(pid, (Tocd)ocd, props);
                }
            }
            catch (KuraException e) {
                logger.error(GETTING_CONFIGURATION_ERROR, (Object)pid, (Object)e);
            }
        } else {
            logger.error("Component {} is not a SelfConfiguringComponent. Ignoring it.", obj);
        }
        return cc;
    }

    private void updateWithDefaultConfiguration(String pid, Tocd ocd) throws KuraException, IOException {
        Configuration config;
        String servicePid = this.servicePidByPid.get(pid);
        if (servicePid == null) {
            servicePid = pid;
        }
        if ((config = this.configurationAdmin.getConfiguration(servicePid, "?")) != null) {
            HashMap<String, Object> props = new HashMap<String, Object>();
            if (config.getProperties() != null) {
                props.putAll(CollectionsUtil.dictionaryToMap(config.getProperties(), ocd));
            }
            if (!props.containsKey("kura.service.pid")) {
                props.put("kura.service.pid", pid);
            }
            this.mergeWithDefaults(ocd, props);
            config.update(CollectionsUtil.mapToDictionary(props));
            logger.info("Seeding updated configuration for pid: {}", (Object)pid);
        }
    }

    private void registerFactoryComponentOCD(String metatypePid, Tocd ocd, Bundle provider) throws KuraException {
        this.factoryPids.add(new TrackedComponentFactory(metatypePid, provider));
        for (Map.Entry<String, String> entry : this.factoryPidByPid.entrySet()) {
            if (!entry.getValue().equals(metatypePid) || this.servicePidByPid.get(entry.getKey()) == null) continue;
            try {
                this.updateWithDefaultConfiguration(entry.getKey(), ocd);
            }
            catch (IOException e) {
                throw new KuraException(KuraErrorCode.INTERNAL_ERROR, (Throwable)e, new Object[0]);
            }
        }
    }

    private void encryptConfigurationProperties(Map<String, Object> propertiesToUpdate) {
        if (propertiesToUpdate == null) {
            return;
        }
        for (Map.Entry<String, Object> property : propertiesToUpdate.entrySet()) {
            Object configValue = property.getValue();
            if (!(configValue instanceof Password) && !(configValue instanceof Password[])) continue;
            try {
                Object encryptedValue = this.encryptPasswordProperties(configValue);
                propertiesToUpdate.put(property.getKey(), encryptedValue);
            }
            catch (KuraException kuraException) {
                logger.warn("Failed to encrypt Password property: {}", (Object)property.getKey());
                propertiesToUpdate.remove(property.getKey());
            }
        }
    }

    private Object encryptPasswordProperties(Object configValue) throws KuraException {
        Password[] encryptedValue = null;
        if (configValue instanceof Password) {
            encryptedValue = this.encryptPassword((Password)configValue);
        } else if (configValue instanceof Password[]) {
            Password[] passwordArray = (Password[])configValue;
            Password[] encryptedPasswords = new Password[passwordArray.length];
            int i = 0;
            while (i < passwordArray.length) {
                encryptedPasswords[i] = this.encryptPassword(passwordArray[i]);
                ++i;
            }
            encryptedValue = encryptedPasswords;
        }
        return encryptedValue;
    }

    private boolean isEncrypted(Password configPassword) {
        boolean result = false;
        try {
            this.cryptoService.decryptAes(configPassword.getPassword());
            result = true;
        }
        catch (Exception exception) {}
        return result;
    }

    private Password encryptPassword(Password password) throws KuraException {
        if (!this.isEncrypted(password)) {
            return new Password(this.cryptoService.encryptAes(password.getPassword()));
        }
        return password;
    }

    private void encryptConfigs(List<ComponentConfiguration> configs) {
        if (configs != null) {
            for (ComponentConfiguration config : configs) {
                this.encryptConfigurationProperties(config.getConfigurationProperties());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean allSnapshotsUnencrypted() {
        try {
            Long[] snapshots;
            Set<Long> snapshotIDs = this.getSnapshots();
            if (snapshotIDs == null || snapshotIDs.isEmpty()) {
                return false;
            }
            Long[] longArray = snapshots = snapshotIDs.toArray(new Long[0]);
            int n = snapshots.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return true;
                }
                Long snapshot = longArray[n2];
                try {
                    this.loadEncryptedSnapshotFileContent(snapshot);
                    return false;
                }
                catch (Exception exception) {
                    ++n2;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static String readFully(File file) throws IOException {
        char[] buf = new char[4096];
        StringBuilder builder = new StringBuilder();
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileReader r = new FileReader(file);){
            int rd;
            while ((rd = r.read(buf, 0, buf.length)) > 0) {
                builder.append(buf, 0, rd);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return builder.toString();
    }

    private void encryptPlainSnapshots() throws KuraException, IOException {
        Long[] snapshots;
        Set<Long> snapshotIDs = this.getSnapshots();
        if (snapshotIDs == null || snapshotIDs.isEmpty()) {
            return;
        }
        Long[] longArray = snapshots = snapshotIDs.toArray(new Long[0]);
        int n = snapshots.length;
        int n2 = 0;
        while (n2 < n) {
            Long snapshot = longArray[n2];
            File fSnapshot = this.getSnapshotFile(snapshot);
            if (fSnapshot == null || !fSnapshot.exists()) {
                throw new KuraException(KuraErrorCode.CONFIGURATION_ERROR, new Object[]{snapshot});
            }
            XmlComponentConfigurations xmlConfigs = this.unmarshal(ConfigurationServiceImpl.readFully(fSnapshot), XmlComponentConfigurations.class);
            this.encryptConfigs(xmlConfigs.getConfigurations());
            this.writeSnapshot(snapshot, xmlConfigs);
            ++n2;
        }
    }

    private synchronized long saveSnapshot(List<ComponentConfiguration> configs) throws KuraException {
        Long[] snapshots;
        Long lastestID;
        List<Object> configsToSave = configs;
        configsToSave = configs.stream().map(cc -> new ComponentConfigurationImpl(cc.getPid(), null, cc.getConfigurationProperties())).collect(Collectors.toList());
        XmlComponentConfigurations conf = new XmlComponentConfigurations();
        conf.setConfigurations(configsToSave);
        long sid = new Date().getTime();
        Set<Long> snapshotIDs = this.getSnapshots();
        if (snapshotIDs != null && !snapshotIDs.isEmpty() && (lastestID = (snapshots = snapshotIDs.toArray(new Long[0]))[snapshotIDs.size() - 1]) != null && sid <= lastestID) {
            logger.warn("Snapshot ID: {} is in the past. Adjusting ID to: {} + 1", (Object)sid, (Object)lastestID);
            sid = lastestID + 1L;
        }
        this.writeSnapshot(sid, conf);
        this.pendingDeletePids.clear();
        this.garbageCollectionOldSnapshots();
        return sid;
    }

    private void writeSnapshot(long sid, XmlComponentConfigurations conf) throws KuraException {
        String xmlResult;
        File fSnapshot = this.getSnapshotFile(sid);
        if (fSnapshot == null) {
            throw new KuraException(KuraErrorCode.CONFIGURATION_SNAPSHOT_NOT_FOUND);
        }
        try {
            xmlResult = this.marshal(conf);
            if (xmlResult == null || xmlResult.trim().isEmpty()) {
                throw new KuraException(KuraErrorCode.INVALID_PARAMETER, new Object[]{conf});
            }
        }
        catch (KuraException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KuraException(KuraErrorCode.INTERNAL_ERROR, (Throwable)e, new Object[0]);
        }
        char[] encryptedXML = this.cryptoService.encryptAes(xmlResult.toCharArray());
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        try {
            try {
                logger.info("Writing snapshot - Saving {}...", (Object)fSnapshot.getAbsolutePath());
                fos = new FileOutputStream(fSnapshot);
                osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                osw.append(new String(encryptedXML));
                osw.flush();
                fos.flush();
                fos.getFD().sync();
                logger.info("Writing snapshot - Saving {}... Done.", (Object)fSnapshot.getAbsolutePath());
            }
            catch (FileNotFoundException e) {
                throw new KuraException(KuraErrorCode.INTERNAL_ERROR, (Throwable)e, new Object[0]);
            }
            catch (UnsupportedEncodingException e) {
                throw new KuraException(KuraErrorCode.INTERNAL_ERROR, (Throwable)e, new Object[0]);
            }
            catch (IOException e) {
                throw new KuraException(KuraErrorCode.INTERNAL_ERROR, (Throwable)e, new Object[0]);
            }
        }
        catch (Throwable throwable) {
            if (osw != null) {
                try {
                    osw.close();
                }
                catch (IOException iOException) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (osw != null) {
            try {
                osw.close();
            }
            catch (IOException iOException) {}
        }
        if (fos != null) {
            try {
                fos.close();
            }
            catch (IOException iOException) {}
        }
    }

    private ComponentConfiguration getConfigurableComponentConfiguration(String pid) {
        ComponentConfigurationImpl cc = null;
        try {
            Tocd ocd = this.getOCDForPid(pid);
            String servicePid = this.servicePidByPid.get(pid);
            if (servicePid != null) {
                Configuration cfg = this.configurationAdmin.getConfiguration(servicePid, "?");
                Map<String, Object> props = CollectionsUtil.dictionaryToMap(cfg.getProperties(), ocd);
                cc = new ComponentConfigurationImpl(pid, ocd, props);
            }
        }
        catch (Exception e) {
            logger.error("Error getting Configuration for component: " + pid + ". Ignoring it.", (Throwable)e);
        }
        return cc;
    }

    /*
     * Exception decompiling
     */
    private ComponentConfiguration getSelfConfiguringComponentConfiguration(String pid) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 19[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private TreeSet<Long> getSnapshotsInternal() {
        File fConfigDir;
        File[] files;
        TreeSet<Long> ids = new TreeSet<Long>();
        String configDir = this.getSnapshotsDirectory();
        if (configDir != null && (files = (fConfigDir = new File(configDir)).listFiles()) != null) {
            Pattern p = Pattern.compile("snapshot_([0-9]+)\\.xml");
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                Matcher m = p.matcher(file.getName());
                if (m.matches()) {
                    ids.add(Long.parseLong(m.group(1)));
                }
                ++n2;
            }
        }
        return ids;
    }

    String getSnapshotsDirectory() {
        return this.systemService.getKuraSnapshotsDirectory();
    }

    private File getSnapshotFile(long id) {
        String configDir = this.getSnapshotsDirectory();
        if (configDir == null) {
            return null;
        }
        StringBuilder sbSnapshot = new StringBuilder(configDir);
        sbSnapshot.append(File.separator).append("snapshot_").append(id).append(".xml");
        String snapshot = sbSnapshot.toString();
        return new File(snapshot);
    }

    private void garbageCollectionOldSnapshots() {
        TreeSet<Long> sids = this.getSnapshotsInternal();
        int currCount = sids.size();
        int maxCount = this.systemService.getKuraSnapshotsCount();
        while (currCount > maxCount && !sids.isEmpty()) {
            long sid = sids.pollFirst();
            File fSnapshot = this.getSnapshotFile(sid);
            if (sid == 0L || fSnapshot == null) continue;
            Path fSnapshotPath = fSnapshot.toPath();
            try {
                if (!Files.deleteIfExists(fSnapshotPath)) continue;
                logger.info("Snapshots Garbage Collector. Deleted {}", (Object)fSnapshotPath);
                --currCount;
            }
            catch (IOException e) {
                logger.warn("Snapshots Garbage Collector. Deletion failed for {}", (Object)fSnapshotPath, (Object)e);
            }
        }
    }

    private void loadLatestSnapshotInConfigAdmin() throws KuraException {
        List<ComponentConfiguration> configs = this.buildCurrentConfiguration(null);
        if (configs == null) {
            return;
        }
        for (ComponentConfiguration config : configs) {
            Map props;
            if (config == null || (props = config.getConfigurationProperties()) == null) continue;
            String factoryPid = (String)props.get("service.factoryPid");
            if (factoryPid != null) {
                String pid = config.getPid();
                logger.info("Creating configuration with pid: {} and factory pid: {}", (Object)pid, (Object)factoryPid);
                try {
                    this.createFactoryConfiguration(factoryPid, pid, props, false);
                }
                catch (KuraException e) {
                    logger.warn("Error creating configuration with pid: {} and factory pid: {}", new Object[]{pid, factoryPid, e});
                }
                continue;
            }
            try {
                logger.debug("Pushing config to config admin: {}", (Object)config.getPid());
                Configuration cfg = this.configurationAdmin.getConfiguration(config.getPid(), "?");
                HashMap<String, Object> newProperties = new HashMap<String, Object>(props);
                if (!newProperties.containsKey("kura.service.pid")) {
                    newProperties.put("kura.service.pid", config.getPid());
                }
                cfg.update(CollectionsUtil.mapToDictionary(newProperties));
            }
            catch (IOException e) {
                logger.warn("Error seeding initial properties to ConfigAdmin for pid: {}", (Object)config.getPid(), (Object)e);
            }
        }
    }

    private List<ComponentConfiguration> loadLatestSnapshotConfigurations() throws KuraException {
        Set<Long> snapshotIDs = this.getSnapshots();
        if (snapshotIDs == null || snapshotIDs.isEmpty()) {
            return null;
        }
        Long[] snapshots = snapshotIDs.toArray(new Long[0]);
        Long lastestID = snapshots[snapshotIDs.size() - 1];
        logger.info("Loading init configurations from: {}...", (Object)lastestID);
        List<ComponentConfiguration> configs = null;
        try {
            XmlComponentConfigurations xmlConfigs = this.loadEncryptedSnapshotFileContent(lastestID);
            if (xmlConfigs != null) {
                configs = xmlConfigs.getConfigurations();
            }
        }
        catch (Exception exception) {
            logger.info("Unable to decrypt snapshot! Fallback to unencrypted snapshots mode.");
            try {
                if (this.allSnapshotsUnencrypted()) {
                    this.encryptPlainSnapshots();
                    configs = this.loadLatestSnapshotConfigurations();
                }
            }
            catch (Exception ex) {
                throw new KuraException(KuraErrorCode.INTERNAL_ERROR, (Throwable)ex, new Object[0]);
            }
        }
        return configs;
    }

    XmlComponentConfigurations loadEncryptedSnapshotFileContent(long snapshotID) throws KuraException {
        String rawSnapshot;
        File fSnapshot = this.getSnapshotFile(snapshotID);
        if (fSnapshot == null || !fSnapshot.exists()) {
            throw new KuraException(KuraErrorCode.CONFIGURATION_SNAPSHOT_NOT_FOUND, new Object[]{fSnapshot != null ? fSnapshot.getAbsolutePath() : "null"});
        }
        try {
            rawSnapshot = ConfigurationServiceImpl.readFully(fSnapshot);
        }
        catch (IOException e) {
            logger.error("Error loading file from disk", (Throwable)e);
            return null;
        }
        char[] decryptAes = this.cryptoService.decryptAes(rawSnapshot.toCharArray());
        if (decryptAes == null) {
            throw new KuraException(KuraErrorCode.DECODER_ERROR, new Object[]{"snapshot"});
        }
        String decryptedContent = new String(decryptAes);
        XmlComponentConfigurations xmlConfigs = null;
        try {
            xmlConfigs = this.unmarshal(decryptedContent, XmlComponentConfigurations.class);
        }
        catch (KuraException e) {
            logger.warn("Error parsing xml", (Throwable)e);
        }
        return xmlConfigs;
    }

    private void updateConfigurationInternal(String pid, Map<String, Object> properties, boolean snapshotOnConfirmation) throws KuraException {
        logger.debug("Attempting update configuration for {}", (Object)pid);
        if (!this.allActivatedPids.contains(pid)) {
            logger.info("UpdatingConfiguration ignored as ConfigurableComponent {} is NOT tracked.", (Object)pid);
            return;
        }
        if (properties == null) {
            logger.info("UpdatingConfiguration ignored as properties for ConfigurableComponent {} are NULL.", (Object)pid);
            return;
        }
        OCD registerdOCD = this.getRegisteredOCD(pid);
        if (registerdOCD == null) {
            logger.info("UpdatingConfiguration ignored as OCD for pid {} cannot be found.", (Object)pid);
            return;
        }
        HashMap<String, Object> mergedProperties = new HashMap<String, Object>();
        this.mergeWithDefaults(registerdOCD, mergedProperties);
        if (!this.activatedSelfConfigComponents.contains(pid)) {
            try {
                Configuration config = this.configurationAdmin.getConfiguration(this.servicePidByPid.get(pid), "?");
                Map<String, Object> runningProps = CollectionsUtil.dictionaryToMap(config.getProperties(), registerdOCD);
                mergedProperties.putAll(runningProps);
            }
            catch (IOException e) {
                logger.info("merge with running failed!");
                throw new KuraException(KuraErrorCode.CONFIGURATION_UPDATE, (Throwable)e, new Object[]{pid});
            }
        }
        mergedProperties.putAll(properties);
        if (!mergedProperties.containsKey("kura.service.pid")) {
            mergedProperties.put("kura.service.pid", pid);
        }
        try {
            this.updateComponentConfiguration(pid, mergedProperties, snapshotOnConfirmation);
            logger.info("Updating Configuration of ConfigurableComponent {} ... Done.", (Object)pid);
        }
        catch (IOException e) {
            logger.warn("Error updating Configuration of ConfigurableComponent with pid {}", (Object)pid, (Object)e);
            throw new KuraException(KuraErrorCode.CONFIGURATION_UPDATE, (Throwable)e, new Object[]{pid});
        }
    }

    private void rollbackConfigurationInternal(String pid, Map<String, Object> properties, boolean snapshotOnConfirmation) throws KuraException {
        logger.debug("Attempting to rollback configuration for {}", (Object)pid);
        if (!this.allActivatedPids.contains(pid)) {
            logger.info("UpdatingConfiguration ignored as ConfigurableComponent {} is NOT tracked.", (Object)pid);
            return;
        }
        if (properties == null) {
            logger.info("UpdatingConfiguration ignored as properties for ConfigurableComponent {} are NULL.", (Object)pid);
            return;
        }
        OCD registerdOCD = this.getRegisteredOCD(pid);
        if (registerdOCD == null) {
            logger.info("UpdatingConfiguration ignored as OCD for pid {} cannot be found.", (Object)pid);
            return;
        }
        HashMap<String, Object> mergedProperties = new HashMap<String, Object>();
        this.mergeWithDefaults(registerdOCD, mergedProperties);
        mergedProperties.putAll(properties);
        if (!mergedProperties.containsKey("kura.service.pid")) {
            mergedProperties.put("kura.service.pid", pid);
        }
        try {
            this.updateComponentConfiguration(pid, mergedProperties, snapshotOnConfirmation);
            logger.info("Updating Configuration of ConfigurableComponent {} ... Done.", (Object)pid);
        }
        catch (IOException e) {
            logger.warn("Error updating Configuration of ConfigurableComponent with pid {}", (Object)pid, (Object)e);
            throw new KuraException(KuraErrorCode.CONFIGURATION_UPDATE, (Throwable)e, new Object[]{pid});
        }
    }

    private void updateComponentConfiguration(String pid, Map<String, Object> mergedProperties, boolean snapshotOnConfirmation) throws KuraException, IOException {
        if (!this.activatedSelfConfigComponents.contains(pid)) {
            BundleContext ctx = this.ctx.getBundleContext();
            ObjectClassDefinition ocd = ComponentUtil.getObjectClassDefinition(ctx, this.servicePidByPid.get(pid));
            this.validateProperties(pid, ocd, mergedProperties);
        }
        Configuration config = this.configurationAdmin.getConfiguration(this.servicePidByPid.get(pid), "?");
        config.update(CollectionsUtil.mapToDictionary(mergedProperties));
        if (snapshotOnConfirmation) {
            this.snapshot();
        }
    }

    private OCD getRegisteredOCD(String pid) {
        ComponentConfiguration config;
        Tocd registeredOCD = this.getOCDForPid(pid);
        if (registeredOCD == null && (config = this.getSelfConfiguringComponentConfiguration(pid)) != null) {
            registeredOCD = config.getDefinition();
        }
        return registeredOCD;
    }

    private void validateProperties(String pid, ObjectClassDefinition ocd, Map<String, Object> updatedProps) throws KuraException {
        if (ocd != null) {
            AttributeDefinition[] defs;
            HashMap<String, AttributeDefinition> attrDefs = new HashMap<String, AttributeDefinition>();
            AttributeDefinition[] attributeDefinitionArray = defs = ocd.getAttributeDefinitions(-1);
            int n = defs.length;
            int n2 = 0;
            while (n2 < n) {
                AttributeDefinition def = attributeDefinitionArray[n2];
                attrDefs.put(def.getID(), def);
                ++n2;
            }
            for (Map.Entry<String, Object> property : updatedProps.entrySet()) {
                String result;
                Object objectValue;
                String stringValue;
                String key = property.getKey();
                AttributeDefinition attrDef = (AttributeDefinition)attrDefs.get(key);
                if (attrDef == null || (stringValue = StringUtil.valueToString(objectValue = property.getValue())) == null || (result = attrDef.validate(stringValue)) == null || result.isEmpty()) continue;
                throw new KuraException(KuraErrorCode.CONFIGURATION_ATTRIBUTE_INVALID, new Object[]{attrDef.getID(), stringValue, result});
            }
            Tocd ocdFull = this.getOCDForPid(pid);
            if (ocdFull != null) {
                for (AD attrDef : ocdFull.getAD()) {
                    if (!attrDef.isRequired() || updatedProps.get(attrDef.getId()) != null) continue;
                    throw new KuraException(KuraErrorCode.CONFIGURATION_REQUIRED_ATTRIBUTE_MISSING, new Object[]{attrDef.getId()});
                }
            }
        }
    }

    private synchronized List<ComponentConfiguration> buildCurrentConfiguration(List<ComponentConfiguration> configsToUpdate) throws KuraException {
        List<ComponentConfiguration> snapshotConfigs;
        ArrayList<ComponentConfiguration> result = new ArrayList<ComponentConfiguration>();
        List<ComponentConfiguration> currentConfigs = this.getComponentConfigurationsInternal();
        if (currentConfigs != null) {
            Iterator<ComponentConfiguration> iterator = currentConfigs.iterator();
            while (iterator.hasNext()) {
                ComponentConfiguration currentConfig;
                ComponentConfiguration cc = currentConfig = iterator.next();
                String pid = currentConfig.getPid();
                if (configsToUpdate != null) {
                    for (ComponentConfiguration configToUpdate : configsToUpdate) {
                        if (!configToUpdate.getPid().equals(pid)) continue;
                        HashMap<String, Object> props = new HashMap<String, Object>();
                        if (currentConfig.getConfigurationProperties() != null) {
                            props.putAll(currentConfig.getConfigurationProperties());
                        }
                        if (configToUpdate.getConfigurationProperties() != null) {
                            props.putAll(configToUpdate.getConfigurationProperties());
                        }
                        cc = new ComponentConfigurationImpl(pid, (Tocd)configToUpdate.getDefinition(), props);
                        break;
                    }
                }
                result.add(cc);
            }
        }
        if ((snapshotConfigs = this.loadLatestSnapshotConfigurations()) != null) {
            for (ComponentConfiguration snapshotConfig : snapshotConfigs) {
                boolean found = false;
                for (ComponentConfiguration config : result) {
                    if (!config.getPid().equals(snapshotConfig.getPid())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                result.add(snapshotConfig);
            }
        }
        block4: for (String deletedPid : this.pendingDeletePids) {
            for (ComponentConfiguration config : result) {
                if (!config.getPid().equals(deletedPid)) continue;
                result.remove(config);
                continue block4;
            }
        }
        for (ComponentConfiguration config : result) {
            ConfigurationUpgrade.upgrade(config, this.bundleContext);
        }
        return result;
    }

    private Tocd getOCDForPid(String pid) {
        Tocd ocd = this.ocds.get(this.factoryPidByPid.get(pid));
        if (ocd == null) {
            ocd = this.ocds.get(pid);
        }
        return ocd;
    }

    private static String makeString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }

    public List<ComponentConfiguration> getFactoryComponentOCDs() {
        return this.factoryPids.stream().map(factory -> {
            String factoryPid = factory.getFactoryPid();
            return new ComponentConfigurationImpl(factoryPid, this.ocds.get(factoryPid), new HashMap<String, Object>());
        }).collect(Collectors.toList());
    }

    private ComponentConfiguration getComponentDefinition(String pid) {
        Tocd ocd = this.ocds.get(pid);
        Map<String, Object> defaultProperties = new HashMap<String, Object>();
        if (ocd != null) {
            try {
                defaultProperties = ComponentUtil.getDefaultProperties(ocd, this.ctx);
            }
            catch (Exception e) {
                logger.warn("Failed to get default properties for component: {}", (Object)pid, (Object)e);
            }
        }
        return new ComponentConfigurationImpl(pid, ocd, defaultProperties);
    }

    public ComponentConfiguration getFactoryComponentOCD(String factoryPid) {
        if (!this.factoryPids.contains(new TrackedComponentFactory(factoryPid, null))) {
            return null;
        }
        return this.getComponentDefinition(factoryPid);
    }

    private static boolean implementsAnyService(ComponentDescriptionDTO component, String[] classes) {
        String[] services = component.serviceInterfaces;
        if (services == null) {
            return false;
        }
        String[] stringArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            String className = stringArray[n2];
            String[] stringArray2 = services;
            int n3 = services.length;
            int n4 = 0;
            while (n4 < n3) {
                String s = stringArray2[n4];
                if (s.equals(className)) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    public List<ComponentConfiguration> getServiceProviderOCDs(String ... classNames) {
        return this.scrService.getComponentDescriptionDTOs(new Bundle[0]).stream().filter(component -> ConfigurationServiceImpl.implementsAnyService(component, classNames)).map(c -> c.name).map(this::getComponentDefinition).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<ComponentConfiguration> getServiceProviderOCDs(Class<?> ... classes) {
        String[] classNames = new String[classes.length];
        int i = 0;
        while (i < classes.length) {
            classNames[i] = classes[i].getName();
            ++i;
        }
        return this.getServiceProviderOCDs(classNames);
    }

    protected <T> T unmarshal(String string, Class<T> clazz) throws KuraException {
        try {
            return (T)Objects.requireNonNull(this.xmlUnmarshaller.unmarshal(string, clazz));
        }
        catch (Exception e) {
            throw new KuraException(KuraErrorCode.DECODER_ERROR, new Object[]{"configuration", e});
        }
    }

    protected String marshal(Object object) throws KuraException {
        try {
            return Objects.requireNonNull(this.xmlMarshaller.marshal(object));
        }
        catch (Exception e) {
            throw new KuraException(KuraErrorCode.ENCODE_ERROR, new Object[]{"configuration", e});
        }
    }

    private static final class TrackedComponentFactory {
        private final String factoryPid;
        private final Bundle provider;

        public TrackedComponentFactory(String factoryPid, Bundle provider) {
            this.factoryPid = factoryPid;
            this.provider = provider;
        }

        public String getFactoryPid() {
            return this.factoryPid;
        }

        public Bundle getProviderBundle() {
            return this.provider;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.factoryPid == null ? 0 : this.factoryPid.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TrackedComponentFactory other = (TrackedComponentFactory)obj;
            return !(this.factoryPid == null ? other.factoryPid != null : !this.factoryPid.equals(other.factoryPid));
        }
    }
}

