/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.mtoolkit.iagent.transport;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.tigris.mtoolkit.iagent.transport.Transport;
import org.tigris.mtoolkit.iagent.transport.TransportType;
import org.tigris.mtoolkit.iagent.util.LightServiceRegistry;

public class TransportsHub {
    private static final String TRANSPORTS_REGISTRY_FILE = "transports.properties";
    private static LightServiceRegistry transportsRegistry;
    static /* synthetic */ Class class$0;

    public static Transport openTransport(String type, String id) throws IOException {
        TransportType transportType = TransportsHub.getType(type);
        return transportType.openTransport(id);
    }

    public static List listTypes() {
        Object[] services = TransportsHub.getServiceRegistry().getAllServices();
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        while (i < services.length) {
            if (services[i] instanceof TransportType) {
                result.add(services[i]);
            }
            ++i;
        }
        return result;
    }

    public static TransportType getType(String type) {
        Object extender = TransportsHub.getServiceRegistry().get(type);
        if (extender instanceof TransportType) {
            return (TransportType)extender;
        }
        throw new IllegalArgumentException("unable to find transport type " + type);
    }

    private static LightServiceRegistry getServiceRegistry() {
        if (transportsRegistry == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.tigris.mtoolkit.iagent.transport.TransportsHub");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            transportsRegistry = new LightServiceRegistry(TRANSPORTS_REGISTRY_FILE, clazz.getClassLoader());
        }
        return transportsRegistry;
    }
}

