/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.net.status.modem;

import java.util.Objects;
import java.util.Set;
import org.eclipse.kura.net.status.modem.BearerIpType;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class Bearer {
    private final String name;
    private final boolean connected;
    private final String apn;
    private final Set<BearerIpType> ipTypes;
    private final long bytesTransmitted;
    private final long bytesReceived;

    public Bearer(String name, boolean connected, String apn, Set<BearerIpType> ipTypes, long bytesTransmitted, long bytesReceived) {
        this.name = name;
        this.connected = connected;
        this.apn = apn;
        this.ipTypes = ipTypes;
        this.bytesTransmitted = bytesTransmitted;
        this.bytesReceived = bytesReceived;
    }

    public String getName() {
        return this.name;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public String getApn() {
        return this.apn;
    }

    public Set<BearerIpType> getIpTypes() {
        return this.ipTypes;
    }

    public long getBytesTransmitted() {
        return this.bytesTransmitted;
    }

    public long getBytesReceived() {
        return this.bytesReceived;
    }

    public int hashCode() {
        return Objects.hash(this.apn, this.bytesReceived, this.bytesTransmitted, this.connected, this.ipTypes, this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Bearer other = (Bearer)obj;
        return Objects.equals(this.apn, other.apn) && this.bytesReceived == other.bytesReceived && this.bytesTransmitted == other.bytesTransmitted && this.connected == other.connected && Objects.equals(this.ipTypes, other.ipTypes) && Objects.equals(this.name, other.name);
    }
}

