/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.system;

import org.eclipse.kura.annotation.Immutable;
import org.eclipse.kura.annotation.ThreadSafe;
import org.eclipse.kura.system.SystemResourceType;
import org.osgi.annotation.versioning.ProviderType;

@Immutable
@ThreadSafe
@ProviderType
public class SystemResourceInfo {
    private final String name;
    private final String version;
    private final SystemResourceType type;

    public SystemResourceInfo(String name) {
        this(name, "Unknown", SystemResourceType.UNKNOWN);
    }

    public SystemResourceInfo(String name, String version, String type) {
        this(name, version, SystemResourceType.valueOf(type));
    }

    public SystemResourceInfo(String name, String version, SystemResourceType type) {
        this.name = name;
        this.version = version;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public SystemResourceType getType() {
        return this.type;
    }

    public String getTypeString() {
        return this.type.toString();
    }
}

