/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin;

import java.util.StringTokenizer;
import java.util.jar.Attributes;
import org.apache.felix.deploymentadmin.AbstractInfo;
import org.osgi.framework.Version;
import org.osgi.service.deploymentadmin.BundleInfo;
import org.osgi.service.deploymentadmin.DeploymentException;

public class BundleInfoImpl
extends AbstractInfo
implements BundleInfo {
    private final Version m_version;
    private final String m_symbolicName;
    private final boolean m_customizer;

    public BundleInfoImpl(String path, Attributes attributes) throws DeploymentException {
        super(path, attributes);
        String bundleSymbolicName = attributes.getValue("Bundle-SymbolicName");
        if (bundleSymbolicName == null) {
            throw new DeploymentException(451, "Missing 'Bundle-SymbolicName' header for manifest entry '" + this.getPath() + "'");
        }
        if (bundleSymbolicName.trim().equals("")) {
            throw new DeploymentException(452, "Invalid 'Bundle-SymbolicName' header for manifest entry '" + this.getPath() + "'");
        }
        this.m_symbolicName = this.parseSymbolicName(bundleSymbolicName);
        String version = attributes.getValue("Bundle-Version");
        if (version == null || version == "") {
            throw new DeploymentException(452, "Invalid 'Bundle-Version' header for manifest entry '" + this.getPath() + "'");
        }
        try {
            this.m_version = Version.parseVersion((String)version);
        }
        catch (IllegalArgumentException e) {
            throw new DeploymentException(452, "Invalid 'Bundle-Version' header for manifest entry '" + this.getPath() + "'");
        }
        this.m_customizer = this.parseBooleanHeader(attributes, "DeploymentPackage-Customizer");
    }

    private String parseSymbolicName(String name) {
        StringTokenizer st = new StringTokenizer(name, ";");
        return st.nextToken();
    }

    public String getSymbolicName() {
        return this.m_symbolicName;
    }

    public Version getVersion() {
        return this.m_version;
    }

    public boolean isCustomizer() {
        return this.m_customizer;
    }

    public static boolean isBundleResource(Attributes attributes) {
        return attributes.getValue("Bundle-SymbolicName") != null;
    }
}

