/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.useradmin.store;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Consumer;
import org.eclipse.kura.internal.useradmin.store.DeserializationException;
import org.osgi.service.useradmin.Group;
import org.osgi.service.useradmin.Role;
import org.osgi.service.useradmin.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RoleSerializer {
    private static final Logger logger = LoggerFactory.getLogger(RoleSerializer.class);
    private static final String NAME = "name";
    private static final String ROLE_PROPERTIES = "properties";
    private static final String USER_CREDENTIALS = "credentials";
    private static final String GROUP_BASIC_MEMBERS = "basicMembers";
    private static final String GROUP_REQUIRED_MEMBERS = "requiredMembers";

    private RoleSerializer() {
    }

    private static JsonArray serializeByteArray(byte[] value) {
        JsonArray result = new JsonArray();
        byte[] byArray = value;
        int n = value.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            result.add((int)b);
            ++n2;
        }
        return result;
    }

    private static JsonArray serializeRoleNames(Role[] roles) {
        JsonArray result = new JsonArray();
        if (roles == null) {
            return result;
        }
        TreeSet<Role> sorted = new TreeSet<Role>(Comparator.comparing(Role::getName));
        sorted.addAll(Arrays.asList(roles));
        for (Role r : sorted) {
            result.add(r.getName());
        }
        return result;
    }

    static JsonObject serializeProperties(Dictionary properties) {
        JsonObject result = new JsonObject();
        TreeMap sorted = new TreeMap();
        Enumeration keys = properties.keys();
        while (keys.hasMoreElements()) {
            Object next = keys.nextElement();
            if (!(next instanceof String)) {
                logger.warn("unsupported property key: {}", next);
                continue;
            }
            String key = (String)next;
            sorted.put(key, properties.get(key));
        }
        for (Map.Entry e : sorted.entrySet()) {
            String key = (String)e.getKey();
            Object value = e.getValue();
            if (value instanceof String) {
                result.add(key, (String)value);
                continue;
            }
            if (value instanceof byte[]) {
                result.add(key, (JsonValue)RoleSerializer.serializeByteArray((byte[])value));
                continue;
            }
            logger.warn("unsupported property value: {}", value);
        }
        return result;
    }

    static JsonObject serializeRole(Role role) {
        User asUser;
        JsonObject result = new JsonObject();
        result.add(NAME, role.getName());
        if (role instanceof User && !(asUser = (User)role).getCredentials().isEmpty()) {
            result.add(USER_CREDENTIALS, (JsonValue)RoleSerializer.serializeProperties(asUser.getCredentials()));
        }
        if (role instanceof Group) {
            Group asGroup = (Group)role;
            if (asGroup.getMembers() != null) {
                result.add(GROUP_BASIC_MEMBERS, (JsonValue)RoleSerializer.serializeRoleNames(asGroup.getMembers()));
            }
            if (asGroup.getRequiredMembers() != null) {
                result.add(GROUP_REQUIRED_MEMBERS, (JsonValue)RoleSerializer.serializeRoleNames(asGroup.getRequiredMembers()));
            }
        }
        if (!role.getProperties().isEmpty()) {
            result.add(ROLE_PROPERTIES, (JsonValue)RoleSerializer.serializeProperties(role.getProperties()));
        }
        return result;
    }

    private static byte[] deserializeByteArray(JsonArray array) {
        byte[] result = new byte[array.size()];
        int i = 0;
        while (i < array.size()) {
            result[i] = (byte)array.get(i).asInt();
            ++i;
        }
        return result;
    }

    private static void deserializeProperties(JsonObject properties, Dictionary target) {
        for (JsonObject.Member member : properties) {
            JsonValue value = member.getValue();
            if (value.isString()) {
                target.put(member.getName(), value.asString());
                continue;
            }
            if (!value.isArray()) continue;
            target.put(member.getName(), RoleSerializer.deserializeByteArray(value.asArray()));
        }
    }

    static <T extends Role> T deserializeRole(Class<T> classz, JsonObject object, RoleBuilder roleBuilder) throws DeserializationException {
        try {
            int type;
            if (classz == Role.class) {
                type = 0;
            } else if (classz == User.class) {
                type = 1;
            } else if (classz == Group.class) {
                type = 2;
            } else {
                throw new IllegalArgumentException("Unsupported role type");
            }
            String name = object.get(NAME).asString();
            Role result = roleBuilder.build(type, name);
            JsonValue roleProperties = object.get(ROLE_PROPERTIES);
            if (roleProperties != null) {
                RoleSerializer.deserializeProperties(roleProperties.asObject(), result.getProperties());
            }
            if (result instanceof User) {
                User asUser = (User)result;
                JsonValue userCredentials = object.get(USER_CREDENTIALS);
                if (userCredentials != null) {
                    RoleSerializer.deserializeProperties(userCredentials.asObject(), asUser.getCredentials());
                }
            }
            return (T)result;
        }
        catch (Exception e) {
            throw new DeserializationException("failed to deserialize role", e);
        }
    }

    private static void assignMembers(JsonArray members, Map<String, Role> roles, Consumer<Role> consumer) {
        for (JsonValue value : members.asArray()) {
            String roleName = value.asString();
            Role member = roles.get(value.asString());
            if (member == null) {
                logger.warn("Role {} cannot be found", (Object)roleName);
                continue;
            }
            consumer.accept(member);
        }
    }

    static void assignMembers(JsonObject object, Map<String, Role> roles) throws DeserializationException {
        try {
            JsonValue requiredMembers;
            String name = object.get(NAME).asString();
            Role role = roles.get(name);
            if (!(role instanceof Group)) {
                return;
            }
            Group asGroup = (Group)role;
            JsonValue basicMembers = object.get(GROUP_BASIC_MEMBERS);
            if (basicMembers != null) {
                RoleSerializer.assignMembers(basicMembers.asArray(), roles, arg_0 -> ((Group)asGroup).addMember(arg_0));
            }
            if ((requiredMembers = object.get(GROUP_REQUIRED_MEMBERS)) != null) {
                RoleSerializer.assignMembers(requiredMembers.asArray(), roles, arg_0 -> ((Group)asGroup).addRequiredMember(arg_0));
            }
        }
        catch (Exception e) {
            throw new DeserializationException("failed to deserialize role", e);
        }
    }

    public static interface RoleBuilder {
        public Role build(int var1, String var2);
    }
}

