/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.inject;

import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import org.glassfish.hk2.api.Factory;
import org.glassfish.jersey.server.internal.inject.ParamInjectionResolver;
import org.glassfish.jersey.server.internal.process.AsyncContext;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.spi.internal.ValueFactoryProvider;

final class AsyncResponseValueFactoryProvider
implements ValueFactoryProvider {
    private final Provider<AsyncContext> asyncContextProvider;

    @Inject
    public AsyncResponseValueFactoryProvider(Provider<AsyncContext> asyncContextProvider) {
        this.asyncContextProvider = asyncContextProvider;
    }

    @Override
    public Factory<?> getValueFactory(Parameter parameter) {
        if (parameter.getSource() != Parameter.Source.SUSPENDED) {
            return null;
        }
        if (!AsyncResponse.class.isAssignableFrom(parameter.getRawType())) {
            return null;
        }
        return new Factory<AsyncResponse>(){

            @Override
            public AsyncResponse provide() {
                return (AsyncResponse)AsyncResponseValueFactoryProvider.this.asyncContextProvider.get();
            }

            @Override
            public void dispose(AsyncResponse instance) {
            }
        };
    }

    @Override
    public ValueFactoryProvider.PriorityType getPriority() {
        return ValueFactoryProvider.Priority.NORMAL;
    }

    static final class InjectionResolver
    extends ParamInjectionResolver<Suspended> {
        public InjectionResolver() {
            super(AsyncResponseValueFactoryProvider.class);
        }
    }
}

