/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.rest.service.listing.provider.util;

import java.util.function.Consumer;

public class FilterBuilder {
    private final StringBuilder stringBuilder = new StringBuilder();

    public FilterBuilder property(String name, String value) {
        String escapedValue = value != null ? this.escapeValue(value) : "*";
        this.stringBuilder.append("(").append(name).append("=").append(escapedValue).append(")");
        return this;
    }

    public FilterBuilder and(Consumer<FilterBuilder> consumer) {
        return this.op("&", consumer);
    }

    public FilterBuilder or(Consumer<FilterBuilder> consumer) {
        return this.op("|", consumer);
    }

    public FilterBuilder not(Consumer<FilterBuilder> consumer) {
        return this.op("!", consumer);
    }

    private FilterBuilder op(String operator, Consumer<FilterBuilder> consumer) {
        this.stringBuilder.append("(");
        this.stringBuilder.append(operator);
        consumer.accept(this);
        this.stringBuilder.append(")");
        return this;
    }

    private String escapeValue(String value) {
        return value.replace("(", "\\(").replace(")", "\\)").replace("*", "\\*");
    }

    public String build() {
        return this.stringBuilder.toString();
    }
}

