/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.certificates;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;

final class KeyStoreManagement {
    private static final String ENV_JAVA_KEYSTORE = String.valueOf(System.getenv("JAVA_HOME")) + "/jre/lib/security/cacerts";

    private KeyStoreManagement() {
    }

    static KeyStore loadKeyStore(byte[] password) throws NoSuchAlgorithmException, CertificateException, KeyStoreException, IOException {
        return KeyStoreManagement.loadKeyStore(new String(password).toCharArray());
    }

    static void saveKeyStore(KeyStore keystore, byte[] password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStoreManagement.saveKeyStore(keystore, new String(password).toCharArray());
    }

    static KeyStore loadKeyStore(char[] password) throws NoSuchAlgorithmException, CertificateException, KeyStoreException, IOException {
        return KeyStoreManagement.loadKeyStore(ENV_JAVA_KEYSTORE, new String(password).toCharArray());
    }

    static void saveKeyStore(KeyStore keystore, char[] password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStoreManagement.saveKeyStore(keystore, ENV_JAVA_KEYSTORE, new String(password).toCharArray());
    }

    static void saveKeyStore(String keystorePath, KeyStore keystore, char[] password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStoreManagement.saveKeyStore(keystore, keystorePath, new String(password).toCharArray());
    }

    static KeyStore loadKeyStore(String location, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException, KeyStoreException {
        try (FileInputStream is = null;){
            is = new FileInputStream(location);
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            keystore.load(is, password);
            is.close();
            KeyStore keyStore = keystore;
            return keyStore;
        }
    }

    static void saveKeyStore(KeyStore keystore, String location, char[] password) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(location);
            keystore.store(fos, password);
            fos.flush();
            fos.close();
        }
    }
}

