/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.crypto;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.eclipse.kura.KuraException;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface CryptoService {
    public char[] encryptAes(char[] var1) throws KuraException;

    public char[] decryptAes(char[] var1) throws KuraException;

    @Deprecated
    public String encryptAes(String var1) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException;

    @Deprecated
    public String decryptAes(String var1) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IOException, IllegalBlockSizeException, BadPaddingException;

    default public String sha1Hash(String s) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        return this.hash(s, "SHA-1");
    }

    default public String sha256Hash(String s) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        return this.hash(s, "SHA-256");
    }

    public String hash(String var1, String var2) throws NoSuchAlgorithmException, UnsupportedEncodingException;

    public String encodeBase64(String var1) throws NoSuchAlgorithmException, UnsupportedEncodingException;

    public String decodeBase64(String var1) throws NoSuchAlgorithmException, UnsupportedEncodingException;

    public char[] getKeyStorePassword(String var1);

    public void setKeyStorePassword(String var1, char[] var2) throws KuraException;

    @Deprecated
    public void setKeyStorePassword(String var1, String var2) throws IOException;

    public boolean isFrameworkSecure();
}

