/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.util.wire.store;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.kura.KuraStoreException;
import org.eclipse.kura.type.TypedValue;
import org.eclipse.kura.type.TypedValues;
import org.eclipse.kura.util.jdbc.ConnectionProvider;
import org.eclipse.kura.wire.WireRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJdbcQueryableWireRecordStoreImpl {
    private static final Logger logger = LoggerFactory.getLogger(AbstractJdbcQueryableWireRecordStoreImpl.class);
    private final ConnectionProvider provider;

    protected AbstractJdbcQueryableWireRecordStoreImpl(ConnectionProvider provider) {
        this.provider = Objects.requireNonNull(provider, "Connection provider cannot be null");
    }

    protected abstract Optional<Object> extractColumnValue(ResultSet var1, ResultSetMetaData var2, int var3) throws SQLException;

    public List<WireRecord> performQuery(String query) throws KuraStoreException {
        try {
            return this.provider.withConnection(c -> {
                Throwable throwable = null;
                Object var4_5 = null;
                try {
                    ArrayList<WireRecord> arrayList;
                    ResultSet rset;
                    Statement stmt;
                    block17: {
                        block16: {
                            stmt = c.createStatement();
                            rset = stmt.executeQuery(query);
                            ArrayList<WireRecord> dataRecords = new ArrayList<WireRecord>();
                            while (rset.next()) {
                                WireRecord wireRecord = new WireRecord(this.convertSQLRowToWireRecord(rset));
                                dataRecords.add(wireRecord);
                            }
                            arrayList = dataRecords;
                            if (rset == null) break block16;
                            rset.close();
                        }
                        if (stmt == null) break block17;
                        stmt.close();
                    }
                    return arrayList;
                    {
                        catch (Throwable throwable2) {
                            try {
                                if (rset != null) {
                                    rset.close();
                                }
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                if (stmt != null) {
                                    stmt.close();
                                }
                                throw throwable;
                            }
                        }
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            });
        }
        catch (Exception e) {
            throw new KuraStoreException((Throwable)e, null);
        }
    }

    protected Map<String, TypedValue<?>> convertSQLRowToWireRecord(ResultSet rset) throws SQLException {
        HashMap wireRecordProperties = new HashMap();
        ResultSetMetaData rmet = rset.getMetaData();
        int columnIndex = 1;
        while (columnIndex <= rmet.getColumnCount()) {
            Optional<Object> dbExtractedData;
            String fieldName = rmet.getColumnLabel(columnIndex);
            if (Objects.isNull(fieldName)) {
                fieldName = this.getWireRecordPropertyName(rmet, columnIndex);
            }
            if ((dbExtractedData = this.extractColumnValue(rset, rmet, columnIndex)).isPresent()) {
                try {
                    TypedValue value = TypedValues.newTypedValue((Object)dbExtractedData.get());
                    wireRecordProperties.put(fieldName, value);
                }
                catch (Exception e) {
                    this.handleConversionException(rmet, columnIndex, fieldName, dbExtractedData.get(), e);
                }
            }
            ++columnIndex;
        }
        return wireRecordProperties;
    }

    protected String getWireRecordPropertyName(ResultSetMetaData resultSetMetaData, int columnIndex) throws SQLException {
        return resultSetMetaData.getColumnName(columnIndex);
    }

    protected void handleConversionException(ResultSetMetaData rmet, int columnIndex, String fieldName, Object dbExtractedData, Exception e) throws SQLException {
        logger.error("Failed to convert result for column {} (SQL type {}, Java type {}) to any of the supported Wires data type, please consider using a conversion function like CAST in your query. The result for this column will not be included in emitted envelope", new Object[]{fieldName, rmet.getColumnTypeName(columnIndex), dbExtractedData.getClass().getName(), e});
    }
}

