/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.broker;

import io.moquette.broker.NettyUtils;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.EventExecutor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoFlushHandler
extends ChannelDuplexHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AutoFlushHandler.class);
    private static final long MIN_TIMEOUT_NANOS = TimeUnit.MILLISECONDS.toNanos(1L);
    private final long writerIdleTimeNanos;
    volatile ScheduledFuture<?> writerIdleTimeout;
    volatile long lastWriteTime;
    private volatile int state;

    public AutoFlushHandler(long writerIdleTime, TimeUnit unit) {
        if (unit == null) {
            throw new NullPointerException("unit");
        }
        this.writerIdleTimeNanos = Math.max(unit.toNanos(writerIdleTime), MIN_TIMEOUT_NANOS);
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        if (ctx.channel().isActive() && ctx.channel().isRegistered()) {
            this.initialize(ctx);
        }
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) {
        this.destroy();
    }

    @Override
    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        super.channelRegistered(ctx);
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.destroy();
        super.channelInactive(ctx);
    }

    private void initialize(ChannelHandlerContext ctx) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initializing autoflush handler on channel {} Cid: {}", (Object)ctx.channel(), (Object)NettyUtils.clientID(ctx.channel()));
        }
        switch (this.state) {
            case 1: 
            case 2: {
                return;
            }
        }
        this.state = 1;
        EventExecutor loop = ctx.executor();
        this.lastWriteTime = System.nanoTime();
        this.writerIdleTimeout = loop.schedule(new WriterIdleTimeoutTask(ctx), this.writerIdleTimeNanos, TimeUnit.NANOSECONDS);
    }

    private void destroy() {
        this.state = 2;
        if (this.writerIdleTimeout != null) {
            this.writerIdleTimeout.cancel(false);
            this.writerIdleTimeout = null;
        }
    }

    private void channelIdle(ChannelHandlerContext ctx) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Flushing idle Netty channel {} Cid: {}", (Object)ctx.channel(), (Object)NettyUtils.clientID(ctx.channel()));
        }
        ctx.channel().flush();
    }

    private final class WriterIdleTimeoutTask
    implements Runnable {
        private final ChannelHandlerContext ctx;

        WriterIdleTimeoutTask(ChannelHandlerContext ctx) {
            this.ctx = ctx;
        }

        @Override
        public void run() {
            if (!this.ctx.channel().isOpen()) {
                return;
            }
            long nextDelay = AutoFlushHandler.this.writerIdleTimeNanos - (System.nanoTime() - AutoFlushHandler.this.lastWriteTime);
            if (nextDelay <= 0L) {
                AutoFlushHandler.this.writerIdleTimeout = this.ctx.executor().schedule(this, AutoFlushHandler.this.writerIdleTimeNanos, TimeUnit.NANOSECONDS);
                try {
                    AutoFlushHandler.this.channelIdle(this.ctx);
                }
                catch (Throwable t) {
                    this.ctx.fireExceptionCaught(t);
                }
            } else {
                AutoFlushHandler.this.writerIdleTimeout = this.ctx.executor().schedule(this, nextDelay, TimeUnit.NANOSECONDS);
            }
        }
    }
}

