/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.wire.db.store;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.db.BaseDbService;
import org.eclipse.kura.db.H2DbService;
import org.eclipse.kura.internal.wire.db.common.BaseDbServiceProviderImpl;
import org.eclipse.kura.internal.wire.db.common.DbServiceProvider;
import org.eclipse.kura.internal.wire.db.common.H2DbServiceProviderImpl;
import org.eclipse.kura.internal.wire.db.store.DbWireRecordStoreOptions;
import org.eclipse.kura.wire.WireComponent;
import org.eclipse.kura.wire.WireEmitter;
import org.eclipse.kura.wire.WireEnvelope;
import org.eclipse.kura.wire.WireHelperService;
import org.eclipse.kura.wire.WireReceiver;
import org.eclipse.kura.wire.WireRecord;
import org.eclipse.kura.wire.WireSupport;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.wireadmin.Wire;

public class DbWireRecordStore
implements WireEmitter,
WireReceiver,
ConfigurableComponent {
    private static final Logger logger = LogManager.getLogger(DbWireRecordStore.class);
    private static final String NULL_TABLE_NAME_ERROR_MSG = "Table name cannot be null";
    private static final String NULL_WIRE_RECORD_ERROR_MSG = "WireRecord cannot be null";
    private DbServiceProvider dbServiceProvider;
    private BaseDbService dbService;
    private DbWireRecordStoreOptions wireRecordStoreOptions;
    private WireHelperService wireHelperService;
    private WireSupport wireSupport;

    public synchronized void bindDbService(BaseDbService dbService) {
        this.dbService = dbService;
        this.dbServiceProvider = this.dbService instanceof H2DbService ? new H2DbServiceProviderImpl((H2DbService)this.dbService) : new BaseDbServiceProviderImpl(this.dbService);
        if (Objects.nonNull(this.dbService) && Objects.nonNull(this.wireRecordStoreOptions)) {
            this.reconcileDB(this.wireRecordStoreOptions.getTableName());
        }
    }

    public synchronized void unbindDbService(BaseDbService dbService) {
        if (this.dbService == dbService) {
            this.dbServiceProvider = null;
            this.dbService = null;
            this.wireRecordStoreOptions = null;
        }
    }

    public void bindWireHelperService(WireHelperService wireHelperService) {
        if (Objects.isNull(this.wireHelperService)) {
            this.wireHelperService = wireHelperService;
        }
    }

    public void unbindWireHelperService(WireHelperService wireHelperService) {
        if (this.wireHelperService == wireHelperService) {
            this.wireHelperService = null;
        }
    }

    protected void activate(ComponentContext componentContext, Map<String, Object> properties) {
        logger.debug("Activating DB Wire Record Store...");
        this.wireRecordStoreOptions = new DbWireRecordStoreOptions(properties);
        this.wireSupport = this.wireHelperService.newWireSupport((WireComponent)this, componentContext.getServiceReference());
        if (Objects.nonNull(this.dbService)) {
            this.reconcileDB(this.wireRecordStoreOptions.getTableName());
        }
        logger.debug("Activating DB Wire Record Store... Done");
    }

    public synchronized void updated(Map<String, Object> properties) {
        logger.debug("Updating DB Wire Record Store...");
        this.wireRecordStoreOptions = new DbWireRecordStoreOptions(properties);
        this.reconcileDB(this.wireRecordStoreOptions.getTableName());
        logger.debug("Updating DB Wire Record Store... Done");
    }

    protected void deactivate(ComponentContext componentContext) {
        logger.debug("Deactivating DB Wire Record Store...");
        this.dbServiceProvider = null;
        this.dbService = null;
        this.wireRecordStoreOptions = null;
        logger.debug("Deactivating DB Wire Record Store... Done");
    }

    private void truncate() {
        this.truncate(this.wireRecordStoreOptions.getNoOfRecordsToKeep());
    }

    private void truncate(int noOfRecordsToKeep) {
        String tableName = this.wireRecordStoreOptions.getTableName();
        int maxTableSize = this.wireRecordStoreOptions.getMaximumTableSize();
        try {
            this.dbServiceProvider.truncate(noOfRecordsToKeep, tableName, maxTableSize);
        }
        catch (SQLException sqlException) {
            logger.error("Error in truncating the table {}...", (Object)tableName, (Object)sqlException);
        }
    }

    private int getTableSize() throws SQLException {
        String tableName = this.wireRecordStoreOptions.getTableName();
        return this.dbServiceProvider.getTableSize(tableName);
    }

    public void consumersConnected(Wire[] wires) {
        this.wireSupport.consumersConnected(wires);
    }

    public synchronized void onWireReceive(WireEnvelope wireEvelope) {
        Objects.requireNonNull(wireEvelope, "Wire Envelope cannot be null");
        List records = wireEvelope.getRecords();
        if (this.dbServiceProvider == null) {
            logger.warn("DbService instance not attached");
            return;
        }
        try {
            if (this.getTableSize() >= this.wireRecordStoreOptions.getMaximumTableSize()) {
                this.truncate();
            }
        }
        catch (SQLException sQLException) {
            logger.warn("Exception while trying to clean db");
        }
        for (WireRecord wireRecord : records) {
            this.store(wireRecord);
        }
        this.wireSupport.emit(records);
    }

    private void store(WireRecord wireRecord) {
        Objects.requireNonNull(wireRecord, NULL_WIRE_RECORD_ERROR_MSG);
        int retryCount = 0;
        String tableName = this.wireRecordStoreOptions.getTableName();
        while (true) {
            try {
                this.insertDataRecord(tableName, wireRecord);
            }
            catch (SQLException e) {
                logger.error("Insertion failed. Reconciling Table and Columns...", (Throwable)e);
                this.reconcileDB(wireRecord, tableName);
                if (++retryCount < 2) continue;
            }
            break;
        }
    }

    private void reconcileDB(WireRecord wireRecord, String tableName) {
        try {
            if (Objects.nonNull(tableName) && !tableName.isEmpty()) {
                this.reconcileTable(tableName);
                this.reconcileColumns(tableName, wireRecord);
            }
        }
        catch (SQLException ee) {
            logger.error("Error while storing Wire Records...", (Throwable)ee);
        }
    }

    private synchronized void reconcileDB(String tableName) {
        try {
            if (Objects.nonNull(this.dbServiceProvider) && Objects.nonNull(tableName) && !tableName.isEmpty()) {
                this.reconcileTable(tableName);
            }
        }
        catch (SQLException ee) {
            logger.error("Error while storing Wire Records...", (Throwable)ee);
        }
    }

    private void reconcileTable(String tableName) throws SQLException {
        Objects.requireNonNull(tableName, NULL_TABLE_NAME_ERROR_MSG);
        this.dbServiceProvider.reconcileTable(tableName);
    }

    private void reconcileColumns(String tableName, WireRecord wireRecord) throws SQLException {
        Objects.requireNonNull(tableName, NULL_TABLE_NAME_ERROR_MSG);
        Objects.requireNonNull(wireRecord, NULL_WIRE_RECORD_ERROR_MSG);
        this.dbServiceProvider.reconcileColumns(tableName, wireRecord);
    }

    private void insertDataRecord(String tableName, WireRecord wireRecord) throws SQLException {
        Objects.requireNonNull(tableName, NULL_TABLE_NAME_ERROR_MSG);
        Objects.requireNonNull(wireRecord, NULL_WIRE_RECORD_ERROR_MSG);
        this.dbServiceProvider.insertDataRecord(tableName, wireRecord);
    }

    public Object polled(Wire wire) {
        return this.wireSupport.polled(wire);
    }

    public void producersConnected(Wire[] wires) {
        this.wireSupport.producersConnected(wires);
    }

    public void updated(Wire wire, Object value) {
        this.wireSupport.updated(wire, value);
    }
}

