/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.linux.bluetooth.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import org.eclipse.kura.bluetooth.BluetoothGatt;
import org.eclipse.kura.executor.Command;
import org.eclipse.kura.executor.CommandExecutorService;
import org.eclipse.kura.executor.CommandStatus;
import org.eclipse.kura.linux.bluetooth.le.beacon.BTSnoopParser;
import org.eclipse.kura.linux.bluetooth.util.BTSnoopListener;
import org.eclipse.kura.linux.bluetooth.util.BluetoothProcessListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class BluetoothProcess {
    private static final String END_OF_STREAM_MESSAGE = "End of stream!";
    private static final String INPUT_STREAM_MESSAGE = "Error in processing the input stream : ";
    private static final String ERROR_STREAM_MESSAGE = "Error in processing the error stream : ";
    private static final Logger logger = LoggerFactory.getLogger(BluetoothProcess.class);
    private static final ExecutorService STREAM_GOBBLERS = Executors.newCachedThreadPool();
    private Future<?> futureInputGobbler;
    private Future<?> futureErrorGobbler;
    private BufferedWriter bufferedWriter;
    private final PipedInputStream readOutputStream = new PipedInputStream();
    private final PipedInputStream readErrorStream = new PipedInputStream();
    private final PipedOutputStream writeInputStream = new PipedOutputStream();
    private final PipedOutputStream outputStream = new PipedOutputStream();
    private final PipedOutputStream errorStream = new PipedOutputStream();
    private final PipedInputStream inputStream = new PipedInputStream();
    private BTSnoopParser parser;
    private boolean btSnoopReady;
    private final CommandExecutorService executorService;

    public BluetoothProcess(CommandExecutorService executorService) {
        this.executorService = executorService;
        try {
            this.outputStream.connect(this.readOutputStream);
            this.errorStream.connect(this.readErrorStream);
            this.inputStream.connect(this.writeInputStream);
            this.bufferedWriter = new BufferedWriter(new OutputStreamWriter(this.writeInputStream));
        }
        catch (IOException e) {
            logger.error("Failed to connect streams", (Throwable)e);
        }
    }

    public BufferedWriter getWriter() {
        return this.bufferedWriter;
    }

    void exec(String[] cmdArray, BluetoothProcessListener listener) {
        if (logger.isDebugEnabled()) {
            logger.debug("Executing: {}", (Object)Arrays.toString(cmdArray));
        }
        Consumer<CommandStatus> callback = status -> logger.debug("Command ended with exit value {}", (Object)status.getExitStatus().getExitCode());
        Command command = new Command(cmdArray);
        command.setOutputStream((OutputStream)this.outputStream);
        command.setErrorStream((OutputStream)this.errorStream);
        command.setInputStream((InputStream)this.inputStream);
        this.executorService.execute(command, callback);
        this.futureInputGobbler = STREAM_GOBBLERS.submit(() -> {
            Thread.currentThread().setName("BluetoothProcess Input Stream Gobbler");
            this.readInputStreamFully(this.readOutputStream, listener);
        });
        this.futureErrorGobbler = STREAM_GOBBLERS.submit(() -> {
            Thread.currentThread().setName("BluetoothProcess ErrorStream Gobbler");
            this.readErrorStreamFully(this.readErrorStream, listener);
        });
    }

    void execSnoop(String[] cmdArray, BTSnoopListener listener) {
        this.btSnoopReady = true;
        if (this.parser == null) {
            this.parser = new BTSnoopParser();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Executing: {}", (Object)Arrays.toString(cmdArray));
        }
        Consumer<CommandStatus> callback = status -> logger.debug("Command ended with exit value {}", (Object)status.getExitStatus().getExitCode());
        Command command = new Command(cmdArray);
        command.setOutputStream((OutputStream)this.outputStream);
        command.setErrorStream((OutputStream)this.errorStream);
        this.executorService.execute(command, callback);
        this.futureInputGobbler = STREAM_GOBBLERS.submit(() -> {
            Thread.currentThread().setName("BluetoothProcess BTSnoop Gobbler");
            this.readBTSnoopStreamFully(this.readOutputStream, listener);
        });
        this.futureErrorGobbler = STREAM_GOBBLERS.submit(() -> {
            Thread.currentThread().setName("BluetoothProcess BTSnoop ErrorStream Gobbler");
            this.readBTErrorStreamFully(this.readErrorStream, listener);
        });
    }

    public void destroy() {
        this.closeStreams();
    }

    public void destroyBTSnoop() {
        this.btSnoopReady = false;
        this.closeStreams();
    }

    private void readInputStreamFully(InputStream is, BluetoothProcessListener listener) {
        if (listener instanceof BluetoothGatt) {
            try {
                Throwable throwable = null;
                Object var6_7 = null;
                try (BufferedReader br = new BufferedReader(new InputStreamReader(is));){
                    int ch;
                    while ((ch = br.read()) != -1) {
                        listener.processInputStream((char)ch);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                logger.warn(INPUT_STREAM_MESSAGE, (Throwable)e);
            }
            logger.debug(END_OF_STREAM_MESSAGE);
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            try {
                Throwable throwable = null;
                Object var7_13 = null;
                try (BufferedReader br = new BufferedReader(new InputStreamReader(is));){
                    String line;
                    while ((line = br.readLine()) != null) {
                        stringBuilder.append(String.valueOf(line) + "\n");
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                logger.warn(INPUT_STREAM_MESSAGE, (Throwable)e);
            }
            listener.processInputStream(stringBuilder.toString());
            logger.debug(END_OF_STREAM_MESSAGE);
        }
    }

    private void readBTSnoopStreamFully(InputStream is, BTSnoopListener listener) {
        this.parser.setInputStream(is);
        try {
            while (this.btSnoopReady) {
                if (is == null) continue;
                byte[] packet = this.parser.readRecord();
                listener.processBTSnoopRecord(packet);
            }
        }
        catch (IOException e) {
            logger.warn(INPUT_STREAM_MESSAGE, (Throwable)e);
        }
        logger.debug(END_OF_STREAM_MESSAGE);
    }

    private void readErrorStreamFully(InputStream is, BluetoothProcessListener listener) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(is));){
                int ch;
                while ((ch = br.read()) != -1) {
                    stringBuilder.append((char)ch);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            logger.warn(ERROR_STREAM_MESSAGE, (Throwable)e);
        }
        listener.processErrorStream(stringBuilder.toString());
        logger.debug(END_OF_STREAM_MESSAGE);
    }

    private void readBTErrorStreamFully(InputStream is, BTSnoopListener listener) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(is));){
                int ch;
                while ((ch = br.read()) != -1) {
                    stringBuilder.append((char)ch);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            logger.warn(ERROR_STREAM_MESSAGE, (Throwable)e);
        }
        listener.processErrorStream(stringBuilder.toString());
        logger.debug(END_OF_STREAM_MESSAGE);
    }

    private void closeStreams() {
        logger.info("Closing streams and killing...");
        this.closeQuietly(this.outputStream);
        this.closeQuietly(this.errorStream);
        this.closeQuietly(this.readOutputStream);
        this.closeQuietly(this.readErrorStream);
        this.closeQuietly(this.inputStream);
        this.closeQuietly(this.writeInputStream);
        if (this.futureInputGobbler != null) {
            this.futureInputGobbler.cancel(true);
        }
        if (this.futureErrorGobbler != null) {
            this.futureErrorGobbler.cancel(true);
        }
    }

    private void closeQuietly(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                logger.warn("Failed to close process input stream", (Throwable)e);
            }
        }
    }

    private void closeQuietly(OutputStream os) {
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException e) {
                logger.warn("Failed to close process output stream", (Throwable)e);
            }
        }
    }
}

