/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.cloud;

import org.eclipse.kura.core.cloud.CloudServiceImpl;
import org.eclipse.kura.core.cloud.CloudServiceOptions;
import org.eclipse.kura.core.cloud.LifeCyclePayloadBuilder;
import org.eclipse.kura.message.KuraPayload;

public class LifecycleMessage {
    private StringBuilder topicBuilder;
    private LifeCyclePayloadBuilder payloadBuilder;
    private KuraPayload payload;
    private boolean isAppCertificateMessage = false;
    private boolean isBirthCertificateMessage = false;
    private int qos = 0;

    public LifecycleMessage(CloudServiceOptions options, CloudServiceImpl cloudServiceImpl) {
        this.topicBuilder = new StringBuilder(options.getTopicControlPrefix());
        this.topicBuilder.append(CloudServiceOptions.getTopicSeparator()).append(CloudServiceOptions.getTopicAccountToken()).append(CloudServiceOptions.getTopicSeparator()).append(CloudServiceOptions.getTopicClientIdToken()).append(CloudServiceOptions.getTopicSeparator());
        this.payloadBuilder = new LifeCyclePayloadBuilder(cloudServiceImpl);
    }

    public LifecycleMessage asBirthCertificateMessage() {
        this.topicBuilder.append(CloudServiceOptions.getTopicBirthSuffix());
        this.payload = this.payloadBuilder.buildBirthPayload();
        this.isBirthCertificateMessage = true;
        this.qos = 1;
        return this;
    }

    public LifecycleMessage asAppCertificateMessage() {
        this.topicBuilder.append(CloudServiceOptions.getTopicAppsSuffix());
        this.payload = this.payloadBuilder.buildBirthPayload();
        this.isAppCertificateMessage = true;
        this.qos = 1;
        return this;
    }

    public LifecycleMessage asDisconnectCertificateMessage() {
        this.topicBuilder.append(CloudServiceOptions.getTopicDisconnectSuffix());
        this.payload = this.payloadBuilder.buildDisconnectPayload();
        return this;
    }

    public String getTopic() {
        return this.topicBuilder.toString();
    }

    public KuraPayload getPayload() {
        return this.payload;
    }

    public boolean isAppCertificateMessage() {
        return this.isAppCertificateMessage;
    }

    public boolean isBirthCertificateMessage() {
        return this.isBirthCertificateMessage;
    }

    public int getQos() {
        return this.qos;
    }
}

