/*
 * Decompiled with CFR 0.152.
 */
package org.usb4java;

import java.nio.ByteBuffer;
import org.usb4java.DeviceHandle;
import org.usb4java.IsoPacketDescriptor;
import org.usb4java.TransferCallback;

public final class Transfer {
    private long transferPointer;
    private ByteBuffer transferBuffer;

    Transfer() {
    }

    public long getPointer() {
        return this.transferPointer;
    }

    public native DeviceHandle devHandle();

    public native void setDevHandle(DeviceHandle var1);

    public native byte flags();

    public native void setFlags(byte var1);

    public native byte endpoint();

    public native void setEndpoint(byte var1);

    public native byte type();

    public native void setType(byte var1);

    public native long timeout();

    public native void setTimeout(long var1);

    public native int status();

    public native int length();

    public void setLength(int length) {
        if (length != 0) {
            if (this.transferBuffer == null) {
                throw new IllegalArgumentException("buffer is null, only a length of 0 is allowed");
            }
            if (this.transferBuffer.capacity() < length) {
                throw new IllegalArgumentException("buffer too small for requested length");
            }
        }
        this.setLengthNative(length);
    }

    native void setLengthNative(int var1);

    public native int actualLength();

    public native TransferCallback callback();

    public native void setCallback(TransferCallback var1);

    public native Object userData();

    public native void setUserData(Object var1);

    public ByteBuffer buffer() {
        return this.transferBuffer;
    }

    public void setBuffer(ByteBuffer buffer) {
        this.setBufferNative(buffer);
        if (buffer != null) {
            this.setLengthNative(buffer.capacity());
        } else {
            this.setLengthNative(0);
        }
        this.transferBuffer = buffer;
    }

    native void setBufferNative(ByteBuffer var1);

    public native int numIsoPackets();

    public native void setNumIsoPackets(int var1);

    public native IsoPacketDescriptor[] isoPacketDesc();

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.transferPointer ^ this.transferPointer >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Transfer other = (Transfer)obj;
        return this.transferPointer == other.transferPointer;
    }

    public String toString() {
        return String.format("libusb transfer 0x%x", this.transferPointer);
    }
}

