/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.xml.marshaller.unmarshaller;

import java.util.List;
import org.eclipse.kura.core.inventory.resources.SystemPackage;
import org.eclipse.kura.core.inventory.resources.SystemPackages;
import org.eclipse.kura.internal.xml.marshaller.unmarshaller.XmlJavaDataMapper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlJavaSystemPackagesMapper
implements XmlJavaDataMapper {
    private static final String SYSTEM_PACKAGES = "systemPackages";
    private static final String SYSTEM_PACKAGES_PACKAGE = "systemPackage";
    private static final String SYSTEM_PACKAGES_PACKAGE_NAME = "name";
    private static final String SYSTEM_PACKAGES_PACKAGE_VERSION = "version";
    private static final String SYSTEM_PACKAGES_PACKAGE_TYPE = "type";

    @Override
    public Element marshal(Document doc, Object object) throws Exception {
        Element packages = doc.createElement(SYSTEM_PACKAGES);
        doc.appendChild(packages);
        SystemPackages xmlPackages = (SystemPackages)object;
        List xmlPackagesList = xmlPackages.getSystemPackages();
        xmlPackagesList.stream().forEach(xmlPackage -> {
            Element p = doc.createElement(SYSTEM_PACKAGES_PACKAGE);
            XmlJavaSystemPackagesMapper.marshallPackage(doc, xmlPackage, p);
            packages.appendChild(p);
        });
        return packages;
    }

    @Override
    public <T> T unmarshal(Document doc) throws Exception {
        return null;
    }

    private static void marshallPackage(Document doc, SystemPackage systemPackage, Element p) {
        String packageName = systemPackage.getName();
        String packageVersion = systemPackage.getVersion();
        String packageType = systemPackage.getTypeString();
        if (packageName != null && !packageName.trim().isEmpty()) {
            Element name = doc.createElement(SYSTEM_PACKAGES_PACKAGE_NAME);
            name.setTextContent(packageName);
            p.appendChild(name);
        }
        if (packageVersion != null && !packageVersion.trim().isEmpty()) {
            Element version = doc.createElement(SYSTEM_PACKAGES_PACKAGE_VERSION);
            version.setTextContent(packageVersion);
            p.appendChild(version);
        }
        if (packageType != null && !packageType.trim().isEmpty()) {
            Element type = doc.createElement(SYSTEM_PACKAGES_PACKAGE_TYPE);
            type.setTextContent(packageType);
            p.appendChild(type);
        }
    }
}

