/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.keystore.crl;

import java.io.File;
import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.kura.util.configuration.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRLManagerOptions {
    private static final Logger logger = LoggerFactory.getLogger(CRLManagerOptions.class);
    private static final Property<Boolean> CRL_MANAGEMENT_ENABLED = new Property("crl.management.enabled", (Object)false);
    private static final Property<Long> CRL_UPDATE_INTERVAL = new Property("crl.update.interval", (Object)1L);
    private static final Property<String> CRL_UPDATE_INTERVAL_TIME_UNIT = new Property("crl.update.interval.time.unit", (Object)TimeUnit.DAYS.name());
    private static final Property<Long> CRL_CHECK_INTERVAL = new Property("crl.check.interval", (Object)5L);
    private static final Property<String> CRL_CHECK_INTERVAL_TIME_UNIT = new Property("crl.check.interval.time.unit", (Object)TimeUnit.MINUTES.name());
    private static final Property<String[]> CRL_URLS = new Property("crl.urls", (Object)new String[0]);
    private static final Property<String> CRL_STORE_PATH = new Property("crl.store.path", String.class);
    private static final Property<Boolean> CRL_VERIFICATION_ENABLED = new Property("verify.crl", (Object)true);
    private final boolean crlManagementEnabled;
    private final long crlUpdateIntervalMs;
    private final long crlCheckIntervalMs;
    private final Set<URI> crlURIs;
    private final Optional<File> crlStore;
    private final boolean verifyCRL;

    public CRLManagerOptions(Map<String, Object> properties) {
        this.crlManagementEnabled = (Boolean)CRL_MANAGEMENT_ENABLED.get(properties);
        this.crlUpdateIntervalMs = CRLManagerOptions.extractInterval(properties, CRL_UPDATE_INTERVAL, CRL_UPDATE_INTERVAL_TIME_UNIT);
        this.crlCheckIntervalMs = CRLManagerOptions.extractInterval(properties, CRL_CHECK_INTERVAL, CRL_CHECK_INTERVAL_TIME_UNIT);
        this.crlURIs = CRLManagerOptions.extractCrlURIs(properties);
        this.crlStore = CRL_STORE_PATH.getOptional(properties).filter(s -> !s.trim().isEmpty()).map(File::new);
        this.verifyCRL = (Boolean)CRL_VERIFICATION_ENABLED.get(properties);
    }

    public boolean isCrlManagementEnabled() {
        return this.crlManagementEnabled;
    }

    public long getCrlUpdateIntervalMs() {
        return this.crlUpdateIntervalMs;
    }

    public long getCrlCheckIntervalMs() {
        return this.crlCheckIntervalMs;
    }

    public Set<URI> getCrlURIs() {
        return this.crlURIs;
    }

    public Optional<File> getStoreFile() {
        return this.crlStore;
    }

    public boolean isCRLVerificationEnabled() {
        return this.verifyCRL;
    }

    private static long extractInterval(Map<String, Object> properties, Property<Long> valueProperty, Property<String> timeUnitProperty) {
        long updateInterval = (Long)valueProperty.get(properties);
        TimeUnit timeUnit = TimeUnit.valueOf((String)timeUnitProperty.get(properties));
        return timeUnit.toMillis(updateInterval);
    }

    private static Set<URI> extractCrlURIs(Map<String, Object> properties) {
        String[] values = (String[])CRL_URLS.get(properties);
        HashSet<URI> result = new HashSet<URI>();
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            if (value != null && !value.trim().isEmpty()) {
                try {
                    result.add(new URI(value));
                }
                catch (Exception e) {
                    logger.warn("failed to parse URL: {}", (Object)value, (Object)e);
                }
            }
            ++n2;
        }
        return result;
    }

    public int hashCode() {
        return Objects.hash(this.crlCheckIntervalMs, this.crlManagementEnabled, this.crlStore, this.crlURIs, this.crlUpdateIntervalMs, this.verifyCRL);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CRLManagerOptions)) {
            return false;
        }
        CRLManagerOptions other = (CRLManagerOptions)obj;
        return this.crlCheckIntervalMs == other.crlCheckIntervalMs && this.crlManagementEnabled == other.crlManagementEnabled && Objects.equals(this.crlStore, other.crlStore) && Objects.equals(this.crlURIs, other.crlURIs) && this.crlUpdateIntervalMs == other.crlUpdateIntervalMs && this.verifyCRL == other.verifyCRL;
    }
}

