/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.dom.DOMText;
import org.eclipse.lemminx.dom.parser.Scanner;
import org.eclipse.lemminx.dom.parser.TokenType;
import org.eclipse.lemminx.dom.parser.XMLScanner;
import org.eclipse.lemminx.services.HoverRequest;
import org.eclipse.lemminx.services.extensions.IHoverParticipant;
import org.eclipse.lemminx.services.extensions.XMLExtensionsRegistry;
import org.eclipse.lemminx.settings.XMLHoverSettings;
import org.eclipse.lemminx.utils.MarkupContentFactory;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

class XMLHover {
    private static final Logger LOGGER = Logger.getLogger(XMLHover.class.getName());
    private final XMLExtensionsRegistry extensionsRegistry;

    public XMLHover(XMLExtensionsRegistry extensionsRegistry) {
        this.extensionsRegistry = extensionsRegistry;
    }

    public Hover doHover(DOMDocument xmlDocument, Position position, XMLHoverSettings settings, CancelChecker cancelChecker) {
        HoverRequest hoverRequest = null;
        try {
            hoverRequest = new HoverRequest(xmlDocument, position, settings, this.extensionsRegistry);
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, "Failed creating HoverRequest", e);
            return null;
        }
        int offset = hoverRequest.getOffset();
        DOMNode node = hoverRequest.getNode();
        if (node == null) {
            return null;
        }
        if (node.isElement() && ((DOMElement)node).getTagName() != null) {
            DOMElement element = (DOMElement)node;
            if (element.hasEndTag() && offset >= element.getEndTagOpenOffset()) {
                Range tagRange = this.getTagNameRange(TokenType.EndTag, element.getEndTagOpenOffset(), offset, xmlDocument);
                if (tagRange != null) {
                    return this.getTagHover(hoverRequest, tagRange, false);
                }
                return null;
            }
            Range tagRange = this.getTagNameRange(TokenType.StartTag, node.getStart(), offset, xmlDocument);
            if (tagRange != null) {
                return this.getTagHover(hoverRequest, tagRange, true);
            }
        } else {
            if (node.isAttribute()) {
                DOMAttr attr = (DOMAttr)node;
                if (attr.valueContainsOffset(offset)) {
                    return this.getAttrValueHover(hoverRequest, null);
                }
                return this.getAttrNameHover(hoverRequest, null);
            }
            if (node.isText()) {
                DOMText text = (DOMText)node;
                try {
                    Range textRange = new Range(xmlDocument.positionAt(text.getStart()), xmlDocument.positionAt(text.getEnd()));
                    return this.getTextHover(hoverRequest, textRange);
                }
                catch (BadLocationException e) {
                    LOGGER.log(Level.SEVERE, "While creating Range in XMLHover the text's Offset was a BadLocation", e);
                }
            }
        }
        return null;
    }

    private Hover getTextHover(HoverRequest hoverRequest, Range textRange) {
        hoverRequest.setTagRange(textRange);
        ArrayList<String> contentValues = new ArrayList<String>();
        for (IHoverParticipant participant : this.extensionsRegistry.getHoverParticipants()) {
            try {
                String contentValue = participant.onText(hoverRequest);
                if (contentValue == null) continue;
                contentValues.add(contentValue);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "While performing IHoverParticipant#onTagText", e);
            }
        }
        return XMLHover.createHover(contentValues, hoverRequest);
    }

    private Hover getTagHover(HoverRequest hoverRequest, Range tagRange, boolean open) {
        hoverRequest.setTagRange(tagRange);
        hoverRequest.setOpen(open);
        ArrayList<String> contentValues = new ArrayList<String>();
        for (IHoverParticipant participant : this.extensionsRegistry.getHoverParticipants()) {
            try {
                String contentValue = participant.onTag(hoverRequest);
                if (contentValue == null) continue;
                contentValues.add(contentValue);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "While performing IHoverParticipant#onTag", e);
            }
        }
        return XMLHover.createHover(contentValues, hoverRequest);
    }

    private Range getTagNameRange(TokenType tokenType, int startOffset, int offset, DOMDocument document) {
        Scanner scanner = XMLScanner.createScanner(document.getText(), startOffset);
        TokenType token = scanner.scan();
        while (token != TokenType.EOS && (scanner.getTokenEnd() < offset || scanner.getTokenEnd() == offset && token != tokenType)) {
            token = scanner.scan();
        }
        if (token == tokenType && offset <= scanner.getTokenEnd()) {
            try {
                return new Range(document.positionAt(scanner.getTokenOffset()), document.positionAt(scanner.getTokenEnd()));
            }
            catch (BadLocationException e) {
                LOGGER.log(Level.SEVERE, "While creating Range in XMLHover the Scanner's Offset was a BadLocation", e);
                return null;
            }
        }
        return null;
    }

    private Hover getAttrNameHover(HoverRequest hoverRequest, Range attrRange) {
        ArrayList<String> contentValues = new ArrayList<String>();
        for (IHoverParticipant participant : this.extensionsRegistry.getHoverParticipants()) {
            try {
                String contentValue = participant.onAttributeName(hoverRequest);
                if (contentValue == null) continue;
                contentValues.add(contentValue);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "While performing IHoverParticipant#onTag", e);
            }
        }
        return XMLHover.createHover(contentValues, hoverRequest);
    }

    private Hover getAttrValueHover(HoverRequest hoverRequest, Range attrRange) {
        ArrayList<String> contentValues = new ArrayList<String>();
        for (IHoverParticipant participant : this.extensionsRegistry.getHoverParticipants()) {
            try {
                String contentValue = participant.onAttributeValue(hoverRequest);
                if (contentValue == null) continue;
                contentValues.add(contentValue);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "While performing IHoverParticipant#onTag", e);
            }
        }
        return XMLHover.createHover(contentValues, hoverRequest);
    }

    private static Hover createHover(List<String> contentValues, HoverRequest hoverRequest) {
        if (!contentValues.isEmpty()) {
            return new Hover(MarkupContentFactory.creatMarkupContent(contentValues, hoverRequest), hoverRequest.getTagRange());
        }
        return null;
    }
}

