/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.dom;

import java.util.List;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.dom.DTDDeclNode;
import org.eclipse.lemminx.dom.DTDDeclParameter;
import org.eclipse.lemminx.dom.DTDEntityDecl;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;

public class DOMDocumentType
extends DTDDeclNode
implements DocumentType {
    private DOMNode.XMLNamedNodeMap<DTDEntityDecl> entitiesNodes;
    DTDDeclParameter kind;
    DTDDeclParameter publicId;
    DTDDeclParameter systemId;
    DTDDeclParameter internalSubset;
    private String content;

    public DOMDocumentType(int start, int end) {
        super(start, end);
    }

    @Override
    public DOMDocumentType getOwnerDocType() {
        return this;
    }

    @Override
    public String getTextContent() {
        if (this.content == null) {
            this.content = this.getOwnerDocument().getText().substring(this.getStart(), this.getEnd());
        }
        return this.content;
    }

    public String getKind() {
        return this.kind != null ? this.kind.getParameter() : null;
    }

    public DTDDeclParameter getKindNode() {
        return this.kind;
    }

    void setKind(int start, int end) {
        this.kind = this.addNewParameter(start, end);
    }

    @Override
    public String getNodeName() {
        return this.getName();
    }

    @Override
    public short getNodeType() {
        return 10;
    }

    @Override
    public NamedNodeMap getEntities() {
        if (this.entitiesNodes == null) {
            this.entitiesNodes = new DOMNode.XMLNamedNodeMap();
            List<DOMNode> children = super.getChildren();
            for (DOMNode child : children) {
                if (child.getNodeType() != 6) continue;
                this.entitiesNodes.add((DTDEntityDecl)child);
            }
        }
        return this.entitiesNodes;
    }

    @Override
    public String getInternalSubset() {
        if (this.internalSubset != null) {
            return this.internalSubset.getParameterWithoutFirstAndLastChar();
        }
        return null;
    }

    public void setStartInternalSubset(int start) {
        this.internalSubset = this.addNewParameter(start, start + 1);
    }

    public void setEndInternalSubset(int end) {
        this.updateLastParameterEnd(end);
    }

    public boolean isInternalSubset(DTDDeclParameter parameter) {
        if (this.internalSubset != null) {
            return this.internalSubset.equals(parameter);
        }
        return false;
    }

    @Override
    public NamedNodeMap getNotations() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getPublicId() {
        return this.publicId != null ? this.publicId.getParameter() : null;
    }

    public String getPublicIdWithoutQuotes() {
        return this.publicId != null ? this.publicId.getParameterWithoutFirstAndLastChar() : null;
    }

    void setPublicId(int start, int end) {
        this.publicId = this.addNewParameter(start, end);
    }

    @Override
    public String getSystemId() {
        return this.systemId != null ? this.systemId.getParameter() : null;
    }

    public DTDDeclParameter getSystemIdNode() {
        return this.systemId;
    }

    public String getSystemIdWithoutQuotes() {
        return this.systemId != null ? this.systemId.getParameterWithoutFirstAndLastChar() : null;
    }

    void setSystemId(int start, int end) {
        this.systemId = this.addNewParameter(start, end);
    }

    public String getSubstring(int start, int end) {
        String textContent = this.getTextContent();
        if (textContent == null) {
            return null;
        }
        return textContent.substring(start - this.getStart(), end - this.getStart());
    }

    public static enum DocumentTypeKind {
        PUBLIC,
        SYSTEM,
        INVALID;

    }
}

