/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.generators;

import java.util.Arrays;
import java.util.Map;
import org.eclipse.lemminx.extensions.generators.Cardinality;
import org.eclipse.lemminx.extensions.generators.ChildrenProperties;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ChildrenPropertiesTest {
    @Test
    public void sequence() {
        ChildrenProperties properties = new ChildrenProperties();
        properties.addChildHierarchy(Arrays.asList("a", "b"));
        properties.addChildHierarchy(Arrays.asList("a", "b"));
        Assertions.assertTrue((boolean)properties.isSequenced(), (String)"Child properties should be sequenced.");
        Assertions.assertEquals((Object)"a [1-1]b [1-1]", (Object)ChildrenPropertiesTest.toString(properties));
    }

    @Test
    public void choice() {
        ChildrenProperties properties = new ChildrenProperties();
        properties.addChildHierarchy(Arrays.asList("a", "b"));
        properties.addChildHierarchy(Arrays.asList("b", "a"));
        Assertions.assertFalse((boolean)properties.isSequenced(), (String)"Child properties should be choiced.");
        Assertions.assertEquals((Object)"a [1-1]b [1-1]", (Object)ChildrenPropertiesTest.toString(properties));
    }

    @Test
    public void optionalOnFirst() {
        ChildrenProperties properties = new ChildrenProperties();
        properties.addChildHierarchy(Arrays.asList("a", "b", "c"));
        properties.addChildHierarchy(Arrays.asList("a", "b"));
        Assertions.assertTrue((boolean)properties.isSequenced(), (String)"Child properties should be sequenced.");
        Assertions.assertEquals((Object)"a [1-1]b [1-1]c [0-1]", (Object)ChildrenPropertiesTest.toString(properties));
    }

    @Test
    public void optionalOnLast() {
        ChildrenProperties properties = new ChildrenProperties();
        properties.addChildHierarchy(Arrays.asList("a", "b"));
        properties.addChildHierarchy(Arrays.asList("a", "b", "c"));
        Assertions.assertTrue((boolean)properties.isSequenced(), (String)"Child properties should be sequenced.");
        Assertions.assertEquals((Object)"a [1-1]b [1-1]c [0-1]", (Object)ChildrenPropertiesTest.toString(properties));
    }

    @Test
    public void complex() {
        ChildrenProperties properties = new ChildrenProperties();
        properties.addChildHierarchy(Arrays.asList("a", "c"));
        properties.addChildHierarchy(Arrays.asList("a", "c", "c"));
        properties.addChildHierarchy(Arrays.asList("a", "b", "c"));
        Assertions.assertTrue((boolean)properties.isSequenced(), (String)"Child properties should be sequenced.");
        Assertions.assertEquals((Object)"a [1-1]c [1-2]b [0-1]", (Object)ChildrenPropertiesTest.toString(properties));
    }

    private static String toString(ChildrenProperties properties) {
        StringBuilder result = new StringBuilder();
        for (Map.Entry entry : properties.getCardinalities().entrySet()) {
            result.append((String)entry.getKey());
            result.append(" ");
            result.append(((Cardinality)entry.getValue()).toString());
        }
        return result.toString();
    }
}

